/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.DB;

public class ProductCategoryAcctCopy
extends SvrProcess {
    private int p_M_Product_Category_ID = 0;
    private int p_C_AcctSchema_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Product_Category_ID")) {
                    this.p_M_Product_Category_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_AcctSchema_ID")) {
                    this.p_C_AcctSchema_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_AcctSchema_ID=" + this.p_C_AcctSchema_ID);
        }
        if (this.p_C_AcctSchema_ID == 0) {
            throw new AdempiereSystemError("C_AcctSchema_ID=0");
        }
        MAcctSchema as = MAcctSchema.get((Properties)this.getCtx(), (int)this.p_C_AcctSchema_ID);
        if (as.get_ID() == 0) {
            throw new AdempiereSystemError("Not Found - C_AcctSchema_ID=" + this.p_C_AcctSchema_ID);
        }
        StringBuilder sql = new StringBuilder("UPDATE M_Product_Acct pa ").append("SET (P_Revenue_Acct,P_Expense_Acct,P_CostAdjustment_Acct,P_InventoryClearing_Acct,P_Asset_Acct,P_COGS_Acct,").append(" P_PurchasePriceVariance_Acct,P_InvoicePriceVariance_Acct,P_AverageCostVariance_Acct,").append(" P_TradeDiscountRec_Acct,P_TradeDiscountGrant_Acct,").append(" P_RateVariance_Acct,P_LandedCostClearing_Acct)=").append(" (SELECT P_Revenue_Acct,P_Expense_Acct,P_CostAdjustment_Acct,P_InventoryClearing_Acct,P_Asset_Acct,P_COGS_Acct,").append(" P_PurchasePriceVariance_Acct,P_InvoicePriceVariance_Acct,P_AverageCostVariance_Acct,").append(" P_TradeDiscountRec_Acct,P_TradeDiscountGrant_Acct,").append(" P_RateVariance_Acct,P_LandedCostClearing_Acct").append(" FROM M_Product_Category_Acct pca").append(" WHERE pca.M_Product_Category_ID=").append(this.p_M_Product_Category_ID).append(" AND pca.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append("), Updated=SysDate, UpdatedBy=0 ").append("WHERE pa.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND EXISTS (SELECT * FROM M_Product p ").append("WHERE p.M_Product_ID=pa.M_Product_ID").append(" AND p.M_Product_Category_ID=").append(this.p_M_Product_Category_ID).append(")");
        int updated = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(updated), "@Updated@");
        sql = new StringBuilder("INSERT INTO M_Product_Acct ").append("(M_Product_ID, C_AcctSchema_ID,").append(" AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,").append(" P_Revenue_Acct, P_Expense_Acct, P_CostAdjustment_Acct, P_InventoryClearing_Acct, P_Asset_Acct, P_CoGs_Acct,").append(" P_PurchasePriceVariance_Acct, P_InvoicePriceVariance_Acct, P_AverageCostVariance_Acct,").append(" P_TradeDiscountRec_Acct, P_TradeDiscountGrant_Acct, ").append(" P_RateVariance_Acct, P_LandedCostClearing_Acct) ").append("SELECT p.M_Product_ID, acct.C_AcctSchema_ID,").append(" p.AD_Client_ID, p.AD_Org_ID, 'Y', SysDate, 0, SysDate, 0,").append(" acct.P_Revenue_Acct, acct.P_Expense_Acct, acct.P_CostAdjustment_Acct, acct.P_InventoryClearing_Acct, acct.P_Asset_Acct, acct.P_CoGs_Acct,").append(" acct.P_PurchasePriceVariance_Acct, acct.P_InvoicePriceVariance_Acct, acct.P_AverageCostVariance_Acct,").append(" acct.P_TradeDiscountRec_Acct, acct.P_TradeDiscountGrant_Acct, ").append(" acct.P_RateVariance_Acct, acct.P_LandedCostClearing_Acct ").append("FROM M_Product p").append(" INNER JOIN M_Product_Category_Acct acct ON (acct.M_Product_Category_ID=p.M_Product_Category_ID)").append("WHERE acct.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND p.M_Product_Category_ID=").append(this.p_M_Product_Category_ID).append(" AND NOT EXISTS (SELECT * FROM M_Product_Acct pa ").append("WHERE pa.M_Product_ID=p.M_Product_ID").append(" AND pa.C_AcctSchema_ID=acct.C_AcctSchema_ID)");
        int created = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(created), "@Created@");
        StringBuilder msgreturn = new StringBuilder("@Created@=").append(created).append(", @Updated@=").append(updated);
        return msgreturn.toString();
    }
}

