/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class PaySelectionCreateFrom
extends SvrProcess {
    private boolean p_OnlyDiscount = false;
    private boolean p_OnlyDue = false;
    private boolean p_IncludeInDispute = false;
    private String p_MatchRequirement = "N";
    private String p_PaymentRule = null;
    private int p_C_BPartner_ID = 0;
    private int p_C_BP_Group_ID = 0;
    private int p_C_PaySelection_ID = 0;
    private Timestamp p_DueDate = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("OnlyDiscount")) {
                    this.p_OnlyDiscount = "Y".equals(para[i].getParameter());
                } else if (name.equals("OnlyDue")) {
                    this.p_OnlyDue = "Y".equals(para[i].getParameter());
                } else if (name.equals("IncludeInDispute")) {
                    this.p_IncludeInDispute = "Y".equals(para[i].getParameter());
                } else if (name.equals("MatchRequirement")) {
                    this.p_MatchRequirement = (String)para[i].getParameter();
                } else if (name.equals("PaymentRule")) {
                    this.p_PaymentRule = (String)para[i].getParameter();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BP_Group_ID")) {
                    this.p_C_BP_Group_ID = para[i].getParameterAsInt();
                } else if (name.equals("DueDate")) {
                    this.p_DueDate = (Timestamp)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_C_PaySelection_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        int lines;
        block30: {
            MPaySelection psel;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("C_PaySelection_ID=" + this.p_C_PaySelection_ID + ", OnlyDiscount=" + this.p_OnlyDiscount + ", OnlyDue=" + this.p_OnlyDue + ", IncludeInDispute=" + this.p_IncludeInDispute + ", MatchRequirement=" + this.p_MatchRequirement + ", PaymentRule=" + this.p_PaymentRule + ", C_BP_Group_ID=" + this.p_C_BP_Group_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID);
            }
            if ((psel = new MPaySelection(this.getCtx(), this.p_C_PaySelection_ID, this.get_TrxName())).get_ID() == 0) {
                throw new IllegalArgumentException("Not found C_PaySelection_ID=" + this.p_C_PaySelection_ID);
            }
            if (psel.isProcessed()) {
                throw new IllegalArgumentException("@Processed@");
            }
            if (this.p_DueDate == null) {
                this.p_DueDate = psel.getPayDate();
            }
            StringBuilder sql = new StringBuilder("SELECT C_Invoice_ID,").append(" currencyConvert(invoiceOpen(i.C_Invoice_ID, 0)").append(",i.C_Currency_ID, ?,?, i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID),").append(" currencyConvert(paymentTermDiscount(i.GrandTotal,i.C_Currency_ID,i.C_PaymentTerm_ID,i.DateInvoiced, ?)").append(",i.C_Currency_ID, ?,?,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID),").append(" PaymentRule, IsSOTrx ").append("FROM C_Invoice i ").append("WHERE IsSOTrx='N' AND IsPaid='N' AND DocStatus IN ('CO','CL')").append(" AND AD_Client_ID=?").append(" AND NOT EXISTS (SELECT * FROM C_PaySelectionLine psl").append(" INNER JOIN C_PaySelectionCheck psc ON (psl.C_PaySelectionCheck_ID=psc.C_PaySelectionCheck_ID)").append(" LEFT OUTER JOIN C_Payment pmt ON (pmt.C_Payment_ID=psc.C_Payment_ID)").append(" WHERE i.C_Invoice_ID=psl.C_Invoice_ID AND psl.IsActive='Y'").append(" AND (pmt.DocStatus IS NULL OR pmt.DocStatus NOT IN ('VO','RE')) )");
            if (!this.p_IncludeInDispute) {
                sql.append(" AND i.IsInDispute='N'");
            }
            if (this.p_PaymentRule != null) {
                sql.append(" AND PaymentRule=?");
            }
            if (this.p_OnlyDiscount) {
                if (this.p_OnlyDue) {
                    sql.append(" AND (");
                } else {
                    sql.append(" AND ");
                }
                sql.append("paymentTermDiscount(invoiceOpen(C_Invoice_ID, 0), C_Currency_ID, C_PaymentTerm_ID, DateInvoiced, ?) > 0");
            }
            if (this.p_OnlyDue) {
                if (this.p_OnlyDiscount) {
                    sql.append(" OR ");
                } else {
                    sql.append(" AND ");
                }
                sql.append("paymentTermDueDays(C_PaymentTerm_ID, DateInvoiced, ?) >= 0");
                if (this.p_OnlyDiscount) {
                    sql.append(")");
                }
            }
            if (this.p_C_BPartner_ID != 0) {
                sql.append(" AND C_BPartner_ID=?");
            } else if (this.p_C_BP_Group_ID != 0) {
                sql.append(" AND EXISTS (SELECT * FROM C_BPartner bp ").append("WHERE bp.C_BPartner_ID=i.C_BPartner_ID AND bp.C_BP_Group_ID=?)");
            }
            if (this.p_MatchRequirement.equals("P") || this.p_MatchRequirement.equals("B")) {
                sql.append(" AND EXISTS (SELECT * FROM C_InvoiceLine il ").append("WHERE i.C_Invoice_ID=il.C_Invoice_ID").append(" AND QtyInvoiced=(SELECT SUM(Qty) FROM M_MatchPO m ").append("WHERE il.C_InvoiceLine_ID=m.C_InvoiceLine_ID))");
            }
            if (this.p_MatchRequirement.equals("R") || this.p_MatchRequirement.equals("B")) {
                sql.append(" AND EXISTS (SELECT * FROM C_InvoiceLine il ").append("WHERE i.C_Invoice_ID=il.C_Invoice_ID").append(" AND QtyInvoiced=(SELECT SUM(Qty) FROM M_MatchInv m ").append("WHERE il.C_InvoiceLine_ID=m.C_InvoiceLine_ID))");
            }
            lines = 0;
            int C_CurrencyTo_ID = psel.getC_Currency_ID();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    int index = 1;
                    pstmt.setInt(index++, C_CurrencyTo_ID);
                    pstmt.setTimestamp(index++, psel.getPayDate());
                    pstmt.setTimestamp(index++, psel.getPayDate());
                    pstmt.setInt(index++, C_CurrencyTo_ID);
                    pstmt.setTimestamp(index++, psel.getPayDate());
                    pstmt.setInt(index++, psel.getAD_Client_ID());
                    if (this.p_PaymentRule != null) {
                        pstmt.setString(index++, this.p_PaymentRule);
                    }
                    if (this.p_OnlyDiscount) {
                        pstmt.setTimestamp(index++, psel.getPayDate());
                    }
                    if (this.p_OnlyDue) {
                        pstmt.setTimestamp(index++, this.p_DueDate);
                    }
                    if (this.p_C_BPartner_ID != 0) {
                        pstmt.setInt(index++, this.p_C_BPartner_ID);
                    } else if (this.p_C_BP_Group_ID != 0) {
                        pstmt.setInt(index++, this.p_C_BP_Group_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int C_Invoice_ID = rs.getInt(1);
                        BigDecimal PayAmt = rs.getBigDecimal(2);
                        if (C_Invoice_ID == 0 || Env.ZERO.compareTo(PayAmt) == 0) continue;
                        BigDecimal DiscountAmt = rs.getBigDecimal(3);
                        String PaymentRule = rs.getString(4);
                        boolean isSOTrx = "Y".equals(rs.getString(5));
                        MPaySelectionLine pselLine = new MPaySelectionLine(psel, ++lines * 10, PaymentRule);
                        pselLine.setInvoice(C_Invoice_ID, isSOTrx, PayAmt, PayAmt.subtract(DiscountAmt), DiscountAmt);
                        if (pselLine.save()) continue;
                        throw new IllegalStateException("Cannot save MPaySelectionLine");
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block30;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        StringBuilder msgreturn = new StringBuilder("@C_PaySelectionLine_ID@  - #").append(lines);
        return msgreturn.toString();
    }
}

