/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class OrderRePrice
extends SvrProcess {
    private int p_C_Order_ID = 0;
    private int p_C_Invoice_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Order_ID")) {
                    this.p_C_Order_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("C_Invoice_ID")) {
                    this.p_C_Invoice_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MOrderLine[] lines;
        BigDecimal oldPrice;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_Order_ID=" + this.p_C_Order_ID + ", C_Invoice_ID=" + this.p_C_Invoice_ID);
        }
        if (this.p_C_Order_ID == 0 && this.p_C_Invoice_ID == 0) {
            throw new IllegalArgumentException("Nothing to do");
        }
        StringBuilder retValue = new StringBuilder();
        if (this.p_C_Order_ID != 0) {
            MOrder order = new MOrder(this.getCtx(), this.p_C_Order_ID, this.get_TrxName());
            oldPrice = order.getGrandTotal();
            lines = order.getLines();
            int i = 0;
            while (i < lines.length) {
                lines[i].setPrice(order.getM_PriceList_ID());
                lines[i].saveEx();
                ++i;
            }
            order = new MOrder(this.getCtx(), this.p_C_Order_ID, this.get_TrxName());
            BigDecimal newPrice = order.getGrandTotal();
            retValue = new StringBuilder().append(order.getDocumentNo()).append(":  ").append(oldPrice).append(" -> ").append(newPrice);
        }
        if (this.p_C_Invoice_ID != 0) {
            MInvoice invoice = new MInvoice(this.getCtx(), this.p_C_Invoice_ID, null);
            oldPrice = invoice.getGrandTotal();
            lines = invoice.getLines(false);
            int i = 0;
            while (i < lines.length) {
                lines[i].setPrice(invoice.getM_PriceList_ID(), invoice.getC_BPartner_ID());
                lines[i].saveEx();
                ++i;
            }
            invoice = new MInvoice(this.getCtx(), this.p_C_Invoice_ID, null);
            BigDecimal newPrice = invoice.getGrandTotal();
            if (retValue.length() > 0) {
                retValue.append(Env.NL);
            }
            retValue.append(invoice.getDocumentNo()).append(":  ").append(oldPrice).append(" -> ").append(newPrice);
        }
        return retValue.toString();
    }
}

