/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MOrder;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class OrderBatchProcess
extends SvrProcess {
    private int p_C_DocTypeTarget_ID = 0;
    private String p_DocStatus = null;
    private int p_C_BPartner_ID = 0;
    private String p_IsSelfService = null;
    private Timestamp p_DateOrdered_From = null;
    private Timestamp p_DateOrdered_To = null;
    private String p_DocAction = null;
    private String p_IsDelivered = null;
    private String p_IsInvoiced = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null || para[i].getParameter_To() != null) {
                if (name.equals("C_DocTypeTarget_ID")) {
                    this.p_C_DocTypeTarget_ID = para[i].getParameterAsInt();
                } else if (name.equals("DocStatus")) {
                    this.p_DocStatus = (String)para[i].getParameter();
                } else if (name.equals("IsSelfService")) {
                    this.p_IsSelfService = (String)para[i].getParameter();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("DateOrdered")) {
                    this.p_DateOrdered_From = (Timestamp)para[i].getParameter();
                    this.p_DateOrdered_To = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("DocAction")) {
                    this.p_DocAction = (String)para[i].getParameter();
                } else if (name.equals("IsDelivered")) {
                    this.p_IsDelivered = (String)para[i].getParameter();
                } else if (name.equals("IsInvoiced")) {
                    this.p_IsInvoiced = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int errCounter;
        int counter;
        block21: {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("C_DocTypeTarget_ID=" + this.p_C_DocTypeTarget_ID + ", DocStatus=" + this.p_DocStatus + ", IsSelfService=" + this.p_IsSelfService + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", DateOrdered=" + this.p_DateOrdered_From + "->" + this.p_DateOrdered_To + ", DocAction=" + this.p_DocAction + ", IsDelivered=" + this.p_IsDelivered + ", IsInvoiced=" + this.p_IsInvoiced);
            }
            if (this.p_C_DocTypeTarget_ID == 0) {
                throw new AdempiereUserError("@NotFound@: @C_DocTypeTarget_ID@");
            }
            if (this.p_DocStatus == null || this.p_DocStatus.length() != 2) {
                throw new AdempiereUserError("@NotFound@: @DocStatus@");
            }
            if (this.p_DocAction == null || this.p_DocAction.length() != 2) {
                throw new AdempiereUserError("@NotFound@: @DocAction@");
            }
            StringBuilder sql = new StringBuilder("SELECT * FROM C_Order o ").append(" WHERE o.C_DocTypeTarget_ID=? AND o.DocStatus=? ");
            if (this.p_IsSelfService != null && this.p_IsSelfService.length() == 1) {
                sql.append(" AND o.IsSelfService='").append(this.p_IsSelfService).append("'");
            }
            if (this.p_C_BPartner_ID != 0) {
                sql.append(" AND o.C_BPartner_ID=").append(this.p_C_BPartner_ID);
            }
            if (this.p_DateOrdered_From != null) {
                sql.append(" AND TRUNC(o.DateOrdered) >= ").append(DB.TO_DATE((Timestamp)this.p_DateOrdered_From, (boolean)true));
            }
            if (this.p_DateOrdered_To != null) {
                sql.append(" AND TRUNC(o.DateOrdered) <= ").append(DB.TO_DATE((Timestamp)this.p_DateOrdered_To, (boolean)true));
            }
            if ("Y".equals(this.p_IsDelivered)) {
                sql.append(" AND NOT EXISTS (SELECT l.C_OrderLine_ID FROM C_OrderLine l ").append(" WHERE l.C_Order_ID=o.C_Order_ID AND l.QtyOrdered>l.QtyDelivered) ");
            } else if ("N".equals(this.p_IsDelivered)) {
                sql.append(" AND EXISTS (SELECT l.C_OrderLine_ID FROM C_OrderLine l ").append(" WHERE l.C_Order_ID=o.C_Order_ID AND l.QtyOrdered>l.QtyDelivered) ");
            }
            if ("Y".equals(this.p_IsInvoiced)) {
                sql.append(" AND NOT EXISTS (SELECT l.C_OrderLine_ID FROM C_OrderLine l ").append(" WHERE l.C_Order_ID=o.C_Order_ID AND l.QtyOrdered>l.QtyInvoiced) ");
            } else if ("N".equals(this.p_IsInvoiced)) {
                sql.append(" AND EXISTS (SELECT l.C_OrderLine_ID FROM C_OrderLine l ").append(" WHERE l.C_Order_ID=o.C_Order_ID AND l.QtyOrdered>l.QtyInvoiced) ");
            }
            counter = 0;
            errCounter = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    pstmt.setInt(1, this.p_C_DocTypeTarget_ID);
                    pstmt.setString(2, this.p_DocStatus);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if (this.process(new MOrder(this.getCtx(), rs, this.get_TrxName()))) {
                            ++counter;
                            continue;
                        }
                        ++errCounter;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block21;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        StringBuilder msgreturn = new StringBuilder("@Updated@=").append(counter).append(", @Errors@=").append(errCounter);
        return msgreturn.toString();
    }

    private boolean process(MOrder order) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(order.toString());
        }
        order.setDocAction(this.p_DocAction);
        if (order.processIt(this.p_DocAction)) {
            order.saveEx();
            this.addLog(0, null, null, String.valueOf(order.getDocumentNo()) + ": OK");
            return true;
        }
        this.log.warning("Order Process Failed: " + order + " - " + order.getProcessMsg());
        throw new IllegalStateException("Order Process Failed: " + order + " - " + order.getProcessMsg());
    }
}

