/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInventoryLineMA;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class InventoryCountCreate
extends SvrProcess {
    private int p_M_Inventory_ID = 0;
    private MInventory m_inventory = null;
    private int p_M_Locator_ID = 0;
    private String p_LocatorValue = null;
    private String p_ProductValue = null;
    private int p_M_Product_Category_ID = 0;
    private String p_QtyRange = null;
    private boolean p_InventoryCountSetZero = false;
    private boolean p_DeleteOld = false;
    private MInventoryLine m_line = null;
    private Timestamp oldDateMPolicy = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Locator_ID")) {
                    this.p_M_Locator_ID = para[i].getParameterAsInt();
                } else if (name.equals("LocatorValue")) {
                    this.p_LocatorValue = (String)para[i].getParameter();
                } else if (name.equals("ProductValue")) {
                    this.p_ProductValue = (String)para[i].getParameter();
                } else if (name.equals("M_Product_Category_ID")) {
                    this.p_M_Product_Category_ID = para[i].getParameterAsInt();
                } else if (name.equals("QtyRange")) {
                    this.p_QtyRange = (String)para[i].getParameter();
                } else if (name.equals("InventoryCountSet")) {
                    this.p_InventoryCountSetZero = "Z".equals(para[i].getParameter());
                } else if (name.equals("DeleteOld")) {
                    this.p_DeleteOld = "Y".equals(para[i].getParameter());
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_M_Inventory_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        int count;
        block29: {
            StringBuilder sql;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("M_Inventory_ID=" + this.p_M_Inventory_ID + ", M_Locator_ID=" + this.p_M_Locator_ID + ", LocatorValue=" + this.p_LocatorValue + ", ProductValue=" + this.p_ProductValue + ", M_Product_Category_ID=" + this.p_M_Product_Category_ID + ", QtyRange=" + this.p_QtyRange + ", DeleteOld=" + this.p_DeleteOld);
            }
            this.m_inventory = new MInventory(this.getCtx(), this.p_M_Inventory_ID, this.get_TrxName());
            if (this.m_inventory.get_ID() == 0) {
                throw new AdempiereSystemError("Not found: M_Inventory_ID=" + this.p_M_Inventory_ID);
            }
            if (this.m_inventory.isProcessed()) {
                throw new AdempiereSystemError("@M_Inventory_ID@ @Processed@");
            }
            if (this.p_DeleteOld) {
                StringBuilder sql1 = new StringBuilder("DELETE FROM M_InventoryLineMA ma WHERE EXISTS ").append("(SELECT * FROM M_InventoryLine l WHERE l.M_InventoryLine_ID=ma.M_InventoryLine_ID").append(" AND Processed='N' AND M_Inventory_ID=").append(this.p_M_Inventory_ID).append(")");
                int no1 = DB.executeUpdate((String)sql1.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("doIt - Deleted MA #" + no1);
                }
                StringBuilder sql2 = new StringBuilder("DELETE M_InventoryLine WHERE Processed='N' ").append("AND M_Inventory_ID=").append(this.p_M_Inventory_ID);
                int no = DB.executeUpdate((String)sql2.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("doIt - Deleted #" + no);
                }
            }
            if (this.p_QtyRange != null && this.p_QtyRange.equals("=")) {
                sql = new StringBuilder("INSERT INTO M_StorageOnHand ");
                sql.append("(AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,");
                sql.append(" M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID,");
                sql.append(" QtyOnHand, DateLastInventory) ");
                sql.append("SELECT l.AD_CLIENT_ID, l.AD_ORG_ID, 'Y', SysDate, 0,SysDate, 0,");
                sql.append(" l.M_Locator_ID, p.M_Product_ID, 0,");
                sql.append(" 0,null ");
                sql.append("FROM M_Locator l");
                sql.append(" INNER JOIN M_Product p ON (l.AD_Client_ID=p.AD_Client_ID) ");
                sql.append("WHERE l.M_Warehouse_ID=");
                sql.append(this.m_inventory.getM_Warehouse_ID());
                if (this.p_M_Locator_ID != 0) {
                    sql.append(" AND l.M_Locator_ID=").append(this.p_M_Locator_ID);
                }
                sql.append(" AND l.IsDefault='Y'").append(" AND p.IsActive='Y' AND p.IsStocked='Y' and p.ProductType='I'").append(" AND NOT EXISTS (SELECT * FROM M_StorageOnHand s").append(" INNER JOIN M_Locator sl ON (s.M_Locator_ID=sl.M_Locator_ID) ").append("WHERE sl.M_Warehouse_ID=l.M_Warehouse_ID").append(" AND s.M_Product_ID=p.M_Product_ID)");
                int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("'0' Inserted #" + no);
                }
            }
            sql = new StringBuilder("SELECT s.M_Product_ID, s.M_Locator_ID, s.M_AttributeSetInstance_ID,");
            sql.append(" s.QtyOnHand, p.M_AttributeSet_ID ,s.DateMaterialPolicy");
            sql.append(" FROM M_Product p");
            sql.append(" INNER JOIN M_StorageOnHand s ON (s.M_Product_ID=p.M_Product_ID)");
            sql.append(" INNER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID) ");
            sql.append("WHERE l.M_Warehouse_ID=?");
            sql.append(" AND p.IsActive='Y' AND p.IsStocked='Y' and p.ProductType='I'");
            if (this.p_M_Locator_ID != 0) {
                sql.append(" AND s.M_Locator_ID=?");
            }
            if (this.p_LocatorValue != null && (this.p_LocatorValue.trim().length() == 0 || this.p_LocatorValue.equals("%"))) {
                this.p_LocatorValue = null;
            }
            if (this.p_LocatorValue != null) {
                sql.append(" AND UPPER(l.Value) LIKE ?");
            }
            if (this.p_ProductValue != null && (this.p_ProductValue.trim().length() == 0 || this.p_ProductValue.equals("%"))) {
                this.p_ProductValue = null;
            }
            if (this.p_ProductValue != null) {
                sql.append(" AND UPPER(p.Value) LIKE ?");
            }
            if (this.p_M_Product_Category_ID != 0) {
                sql.append(" AND p.M_Product_Category_ID IN (").append(this.getSubCategoryWhereClause(this.p_M_Product_Category_ID)).append(")");
            }
            if (!this.p_DeleteOld) {
                sql.append(" AND NOT EXISTS (SELECT * FROM M_InventoryLine il ").append("WHERE il.M_Inventory_ID=?").append(" AND il.M_Product_ID=s.M_Product_ID").append(" AND il.M_Locator_ID=s.M_Locator_ID").append(" AND COALESCE(il.M_AttributeSetInstance_ID,0)=COALESCE(s.M_AttributeSetInstance_ID,0))");
            }
            sql.append(" ORDER BY l.Value, p.Value, s.QtyOnHand DESC");
            count = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    int index = 1;
                    pstmt.setInt(index++, this.m_inventory.getM_Warehouse_ID());
                    if (this.p_M_Locator_ID != 0) {
                        pstmt.setInt(index++, this.p_M_Locator_ID);
                    }
                    if (this.p_LocatorValue != null) {
                        pstmt.setString(index++, this.p_LocatorValue.toUpperCase());
                    }
                    if (this.p_ProductValue != null) {
                        pstmt.setString(index++, this.p_ProductValue.toUpperCase());
                    }
                    if (!this.p_DeleteOld) {
                        pstmt.setInt(index++, this.p_M_Inventory_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int M_Product_ID = rs.getInt(1);
                        int M_Locator_ID = rs.getInt(2);
                        int M_AttributeSetInstance_ID = rs.getInt(3);
                        BigDecimal QtyOnHand = rs.getBigDecimal(4);
                        if (QtyOnHand == null) {
                            QtyOnHand = Env.ZERO;
                        }
                        int M_AttributeSet_ID = rs.getInt(5);
                        Timestamp dateMpolicy = rs.getTimestamp(6);
                        int compare = QtyOnHand.compareTo(Env.ZERO);
                        if (!(this.p_QtyRange == null || this.p_QtyRange.equals(">") && compare > 0 || this.p_QtyRange.equals("<") && compare < 0 || this.p_QtyRange.equals("=") && compare == 0) && (!this.p_QtyRange.equals("N") || compare == 0)) continue;
                        count += this.createInventoryLine(M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, QtyOnHand, M_AttributeSet_ID, dateMpolicy);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block29;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.p_InventoryCountSetZero) {
            StringBuilder sql1 = new StringBuilder("UPDATE M_InventoryLine l ").append("SET QtyCount=0 ").append("WHERE M_Inventory_ID=").append(this.p_M_Inventory_ID);
            int no = DB.executeUpdate((String)sql1.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Set Cont to Zero=" + no);
            }
        }
        StringBuilder msgreturn = new StringBuilder("@M_InventoryLine_ID@ - #").append(count);
        return msgreturn.toString();
    }

    private int createInventoryLine(int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal QtyOnHand, int M_AttributeSet_ID, Timestamp dateMPolicy) {
        boolean oneLinePerASI = false;
        if (M_AttributeSet_ID != 0) {
            MAttributeSet mas = MAttributeSet.get((Properties)this.getCtx(), (int)M_AttributeSet_ID);
            oneLinePerASI = mas.isInstanceAttribute();
        }
        if (oneLinePerASI) {
            MInventoryLine line = new MInventoryLine(this.m_inventory, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, QtyOnHand, QtyOnHand);
            if (line.save()) {
                return 1;
            }
            return 0;
        }
        if (QtyOnHand.signum() == 0) {
            M_AttributeSetInstance_ID = 0;
        }
        if (this.m_line != null && this.m_line.getM_Locator_ID() == M_Locator_ID && this.m_line.getM_Product_ID() == M_Product_ID) {
            MInventoryLineMA ma;
            if (QtyOnHand.signum() == 0) {
                return 0;
            }
            if (this.m_line.getM_AttributeSetInstance_ID() == M_AttributeSetInstance_ID && (dateMPolicy == null && this.oldDateMPolicy == null || dateMPolicy != null && dateMPolicy.equals(this.oldDateMPolicy) || this.oldDateMPolicy != null && this.oldDateMPolicy.equals(dateMPolicy))) {
                this.m_line.setQtyBook(this.m_line.getQtyBook().add(QtyOnHand));
                this.m_line.setQtyCount(this.m_line.getQtyCount().add(QtyOnHand));
                this.m_line.saveEx();
                return 0;
            }
            if (this.m_line.getM_AttributeSetInstance_ID() == 0 || !(ma = new MInventoryLineMA(this.m_line, this.m_line.getM_AttributeSetInstance_ID(), this.m_line.getQtyBook(), this.oldDateMPolicy)).save()) {
                // empty if block
            }
            this.m_line.setM_AttributeSetInstance_ID(0);
            this.m_line.setQtyBook(this.m_line.getQtyBook().add(QtyOnHand));
            this.m_line.setQtyCount(this.m_line.getQtyCount().add(QtyOnHand));
            this.m_line.saveEx();
            ma = new MInventoryLineMA(this.m_line, M_AttributeSetInstance_ID, QtyOnHand, dateMPolicy);
            if (!ma.save()) {
                // empty if block
            }
            return 0;
        }
        this.m_line = new MInventoryLine(this.m_inventory, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, QtyOnHand, QtyOnHand);
        this.oldDateMPolicy = dateMPolicy;
        if (this.m_line.save()) {
            return 1;
        }
        return 0;
    }

    private String getSubCategoryWhereClause(int productCategoryId) throws SQLException, AdempiereSystemError {
        int subTreeRootParentId = 0;
        StringBuilder retString = new StringBuilder();
        String sql = " SELECT M_Product_Category_ID, M_Product_Category_Parent_ID FROM M_Product_Category";
        Vector<SimpleTreeNode> categories = new Vector<SimpleTreeNode>(100);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DB.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (rs.getInt(1) == productCategoryId) {
                    subTreeRootParentId = rs.getInt(2);
                }
                categories.add(new SimpleTreeNode(rs.getInt(1), rs.getInt(2)));
            }
            retString.append(this.getSubCategoriesString(productCategoryId, categories, subTreeRootParentId));
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)stmt);
            rs = null;
            stmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)stmt);
        rs = null;
        stmt = null;
        return retString.toString();
    }

    private String getSubCategoriesString(int productCategoryId, Vector<SimpleTreeNode> categories, int loopIndicatorId) throws AdempiereSystemError {
        StringBuilder ret = new StringBuilder();
        for (SimpleTreeNode node : categories) {
            if (node.getParentId() != productCategoryId) continue;
            if (node.getNodeId() == loopIndicatorId) {
                throw new AdempiereSystemError("The product category tree contains a loop on categoryId: " + loopIndicatorId);
            }
            ret.append(this.getSubCategoriesString(node.getNodeId(), categories, loopIndicatorId));
            ret.append(",");
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(ret.toString());
        }
        StringBuilder msgreturn = new StringBuilder(ret).append(productCategoryId);
        return msgreturn.toString();
    }

    private static class SimpleTreeNode {
        private int nodeId;
        private int parentId;

        public SimpleTreeNode(int nodeId, int parentId) {
            this.nodeId = nodeId;
            this.parentId = parentId;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public int getParentId() {
            return this.parentId;
        }
    }
}

