/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MProduct;
import org.compiere.model.MProductBOM;
import org.compiere.model.Query;
import org.compiere.model.X_T_BOM_Indented;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class IndentedBOM
extends SvrProcess {
    private int p_AD_Org_ID = 0;
    private int p_C_AcctSchema_ID = 0;
    private int p_M_Product_ID = 0;
    private int p_M_CostElement_ID = 0;
    private int m_LevelNo = 0;
    private int m_SeqNo = 0;
    private MAcctSchema m_as = null;

    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if (para.getParameter() != null) {
                if (name.equals("C_AcctSchema_ID")) {
                    this.p_C_AcctSchema_ID = para.getParameterAsInt();
                    this.m_as = MAcctSchema.get((Properties)this.getCtx(), (int)this.p_C_AcctSchema_ID);
                } else if (name.equals("M_CostElement_ID")) {
                    this.p_M_CostElement_ID = para.getParameterAsInt();
                } else if (name.equals("M_Product_ID")) {
                    this.p_M_Product_ID = para.getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++n2;
        }
    }

    protected String doIt() throws Exception {
        if (this.p_M_Product_ID == 0) {
            throw new FillMandatoryException(new String[]{"M_Product_ID"});
        }
        this.explodeProduct(this.p_M_Product_ID, Env.ONE, Env.ONE);
        return "";
    }

    private llCost explodeProduct(int M_Product_ID, BigDecimal qty, BigDecimal accumQty) {
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)M_Product_ID);
        X_T_BOM_Indented tboml = new X_T_BOM_Indented(this.getCtx(), 0, this.get_TrxName());
        tboml.setAD_Org_ID(this.p_AD_Org_ID);
        tboml.setC_AcctSchema_ID(this.p_C_AcctSchema_ID);
        tboml.setAD_PInstance_ID(this.getAD_PInstance_ID());
        tboml.setM_CostElement_ID(this.p_M_CostElement_ID);
        tboml.setSel_Product_ID(product.get_ID());
        tboml.setM_Product_ID(this.p_M_Product_ID);
        tboml.setQtyBOM(qty);
        tboml.setQty(accumQty);
        tboml.setSeqNo(this.m_SeqNo);
        tboml.setLevelNo(this.m_LevelNo);
        String pad = "";
        if (this.m_LevelNo > 0) {
            pad = String.format("%1$" + 4 * this.m_LevelNo + "s", "");
        }
        tboml.setLevels(String.valueOf(this.m_LevelNo > 0 ? ":" : "") + pad + " " + product.getValue());
        MCost cost = MCost.get((MProduct)product, (int)0, (MAcctSchema)this.m_as, (int)this.p_AD_Org_ID, (int)this.p_M_CostElement_ID, (String)this.get_TrxName());
        tboml.setCurrentCostPrice(cost.getCurrentCostPrice());
        tboml.setCost(cost.getCurrentCostPrice().multiply(accumQty));
        tboml.setFutureCostPrice(cost.getFutureCostPrice());
        tboml.setCostFuture(cost.getFutureCostPrice().multiply(accumQty));
        ++this.m_SeqNo;
        BigDecimal llCost2 = Env.ZERO;
        BigDecimal llFutureCost = Env.ZERO;
        List<MProductBOM> list = this.getBOMs(product);
        for (MProductBOM bom : list) {
            ++this.m_LevelNo;
            llCost ll = this.explodeProduct(bom.getM_ProductBOM_ID(), bom.getBOMQty(), accumQty.multiply(bom.getBOMQty()));
            llCost2 = llCost2.add(ll.currentCost.multiply(accumQty.multiply(bom.getBOMQty())));
            llFutureCost = llFutureCost.add(ll.futureCost.multiply(accumQty.multiply(bom.getBOMQty())));
            --this.m_LevelNo;
        }
        llCost retVal = new llCost();
        if (list.size() == 0) {
            tboml.setCurrentCostPriceLL(cost.getCurrentCostPrice());
            tboml.setFutureCostPriceLL(cost.getFutureCostPrice());
            retVal.currentCost = cost.getCurrentCostPrice();
            retVal.futureCost = cost.getFutureCostPrice();
        } else {
            tboml.setCurrentCostPriceLL(llCost2);
            tboml.setFutureCostPriceLL(llFutureCost);
            retVal.currentCost = llCost2;
            retVal.futureCost = llFutureCost;
        }
        tboml.saveEx();
        return retVal;
    }

    private List<MProductBOM> getBOMs(MProduct product) {
        ArrayList<Integer> params = new ArrayList<Integer>();
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("M_Product_ID").append("=?");
        params.add(product.get_ID());
        List list = new Query(this.getCtx(), "M_Product_BOM", whereClause.toString(), this.get_TrxName()).setParameters(params).setOnlyActiveRecords(true).setOrderBy("Line").list();
        return list;
    }

    private static class llCost {
        BigDecimal currentCost = Env.ZERO;
        BigDecimal futureCost = Env.ZERO;

        private llCost() {
        }
    }
}

