/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MPayment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class CopyFromBankStmt
extends SvrProcess {
    private int m_C_BankStatement_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_BankStatement_ID")) {
                    this.m_C_BankStatement_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int To_C_BankStatement_ID = this.getRecord_ID();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("From C_BankStatement_ID=" + this.m_C_BankStatement_ID + " to " + To_C_BankStatement_ID);
        }
        if (To_C_BankStatement_ID == 0) {
            throw new IllegalArgumentException("Target C_BankStatement_ID == 0");
        }
        if (this.m_C_BankStatement_ID == 0) {
            throw new IllegalArgumentException("Source C_BankStatement_ID == 0");
        }
        MBankStatement from = new MBankStatement(this.getCtx(), this.m_C_BankStatement_ID, this.get_TrxName());
        MBankStatement to = new MBankStatement(this.getCtx(), To_C_BankStatement_ID, this.get_TrxName());
        int no = 0;
        if (!"CO".equals(from.getDocStatus()) && !"CL".equals(from.getDocStatus())) {
            throw new IllegalArgumentException("Source must be closed or complete");
        }
        MBankStatementLine[] mBankStatementLineArray = from.getLines(false);
        int n = mBankStatementLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MBankStatementLine fromLine = mBankStatementLineArray[n2];
            if (fromLine.getC_Payment_ID() > 0) {
                String sql = "SELECT C_BankStatementLine_ID FROM C_BankStatementLine bsl, C_BankStatement bs WHERE bs.C_BankStatement_ID=bsl.C_BankStatement_ID AND bs.DocStatus IN ('DR', 'CO', 'CL') AND bsl.C_Payment_ID=?";
                if (DB.getSQLValueEx((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{fromLine.getC_Payment_ID()}) < 0) {
                    MBankStatementLine toLine = new MBankStatementLine(to);
                    toLine.setPayment(new MPayment(this.getCtx(), fromLine.getC_Payment_ID(), this.get_TrxName()));
                    toLine.saveEx();
                    ++no;
                } else {
                    this.log.info("C_BankStatementLine not copied - related to a payment already present in a bank statement");
                }
            } else {
                MBankStatementLine toLine = new MBankStatementLine(to);
                toLine.setC_Currency_ID(fromLine.getC_Currency_ID());
                toLine.setC_Charge_ID(fromLine.getC_Charge_ID());
                toLine.setStmtAmt(fromLine.getStmtAmt());
                toLine.setTrxAmt(fromLine.getTrxAmt());
                toLine.setChargeAmt(fromLine.getChargeAmt());
                toLine.setInterestAmt(fromLine.getInterestAmt());
                toLine.saveEx();
                ++no;
            }
            ++n2;
        }
        return "@Copied@=" + no;
    }
}

