/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocation;
import org.compiere.model.MOpportunity;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class ConvertLead
extends SvrProcess {
    private boolean p_createOpportunity = true;
    private BigDecimal p_opportunityAmt = null;
    private int p_AD_User_ID = 0;
    private Timestamp p_expectedCloseDate = null;
    private int p_C_SalesStage_ID = 0;
    private String p_Description = null;
    private int p_C_Currency_ID = 0;
    private int p_SalesRep_ID = 0;

    protected String doIt() throws Exception {
        MLocation address;
        MBPartnerLocation loc;
        MLocation leadAddress;
        if (this.p_AD_User_ID <= 0) {
            throw new FillMandatoryException(new String[]{"AD_User_ID"});
        }
        MUser lead = MUser.get((Properties)this.getCtx(), (int)this.p_AD_User_ID);
        lead.set_TrxName(this.get_TrxName());
        if (!lead.isSalesLead() && lead.getC_BPartner_ID() != 0) {
            throw new AdempiereUserError("Lead already converted");
        }
        MBPartner bp = MBPartner.getTemplate((Properties)this.getCtx(), (int)Env.getAD_Client_ID((Properties)this.getCtx()));
        bp.set_TrxName(this.get_TrxName());
        if (!Util.isEmpty((String)lead.getBPName())) {
            bp.setName(lead.getBPName());
        } else {
            bp.setName(lead.getName());
        }
        bp.saveEx();
        this.addLog(bp.getC_BPartner_ID(), null, null, "@C_BPartner_ID@ @Created@", 291, bp.getC_BPartner_ID());
        lead.setC_BPartner_ID(bp.getC_BPartner_ID());
        if (lead.getC_Location_ID() != 0) {
            leadAddress = (MLocation)lead.getC_Location();
            loc = new MBPartnerLocation(bp);
            address = new MLocation(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)leadAddress, (PO)address);
            address.saveEx();
            loc.setC_Location_ID(address.getC_Location_ID());
            loc.setPhone(lead.getPhone());
            loc.setPhone2(lead.getPhone2());
            loc.setFax(lead.getFax());
            loc.saveEx();
            lead.setC_BPartner_Location_ID(loc.getC_BPartner_Location_ID());
            this.addLog("@C_BPartner_Location_ID@ @Created@");
        }
        if (lead.getBP_Location_ID() != 0) {
            leadAddress = (MLocation)lead.getBP_Location();
            loc = new MBPartnerLocation(bp);
            address = new MLocation(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)leadAddress, (PO)address);
            address.saveEx();
            loc.setC_Location_ID(address.getC_Location_ID());
            loc.saveEx();
            this.addLog("@C_Location_ID@ @Created@");
        }
        if (this.p_createOpportunity) {
            MOpportunity op = new MOpportunity(this.getCtx(), 0, this.get_TrxName());
            op.setAD_User_ID(lead.getAD_User_ID());
            op.setC_BPartner_ID(bp.getC_BPartner_ID());
            op.setExpectedCloseDate(this.p_expectedCloseDate != null ? this.p_expectedCloseDate : new Timestamp(System.currentTimeMillis()));
            op.setOpportunityAmt(this.p_opportunityAmt != null ? this.p_opportunityAmt : Env.ZERO);
            if (this.p_C_SalesStage_ID > 0) {
                op.setC_SalesStage_ID(this.p_C_SalesStage_ID);
            }
            String sql = "SELECT Probability FROM C_SalesStage WHERE C_SalesStage_ID = ?";
            BigDecimal probability = DB.getSQLValueBD((String)this.get_TrxName(), (String)sql, (int)this.p_C_SalesStage_ID);
            op.setProbability(probability != null ? probability : Env.ZERO);
            op.setDescription(this.p_Description);
            if (this.p_C_Currency_ID > 0) {
                op.setC_Currency_ID(this.p_C_Currency_ID);
            } else {
                op.setC_Currency_ID(Env.getContextAsInt((Properties)this.getCtx(), (String)"$C_Currency_ID"));
            }
            if (this.p_SalesRep_ID > 0) {
                op.setSalesRep_ID(this.p_SalesRep_ID);
            } else if (lead.getSalesRep_ID() > 0) {
                op.setSalesRep_ID(lead.getSalesRep_ID());
            } else {
                op.setSalesRep_ID(Env.getContextAsInt((Properties)this.getCtx(), (String)"#SalesRep_ID"));
            }
            op.setC_Campaign_ID(lead.getC_Campaign_ID());
            op.saveEx();
            this.addLog(op.getC_Opportunity_ID(), null, null, "@C_Opportunity_ID@ @Created@", 53337, op.getC_Opportunity_ID());
        }
        lead.setIsSalesLead(false);
        lead.setLeadStatus("C");
        lead.saveEx();
        return "@OK@";
    }

    protected void prepare() {
        ProcessInfoParameter[] paras;
        ProcessInfoParameter[] processInfoParameterArray = paras = this.getParameter();
        int n = paras.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if (!Util.isEmpty((String)name)) {
                if ("AD_User_ID".equals(name)) {
                    this.p_AD_User_ID = para.getParameterAsInt();
                } else if ("CreateOpportunity".equals(name)) {
                    this.p_createOpportunity = para.getParameterAsBoolean();
                } else if ("OpportunityAmt".equals(name)) {
                    this.p_opportunityAmt = para.getParameterAsBigDecimal();
                } else if ("ExpectedCloseDate".equals(name)) {
                    this.p_expectedCloseDate = para.getParameterAsTimestamp();
                } else if ("C_SalesStage_ID".equals(name)) {
                    this.p_C_SalesStage_ID = para.getParameterAsInt();
                } else if ("SalesRep_ID".equals(name)) {
                    this.p_SalesRep_ID = para.getParameterAsInt();
                } else if ("Description".equals(name)) {
                    this.p_Description = para.getParameterAsString();
                } else if ("C_Currency_ID".equals(name)) {
                    this.p_C_Currency_ID = para.getParameterAsInt();
                } else {
                    this.log.log(Level.WARNING, "Unknown parameter: " + name);
                }
            }
            if (114 == this.getTable_ID()) {
                this.p_AD_User_ID = this.getRecord_ID();
            }
            if (this.p_C_SalesStage_ID == 0) {
                String sql = "SELECT MIN(s.C_SalesStage_ID) FROM C_SalesStage s WHERE s.AD_Client_ID = ? AND s.IsActive = 'Y' AND NOT EXISTS (SELECT * FROM C_SalesStage ss WHERE ss.AD_Client_ID=s.AD_Client_ID AND ss.IsActive='Y' AND ss.Value < s.Value)";
                this.p_C_SalesStage_ID = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getAD_Client_ID());
            }
            ++n2;
        }
    }
}

