/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.X_I_BankStatement;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Env;

public class BankStatementPayment
extends SvrProcess {
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int Table_ID = this.getTable_ID();
        int Record_ID = this.getRecord_ID();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Table_ID=" + Table_ID + ", Record_ID=" + Record_ID);
        }
        if (Table_ID == 600) {
            return this.createPayment(new X_I_BankStatement(this.getCtx(), Record_ID, this.get_TrxName()));
        }
        if (Table_ID == 393) {
            return this.createPayment(new MBankStatementLine(this.getCtx(), Record_ID, this.get_TrxName()));
        }
        throw new AdempiereSystemError("??");
    }

    private String createPayment(X_I_BankStatement ibs) throws Exception {
        if (ibs == null || ibs.getC_Payment_ID() != 0) {
            return "--";
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(ibs.toString());
        }
        if (ibs.getC_Invoice_ID() == 0 && ibs.getC_BPartner_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @C_Invoice_ID@ / @C_BPartner_ID@");
        }
        if (ibs.getC_BankAccount_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @C_BankAccount_ID@");
        }
        MPayment payment = this.createPayment(ibs.getC_Invoice_ID(), ibs.getC_BPartner_ID(), ibs.getC_Currency_ID(), ibs.getStmtAmt(), ibs.getTrxAmt(), ibs.getC_BankAccount_ID(), ibs.getStatementLineDate() == null ? ibs.getStatementDate() : ibs.getStatementLineDate(), ibs.getDateAcct(), ibs.getDescription(), ibs.getAD_Org_ID());
        if (payment == null) {
            throw new AdempiereSystemError("Could not create Payment");
        }
        ibs.setC_Payment_ID(payment.getC_Payment_ID());
        ibs.setC_Currency_ID(payment.getC_Currency_ID());
        ibs.setTrxAmt(payment.getPayAmt(true));
        ibs.saveEx();
        StringBuilder retString = new StringBuilder("@C_Payment_ID@ = ").append(payment.getDocumentNo());
        if (payment.getOverUnderAmt().signum() != 0) {
            retString.append(" - @OverUnderAmt@=").append(payment.getOverUnderAmt());
        }
        return retString.toString();
    }

    private String createPayment(MBankStatementLine bsl) throws Exception {
        if (bsl == null || bsl.getC_Payment_ID() != 0) {
            return "--";
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(bsl.toString());
        }
        if (bsl.getC_Invoice_ID() == 0 && bsl.getC_BPartner_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @C_Invoice_ID@ / @C_BPartner_ID@");
        }
        MBankStatement bs = new MBankStatement(this.getCtx(), bsl.getC_BankStatement_ID(), this.get_TrxName());
        MPayment payment = this.createPayment(bsl.getC_Invoice_ID(), bsl.getC_BPartner_ID(), bsl.getC_Currency_ID(), bsl.getStmtAmt(), bsl.getTrxAmt(), bs.getC_BankAccount_ID(), bsl.getStatementLineDate(), bsl.getDateAcct(), bsl.getDescription(), bsl.getAD_Org_ID());
        if (payment == null) {
            throw new AdempiereSystemError("Could not create Payment");
        }
        bsl.setPayment(payment);
        bsl.saveEx();
        StringBuilder retString = new StringBuilder("@C_Payment_ID@ = ").append(payment.getDocumentNo());
        if (payment.getOverUnderAmt().signum() != 0) {
            retString.append(" - @OverUnderAmt@=").append(payment.getOverUnderAmt());
        }
        return retString.toString();
    }

    private MPayment createPayment(int C_Invoice_ID, int C_BPartner_ID, int C_Currency_ID, BigDecimal StmtAmt, BigDecimal TrxAmt, int C_BankAccount_ID, Timestamp DateTrx, Timestamp DateAcct, String Description, int AD_Org_ID) {
        BigDecimal PayAmt = TrxAmt;
        if (PayAmt == null || Env.ZERO.compareTo(PayAmt) == 0) {
            PayAmt = StmtAmt;
        }
        if (C_Invoice_ID == 0 && (PayAmt == null || Env.ZERO.compareTo(PayAmt) == 0)) {
            throw new IllegalStateException("@PayAmt@ = 0");
        }
        if (PayAmt == null) {
            PayAmt = Env.ZERO;
        }
        MPayment payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
        payment.setAD_Org_ID(AD_Org_ID);
        payment.setC_BankAccount_ID(C_BankAccount_ID);
        payment.setTenderType("K");
        if (DateTrx != null) {
            payment.setDateTrx(DateTrx);
        } else if (DateAcct != null) {
            payment.setDateTrx(DateAcct);
        }
        if (DateAcct != null) {
            payment.setDateAcct(DateAcct);
        } else {
            payment.setDateAcct(payment.getDateTrx());
        }
        payment.setDescription(Description);
        if (C_Invoice_ID != 0) {
            MInvoice invoice = new MInvoice(this.getCtx(), C_Invoice_ID, null);
            payment.setC_DocType_ID(invoice.isSOTrx());
            payment.setC_Invoice_ID(invoice.getC_Invoice_ID());
            payment.setC_BPartner_ID(invoice.getC_BPartner_ID());
            if (PayAmt.signum() != 0) {
                payment.setC_Currency_ID(C_Currency_ID);
                if (invoice.isSOTrx()) {
                    payment.setPayAmt(PayAmt);
                } else {
                    payment.setPayAmt(PayAmt.negate());
                }
                payment.setOverUnderAmt(invoice.getGrandTotal(true).subtract(payment.getPayAmt()));
            } else {
                payment.setC_Currency_ID(invoice.getC_Currency_ID());
                payment.setPayAmt(invoice.getGrandTotal(true));
            }
        } else if (C_BPartner_ID != 0) {
            payment.setC_BPartner_ID(C_BPartner_ID);
            payment.setC_Currency_ID(C_Currency_ID);
            if (PayAmt.signum() < 0) {
                payment.setPayAmt(PayAmt.abs());
                payment.setC_DocType_ID(false);
            } else {
                payment.setPayAmt(PayAmt);
                payment.setC_DocType_ID(true);
            }
        } else {
            return null;
        }
        payment.saveEx();
        if (!payment.processIt("CO")) {
            this.log.warning("Payment Process Failed: " + payment.getDocumentNo() + " " + payment.getProcessMsg());
            throw new IllegalStateException("Payment Process Failed: " + payment.getDocumentNo() + " " + payment.getProcessMsg());
        }
        payment.saveEx();
        return payment;
    }
}

