/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.components.map.ItemData;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.components.map.MarkerDataset;
import net.sf.jasperreports.components.map.StandardItemData;
import net.sf.jasperreports.components.map.StandardMarkerDataset;
import net.sf.jasperreports.components.map.type.MapImageTypeEnum;
import net.sf.jasperreports.components.map.type.MapScaleEnum;
import net.sf.jasperreports.components.map.type.MapTypeEnum;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class StandardMapComponent
implements MapComponent,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LATITUDE_EXPRESSION = "latitudeExpression";
    public static final String PROPERTY_LONGITUDE_EXPRESSION = "longitudeExpression";
    public static final String PROPERTY_ZOOM_EXPRESSION = "zoomExpression";
    public static final String PROPERTY_LANGUAGE_EXPRESSION = "languageExpression";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    public static final String PROPERTY_MAP_TYPE = "mapType";
    public static final String PROPERTY_MAP_SCALE = "mapScale";
    public static final String PROPERTY_IMAGE_TYPE = "imageType";
    public static final String PROPERTY_MARKER_DATA = "markerData";
    public static final String PROPERTY_MARKER_DATASET = "markerDataset";
    private JRExpression latitudeExpression;
    private JRExpression longitudeExpression;
    private JRExpression zoomExpression;
    private JRExpression languageExpression;
    private EvaluationTimeEnum evaluationTime = EvaluationTimeEnum.NOW;
    private String evaluationGroup;
    private MapTypeEnum mapType;
    private MapScaleEnum mapScale;
    private MapImageTypeEnum imageType;
    private ItemData markerData;
    private transient JRPropertyChangeSupport eventSupport;
    private int PSEUDO_SERIAL_VERSION_UID = 50004;
    private MarkerDataset markerDataset;

    public StandardMapComponent() {
    }

    public StandardMapComponent(MapComponent map, JRBaseObjectFactory objectFactory) {
        this.latitudeExpression = objectFactory.getExpression(map.getLatitudeExpression());
        this.longitudeExpression = objectFactory.getExpression(map.getLongitudeExpression());
        this.zoomExpression = objectFactory.getExpression(map.getZoomExpression());
        this.languageExpression = objectFactory.getExpression(map.getLanguageExpression());
        this.evaluationTime = map.getEvaluationTime();
        this.evaluationGroup = map.getEvaluationGroup();
        this.mapType = map.getMapType();
        this.mapScale = map.getMapScale();
        this.imageType = map.getImageType();
        if (map.getMarkerData() != null) {
            this.markerData = new StandardItemData(map.getMarkerData(), objectFactory);
        }
    }

    @Override
    public JRExpression getLatitudeExpression() {
        return this.latitudeExpression;
    }

    public void setLatitudeExpression(JRExpression latitudeExpression) {
        JRExpression old = this.latitudeExpression;
        this.latitudeExpression = latitudeExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_LATITUDE_EXPRESSION, old, this.latitudeExpression);
    }

    @Override
    public JRExpression getLongitudeExpression() {
        return this.longitudeExpression;
    }

    public void setLongitudeExpression(JRExpression longitudeExpression) {
        JRExpression old = this.longitudeExpression;
        this.longitudeExpression = longitudeExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_LONGITUDE_EXPRESSION, old, this.longitudeExpression);
    }

    @Override
    public JRExpression getZoomExpression() {
        return this.zoomExpression;
    }

    public void setZoomExpression(JRExpression zoomExpression) {
        JRExpression old = this.zoomExpression;
        this.zoomExpression = zoomExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_ZOOM_EXPRESSION, old, this.zoomExpression);
    }

    @Override
    public JRExpression getLanguageExpression() {
        return this.languageExpression;
    }

    public void setLanguageExpression(JRExpression languageExpression) {
        JRExpression old = this.languageExpression;
        this.languageExpression = languageExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_LANGUAGE_EXPRESSION, old, this.languageExpression);
    }

    @Override
    public EvaluationTimeEnum getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(EvaluationTimeEnum evaluationTimeValue) {
        EvaluationTimeEnum old = this.evaluationTime;
        this.evaluationTime = evaluationTimeValue;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, old, this.evaluationTime);
    }

    @Override
    public String getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public void setEvaluationGroup(String evaluationGroup) {
        String old = this.evaluationGroup;
        this.evaluationGroup = evaluationGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, old, this.evaluationGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        StandardMapComponent standardMapComponent = this;
        synchronized (standardMapComponent) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    @Override
    public Object clone() {
        StandardMapComponent clone = null;
        try {
            clone = (StandardMapComponent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.latitudeExpression = JRCloneUtils.nullSafeClone(this.latitudeExpression);
        clone.longitudeExpression = JRCloneUtils.nullSafeClone(this.longitudeExpression);
        clone.zoomExpression = JRCloneUtils.nullSafeClone(this.zoomExpression);
        clone.languageExpression = JRCloneUtils.nullSafeClone(this.languageExpression);
        clone.markerData = JRCloneUtils.nullSafeClone(this.markerData);
        clone.eventSupport = null;
        return clone;
    }

    @Override
    public MapTypeEnum getMapType() {
        return this.mapType;
    }

    public void setMapType(MapTypeEnum mapType) {
        MapTypeEnum old = this.mapType;
        this.mapType = mapType;
        this.getEventSupport().firePropertyChange(PROPERTY_MAP_TYPE, old, this.mapType);
    }

    @Override
    public MapScaleEnum getMapScale() {
        return this.mapScale;
    }

    public void setMapScale(MapScaleEnum mapScale) {
        MapScaleEnum old = this.mapScale;
        this.mapScale = mapScale;
        this.getEventSupport().firePropertyChange(PROPERTY_MAP_SCALE, old, this.mapScale);
    }

    @Override
    public MapImageTypeEnum getImageType() {
        return this.imageType;
    }

    public void setImageType(MapImageTypeEnum imageType) {
        MapImageTypeEnum old = this.imageType;
        this.imageType = imageType;
        this.getEventSupport().firePropertyChange(PROPERTY_IMAGE_TYPE, old, this.imageType);
    }

    @Override
    public MarkerDataset getMarkerDataset() {
        return this.markerDataset;
    }

    public void setMarkerDataset(MarkerDataset markerDataset) {
        this.setMarkerData(StandardMarkerDataset.getItemData(markerDataset));
    }

    @Override
    public ItemData getMarkerData() {
        return this.markerData;
    }

    public void setMarkerData(ItemData markerData) {
        ItemData old = this.markerData;
        this.markerData = markerData;
        this.getEventSupport().firePropertyChange(PROPERTY_MARKER_DATA, old, this.markerData);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30101) {
            if (this.markerDataset != null) {
                this.markerData = StandardMarkerDataset.getItemData(this.markerDataset);
            }
            this.markerDataset = null;
        }
    }
}

