/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.misc;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.felix.webconsole.internal.misc.ThreadComparator;
import org.apache.felix.webconsole.internal.misc.ThreadGroupComparator;

public class ThreadDumper {
    private final Method getStackTrace;
    private final Method getId;
    static /* synthetic */ Class class$java$lang$Thread;

    public ThreadDumper() {
        Method _getStackTrace = null;
        Method _getId = null;
        Class<?>[] nullArgs = null;
        try {
            _getStackTrace = (class$java$lang$Thread == null ? (class$java$lang$Thread = ThreadDumper.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getStackTrace", nullArgs);
            _getId = (class$java$lang$Thread == null ? (class$java$lang$Thread = ThreadDumper.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getId", nullArgs);
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.getStackTrace = _getStackTrace;
        this.getId = _getId;
    }

    public final void printThreads(PrintWriter pw, boolean withStackTrace) {
        ThreadGroup rootGroup = ThreadDumper.getRootThreadGroup();
        int numGroups = rootGroup.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[2 * numGroups];
        numGroups = rootGroup.enumerate(groups);
        Arrays.sort(groups, ThreadGroupComparator.getInstance());
        this.printSummary(pw, rootGroup, groups);
        this.printThreadGroup(pw, rootGroup, withStackTrace);
        for (int i = 0; i < numGroups; ++i) {
            this.printThreadGroup(pw, groups[i], withStackTrace);
        }
        pw.println();
    }

    public final void printThread(PrintWriter pw, Thread thread, boolean withStackTrace) {
        if (thread != null) {
            pw.print("  Thread ");
            pw.print(this.getId(thread));
            pw.print('/');
            pw.print(thread.getName());
            pw.print(" [");
            pw.print("priority=");
            pw.print(thread.getPriority());
            pw.print(", alive=");
            pw.print(thread.isAlive());
            pw.print(", daemon=");
            pw.print(thread.isDaemon());
            pw.print(", interrupted=");
            pw.print(thread.isInterrupted());
            pw.print(", loader=");
            pw.print(thread.getContextClassLoader());
            pw.println(']');
            if (withStackTrace) {
                this.printClassLoader(pw, thread.getContextClassLoader());
                this.printStackTrace(pw, this.getStackTrace(thread));
                pw.println();
            }
        }
    }

    private final void printThreadGroup(PrintWriter pw, ThreadGroup group, boolean withStackTrace) {
        if (group != null) {
            pw.print("ThreadGroup ");
            pw.print(group.getName());
            pw.print(" [");
            pw.print("maxprio=");
            pw.print(group.getMaxPriority());
            pw.print(", parent=");
            if (group.getParent() != null) {
                pw.print(group.getParent().getName());
            } else {
                pw.print('-');
            }
            pw.print(", isDaemon=");
            pw.print(group.isDaemon());
            pw.print(", isDestroyed=");
            pw.print(group.isDestroyed());
            pw.println(']');
            int numThreads = group.activeCount();
            Thread[] threads = new Thread[numThreads * 2];
            group.enumerate(threads, false);
            Arrays.sort(threads, ThreadComparator.getInstance());
            for (int i = 0; i < threads.length; ++i) {
                this.printThread(pw, threads[i], withStackTrace);
            }
            pw.println();
        }
    }

    private final void printClassLoader(PrintWriter pw, ClassLoader classLoader) {
        if (classLoader != null) {
            URLClassLoader loader;
            URL[] urls;
            pw.print("    ClassLoader=");
            pw.println(classLoader);
            pw.print("      Parent=");
            pw.println(classLoader.getParent());
            if (classLoader instanceof URLClassLoader && (urls = (loader = (URLClassLoader)classLoader).getURLs()) != null && urls.length > 0) {
                for (int i = 0; i < urls.length; ++i) {
                    pw.print("      ");
                    pw.print(i);
                    pw.print(" - ");
                    pw.println(urls[i]);
                }
            }
        }
    }

    private final void printStackTrace(PrintWriter pw, Object stackTrace) {
        pw.println("    Stacktrace");
        if (stackTrace == null || Array.getLength(stackTrace) == 0) {
            pw.println("      -");
        } else {
            int len = Array.getLength(stackTrace);
            for (int i = 0; i < len; ++i) {
                Object stackTraceElement = Array.get(stackTrace, i);
                pw.print("      ");
                pw.println(stackTraceElement);
            }
        }
    }

    private final void printSummary(PrintWriter pw, ThreadGroup rootGroup, ThreadGroup[] groups) {
        int alive = 0;
        int daemon = 0;
        int interrupted = 0;
        int threadCount = 0;
        int threadGroupCount = 0;
        int threadGroupDestroyed = 0;
        ArrayList<ThreadGroup> list = new ArrayList<ThreadGroup>(groups.length + 1);
        list.add(rootGroup);
        list.addAll(Arrays.asList(groups));
        for (int j = 0; j < list.size(); ++j) {
            ThreadGroup group = (ThreadGroup)list.get(j);
            if (null == group) continue;
            ++threadGroupCount;
            if (group.isDestroyed()) {
                ++threadGroupDestroyed;
            }
            Thread[] threads = new Thread[group.activeCount()];
            group.enumerate(threads);
            int size = threads.length;
            for (int i = 0; i < size; ++i) {
                Thread thread = threads[i];
                if (null == thread) continue;
                if (thread.isAlive()) {
                    ++alive;
                }
                if (thread.isDaemon()) {
                    ++daemon;
                }
                if (thread.isInterrupted()) {
                    ++interrupted;
                }
                ++threadCount;
            }
        }
        pw.print("Status: ");
        pw.print(threadCount);
        pw.print(" threads (");
        pw.print(alive);
        pw.print(" alive/");
        pw.print(daemon);
        pw.print(" daemon/");
        pw.print(interrupted);
        pw.print(" interrupted) in ");
        pw.print(threadGroupCount);
        pw.print(" groups (");
        pw.print(threadGroupDestroyed);
        pw.print(" destroyed).");
        pw.println();
        pw.println();
    }

    private final String getId(Thread thread) {
        String ret = "";
        if (null != this.getId) {
            try {
                ret = "#" + this.getId.invoke((Object)thread, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ret;
    }

    private final Object getStackTrace(Thread thread) {
        Object ret = null;
        if (null != this.getStackTrace) {
            try {
                ret = this.getStackTrace.invoke((Object)thread, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ret;
    }

    private static final ThreadGroup getRootThreadGroup() {
        ThreadGroup rootGroup = Thread.currentThread().getThreadGroup();
        while (rootGroup.getParent() != null) {
            rootGroup = rootGroup.getParent();
        }
        return rootGroup;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

