/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.ValueNamePair;

public class PaySelect {
    private static final long serialVersionUID = 2872767371244295934L;
    public int m_WindowNo = 0;
    public DecimalFormat m_format = DisplayType.getNumberFormat((int)12);
    private BigDecimal m_bankBalance = Env.ZERO;
    private String m_sql;
    public int m_noSelected = 0;
    private int m_AD_Client_ID = 0;
    public boolean m_isLocked = false;
    public MPaySelection m_ps = null;
    public static CLogger log = CLogger.getCLogger(PaySelect.class);
    public Trx trx = null;

    public ArrayList<BankInfo> getBankAccountData() {
        ArrayList<BankInfo> data;
        block6: {
            data = new ArrayList<BankInfo>();
            this.m_AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
            String sql = MRole.getDefault().addAccessSQL("SELECT ba.C_BankAccount_ID,b.Name || ' ' || ba.AccountNo AS Name,ba.C_Currency_ID, c.ISO_Code,ba.CurrentBalance FROM C_Bank b, C_BankAccount ba, C_Currency c WHERE b.C_Bank_ID=ba.C_Bank_ID AND ba.C_Currency_ID=c.C_Currency_ID AND ba.IsActive='Y'  AND EXISTS (SELECT * FROM C_BankAccountDoc d WHERE d.C_BankAccount_ID=ba.C_BankAccount_ID AND d.IsActive='Y' ) ORDER BY 2", "b", true, true);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        boolean transfers = false;
                        BankInfo bi = new BankInfo(rs.getInt(1), rs.getInt(3), rs.getString(2), rs.getString(4), rs.getBigDecimal(5), transfers);
                        data.add(bi);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    public ArrayList<KeyNamePair> getBPartnerData() {
        ArrayList<KeyNamePair> data;
        block6: {
            data = new ArrayList<KeyNamePair>();
            KeyNamePair pp = new KeyNamePair(0, "");
            data.add(pp);
            String sql = String.valueOf(MRole.getDefault().addAccessSQL("SELECT bp.C_BPartner_ID, bp.Name FROM C_BPartner bp", "bp", true, false)) + " AND EXISTS (SELECT * FROM C_Invoice i WHERE bp.C_BPartner_ID=i.C_BPartner_ID" + " AND (i.IsSOTrx='N' OR (i.IsSOTrx='Y' AND i.PaymentRule='D'))" + " AND i.IsPaid<>'Y') " + "ORDER BY 2";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        data.add(pp);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    public ArrayList<KeyNamePair> getDocTypeData() {
        ArrayList<KeyNamePair> data;
        block6: {
            data = new ArrayList<KeyNamePair>();
            String sql = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    sql = MRole.getDefault().addAccessSQL("SELECT doc.c_doctype_id,doc.name FROM c_doctype doc WHERE doc.ad_client_id = ? AND doc.docbasetype in ('API','APC') ORDER BY 2", "doc", true, false);
                    KeyNamePair dt = new KeyNamePair(0, "");
                    data.add(dt);
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_AD_Client_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        dt = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        data.add(dt);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    public void prepareTable(IMiniTable miniTable) {
        Properties ctx = Env.getCtx();
        this.m_sql = miniTable.prepareTable(new ColumnInfo[]{new ColumnInfo(" ", "i.C_Invoice_ID", IDColumn.class, false, false, null), new ColumnInfo(Msg.translate((Properties)ctx, (String)"DueDate"), "paymentTermDueDate(i.C_PaymentTerm_ID, i.DateInvoiced) AS DateDue", Timestamp.class, true, true, null), new ColumnInfo(Msg.translate((Properties)ctx, (String)"C_BPartner_ID"), "bp.Name", KeyNamePair.class, true, false, "i.C_BPartner_ID"), new ColumnInfo(Msg.translate((Properties)ctx, (String)"DocumentNo"), "i.DocumentNo", String.class), new ColumnInfo(Msg.translate((Properties)ctx, (String)"C_Currency_ID"), "c.ISO_Code", KeyNamePair.class, true, false, "i.C_Currency_ID"), new ColumnInfo(Msg.translate((Properties)ctx, (String)"GrandTotal"), "i.GrandTotal", BigDecimal.class), new ColumnInfo(Msg.translate((Properties)ctx, (String)"DiscountAmt"), "paymentTermDiscount(i.GrandTotal,i.C_Currency_ID,i.C_PaymentTerm_ID,i.DateInvoiced, ?)", BigDecimal.class), new ColumnInfo(Msg.getMsg((Properties)ctx, (String)"DiscountDate"), "SysDate-paymentTermDueDays(i.C_PaymentTerm_ID,i.DateInvoiced,SysDate)", Timestamp.class), new ColumnInfo(Msg.getMsg((Properties)ctx, (String)"AmountDue"), "currencyConvert(invoiceOpen(i.C_Invoice_ID,i.C_InvoicePaySchedule_ID),i.C_Currency_ID, ?,?,i.C_ConversionType_ID, i.AD_Client_ID,i.AD_Org_ID)", BigDecimal.class), new ColumnInfo(Msg.getMsg((Properties)ctx, (String)"AmountPay"), "currencyConvert(invoiceOpen(i.C_Invoice_ID,i.C_InvoicePaySchedule_ID)-paymentTermDiscount(i.GrandTotal,i.C_Currency_ID,i.C_PaymentTerm_ID,i.DateInvoiced, ?),i.C_Currency_ID, ?,?,i.C_ConversionType_ID, i.AD_Client_ID,i.AD_Org_ID)", BigDecimal.class)}, "C_Invoice_v i INNER JOIN C_BPartner bp ON (i.C_BPartner_ID=bp.C_BPartner_ID) INNER JOIN C_Currency c ON (i.C_Currency_ID=c.C_Currency_ID) INNER JOIN C_PaymentTerm p ON (i.C_PaymentTerm_ID=p.C_PaymentTerm_ID)", "i.IsSOTrx=? AND IsPaid='N' AND NOT EXISTS (SELECT * FROM C_PaySelectionLine psl INNER JOIN C_PaySelectionCheck psc ON (psl.C_PaySelectionCheck_ID=psc.C_PaySelectionCheck_ID) LEFT OUTER JOIN C_Payment pmt ON (pmt.C_Payment_ID=psc.C_Payment_ID) WHERE i.C_Invoice_ID=psl.C_Invoice_ID AND psl.IsActive='Y' AND (pmt.DocStatus IS NULL OR pmt.DocStatus NOT IN ('VO','RE')) ) AND i.DocStatus IN ('CO','CL') AND i.AD_Client_ID=?", true, "i");
    }

    public ArrayList<ValueNamePair> getPaymentRuleData(BankInfo bi) {
        ArrayList<ValueNamePair> data;
        block7: {
            if (bi == null) {
                return null;
            }
            this.m_bankBalance = bi.Balance;
            data = new ArrayList<ValueNamePair>();
            int AD_Reference_ID = 195;
            Language language = Env.getLanguage((Properties)Env.getCtx());
            MLookupInfo info = MLookupFactory.getLookup_List((Language)language, (int)AD_Reference_ID);
            String sql = String.valueOf(info.Query.substring(0, info.Query.indexOf(" ORDER BY"))) + " AND " + info.KeyColumn + " IN (SELECT PaymentRule FROM C_BankAccountDoc WHERE C_BankAccount_ID=?) " + info.Query.substring(info.Query.indexOf(" ORDER BY"));
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, bi.C_BankAccount_ID);
                    rs = pstmt.executeQuery();
                    ValueNamePair vp = null;
                    while (rs.next()) {
                        vp = new ValueNamePair(rs.getString(2), rs.getString(3));
                        data.add(vp);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    public void loadTableInfo(BankInfo bi, Timestamp payDate, ValueNamePair paymentRule, boolean onlyDue, KeyNamePair bpartner, KeyNamePair docType, IMiniTable miniTable) {
        block14: {
            KeyNamePair dt;
            int c_doctype_id;
            KeyNamePair pp;
            int C_BPartner_ID;
            log.config("");
            if (this.m_sql == null) {
                return;
            }
            String sql = this.m_sql;
            String isSOTrx = "N";
            if (paymentRule != null && "D".equals(paymentRule.getValue())) {
                isSOTrx = "Y";
                sql = String.valueOf(sql) + " AND i.PaymentRule='D'";
            }
            if (onlyDue) {
                sql = String.valueOf(sql) + " AND paymentTermDueDate(i.C_PaymentTerm_ID, i.DateInvoiced) <= ?";
            }
            if ((C_BPartner_ID = (pp = bpartner).getKey()) != 0) {
                sql = String.valueOf(sql) + " AND i.C_BPartner_ID=?";
            }
            if ((c_doctype_id = (dt = docType).getKey()) != 0) {
                sql = String.valueOf(sql) + " AND i.c_doctype_id =?";
            }
            sql = String.valueOf(sql) + " ORDER BY 2,3";
            if (log.isLoggable(Level.FINEST)) {
                log.finest(String.valueOf(sql) + " - C_Currency_ID=" + bi.C_Currency_ID + ", C_BPartner_ID=" + C_BPartner_ID + ", C_doctype_id=" + c_doctype_id);
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    int index = 1;
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setTimestamp(index++, payDate);
                    pstmt.setInt(index++, bi.C_Currency_ID);
                    pstmt.setTimestamp(index++, payDate);
                    pstmt.setTimestamp(index++, payDate);
                    pstmt.setInt(index++, bi.C_Currency_ID);
                    pstmt.setTimestamp(index++, payDate);
                    pstmt.setString(index++, isSOTrx);
                    pstmt.setInt(index++, this.m_AD_Client_ID);
                    if (onlyDue) {
                        pstmt.setTimestamp(index++, payDate);
                    }
                    if (C_BPartner_ID != 0) {
                        pstmt.setInt(index++, C_BPartner_ID);
                    }
                    if (c_doctype_id != 0) {
                        pstmt.setInt(index++, c_doctype_id);
                    }
                    rs = pstmt.executeQuery();
                    miniTable.loadTable(rs);
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block14;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public String calculateSelection(IMiniTable miniTable) {
        this.m_noSelected = 0;
        BigDecimal invoiceAmt = Env.ZERO;
        int rows = miniTable.getRowCount();
        int i = 0;
        while (i < rows) {
            IDColumn id = (IDColumn)miniTable.getValueAt(i, 0);
            if (id.isSelected()) {
                BigDecimal amt = (BigDecimal)miniTable.getValueAt(i, 9);
                if (amt != null) {
                    invoiceAmt = invoiceAmt.add(amt);
                }
                ++this.m_noSelected;
            }
            ++i;
        }
        BigDecimal remaining = this.m_bankBalance.subtract(invoiceAmt);
        StringBuilder info = new StringBuilder();
        info.append(this.m_noSelected).append(" ").append(Msg.getMsg((Properties)Env.getCtx(), (String)"Selected")).append(" - ");
        info.append(this.m_format.format(invoiceAmt)).append(", ");
        info.append(Msg.getMsg((Properties)Env.getCtx(), (String)"Remaining")).append(" ").append(this.m_format.format(remaining));
        return info.toString();
    }

    public String generatePaySelect(IMiniTable miniTable, ValueNamePair paymentRule, Timestamp payDate, BankInfo bi) {
        log.info("");
        String trxName = null;
        this.trx = null;
        String PaymentRule = paymentRule.getValue();
        this.m_ps = new MPaySelection(Env.getCtx(), 0, trxName);
        this.m_ps.setName(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"VPaySelect")) + " - " + paymentRule.getName() + " - " + payDate);
        this.m_ps.setPayDate(payDate);
        this.m_ps.setC_BankAccount_ID(bi.C_BankAccount_ID);
        this.m_ps.setIsApproved(true);
        if (!this.m_ps.save()) {
            this.m_ps = null;
            return Msg.translate((Properties)Env.getCtx(), (String)"C_PaySelection_ID");
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(this.m_ps.toString());
        }
        int rows = miniTable.getRowCount();
        int line = 0;
        int i = 0;
        while (i < rows) {
            IDColumn id = (IDColumn)miniTable.getValueAt(i, 0);
            if (id.isSelected()) {
                MPaySelectionLine psl = new MPaySelectionLine(this.m_ps, line += 10, PaymentRule);
                int C_Invoice_ID = id.getRecord_ID();
                BigDecimal OpenAmt = (BigDecimal)miniTable.getValueAt(i, 8);
                BigDecimal PayAmt = (BigDecimal)miniTable.getValueAt(i, 9);
                boolean isSOTrx = false;
                psl.setInvoice(C_Invoice_ID, isSOTrx, OpenAmt, PayAmt, OpenAmt.subtract(PayAmt));
                if (!psl.save(trxName)) {
                    return Msg.translate((Properties)Env.getCtx(), (String)"C_PaySelectionLine_ID");
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("C_Invoice_ID=" + C_Invoice_ID + ", PayAmt=" + PayAmt);
                }
            }
            ++i;
        }
        return null;
    }

    public static class BankInfo {
        int C_BankAccount_ID;
        int C_Currency_ID;
        String Name;
        public String Currency;
        public BigDecimal Balance;
        boolean Transfers;

        public BankInfo(int newC_BankAccount_ID, int newC_Currency_ID, String newName, String newCurrency, BigDecimal newBalance, boolean newTransfers) {
            this.C_BankAccount_ID = newC_BankAccount_ID;
            this.C_Currency_ID = newC_Currency_ID;
            this.Name = newName;
            this.Currency = newCurrency;
            this.Balance = newBalance;
        }

        public String toString() {
            return this.Name;
        }
    }
}

