/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MFactReconciliation;
import org.compiere.model.MRole;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class FactReconcile {
    public static CLogger log = CLogger.getCLogger(FactReconcile.class);
    public int m_AD_Client_ID = 0;
    public int m_AD_Org_ID = 0;
    public int m_Account_ID = 0;
    public int m_C_AcctSchema_ID = 0;
    public boolean m_isReconciled = false;
    public int m_C_BPartner_ID = 0;
    public int m_M_Product_ID = 0;
    public Timestamp m_DateAcct = null;
    public Timestamp m_DateAcct2 = null;
    public int selectedColIndex = 2;
    public int idColIndex = 8;
    public int amtColIndex = 0;
    protected static int col_C_AcctSchema_ID = 2513;
    protected static int col_AD_Org_ID = 839;
    protected static int col_C_BPartner_ID = 3499;
    protected static int col_M_Product_ID = 2527;

    public void dynInit() throws Exception {
        this.m_AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public Vector<String> getColumnNames() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Amt"));
        columnNames.add("DR/CR");
        columnNames.add("Fact Acct");
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"DateAcct"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"GL_Category_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Product_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Qty"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"MatchCode"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"DateTrx"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        return columnNames;
    }

    public Vector<Vector<Object>> getData() {
        Vector<Vector<Object>> data;
        block23: {
            data = new Vector<Vector<Object>>();
            StringBuilder sql = new StringBuilder("SELECT abs(fa.amtacctdr-fa.amtacctcr), (fa.amtacctdr-fa.amtacctcr), (CASE WHEN (fa.amtacctdr-fa.amtacctcr) < 0 THEN 'CR' ELSE 'DR' END), fa.Fact_Acct_ID, bp.name, DateAcct, glc.name, p.name, Qty, fa.Description, r.MatchCode, fa.DateTrx, o.value FROM Fact_Acct fa LEFT OUTER JOIN Fact_Reconciliation r ON (fa.Fact_Acct_ID=r.Fact_Acct_ID) LEFT OUTER JOIN C_BPartner bp ON (fa.C_BPartner_ID=bp.C_BPartner_ID) LEFT OUTER JOIN AD_Org o ON (o.AD_Org_ID=fa.AD_Org_ID) LEFT OUTER JOIN M_Product p ON (p.M_Product_ID=fa.M_Product_ID) LEFT OUTER JOIN GL_Category glc ON (fa.GL_Category_ID=glc.GL_Category_ID) WHERE fa.AD_Client_ID=?");
            sql = new StringBuilder(MRole.getDefault((Properties)Env.getCtx(), (boolean)false).addAccessSQL(sql.toString(), "fa", true, false));
            if (this.m_AD_Org_ID > 0) {
                sql.append(" AND fa.AD_Org_ID=?");
            }
            if (this.m_Account_ID > 0) {
                sql.append(" AND fa.Account_ID=?");
            }
            if (this.m_C_AcctSchema_ID > 0) {
                sql.append(" AND fa.C_AcctSchema_ID=?");
            }
            sql.append(" AND ((SELECT SUM(f.amtacctdr-f.amtacctcr) FROM Fact_Reconciliation rec  INNER JOIN Fact_Acct f ON (f.Fact_Acct_ID = rec.Fact_Acct_ID)  WHERE r.MatchCode=rec.MatchCode) ");
            if (this.m_isReconciled) {
                sql.append(" =0)");
            } else {
                sql.append(" <> 0 OR r.MatchCode IS NULL)");
            }
            if (this.m_C_BPartner_ID > 0) {
                sql.append(" AND fa.C_BPartner_ID=?");
            }
            if (this.m_M_Product_ID > 0) {
                sql.append(" AND fa.M_Product_ID=?");
            }
            if (this.m_DateAcct != null) {
                sql.append(" AND fa.DateAcct>=?");
            }
            if (this.m_DateAcct2 != null) {
                sql.append(" AND fa.DateAcct<=?");
            }
            sql.append(" ORDER BY 1,5,3,6");
            if (log.isLoggable(Level.FINE)) {
                log.fine("SQL=" + sql.toString());
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    int i = 1;
                    pstmt.setInt(i++, this.m_AD_Client_ID);
                    if (this.m_AD_Org_ID > 0) {
                        pstmt.setInt(i++, this.m_AD_Org_ID);
                    }
                    if (this.m_Account_ID > 0) {
                        pstmt.setInt(i++, this.m_Account_ID);
                    }
                    if (this.m_C_AcctSchema_ID > 0) {
                        pstmt.setInt(i++, this.m_C_AcctSchema_ID);
                    }
                    if (this.m_C_BPartner_ID > 0) {
                        pstmt.setInt(i++, this.m_C_BPartner_ID);
                    }
                    if (this.m_M_Product_ID > 0) {
                        pstmt.setInt(i++, this.m_M_Product_ID);
                    }
                    if (this.m_DateAcct != null) {
                        pstmt.setTimestamp(i++, this.m_DateAcct);
                    }
                    if (this.m_DateAcct2 != null) {
                        pstmt.setTimestamp(i++, this.m_DateAcct2);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>();
                        line.add(rs.getBigDecimal(2));
                        line.add(rs.getString(3));
                        line.add(new Boolean(false));
                        line.add(rs.getString(5));
                        line.add(rs.getTimestamp(6));
                        line.add(rs.getString(7));
                        line.add(rs.getString(8));
                        line.add(rs.getBigDecimal(9));
                        KeyNamePair pp = new KeyNamePair(rs.getInt(4), rs.getString(10));
                        line.add(pp);
                        line.add(rs.getString(11));
                        line.add(rs.getTimestamp(12));
                        line.add(rs.getString(13));
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block23;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    public void setColumnClass(IMiniTable miniTable) {
        int i = 0;
        miniTable.setColumnClass(i++, BigDecimal.class, true);
        miniTable.setColumnClass(i++, String.class, true);
        miniTable.setColumnClass(i++, Boolean.class, false);
        miniTable.setColumnClass(i++, String.class, true);
        miniTable.setColumnClass(i++, Timestamp.class, true);
        miniTable.setColumnClass(i++, String.class, true);
        miniTable.setColumnClass(i++, String.class, true);
        miniTable.setColumnClass(i++, BigDecimal.class, true);
        miniTable.setColumnClass(i++, String.class, true);
        miniTable.setColumnClass(i++, String.class, true);
        miniTable.setColumnClass(i++, Timestamp.class, true);
        miniTable.setColumnClass(i++, String.class, true);
        miniTable.autoSize();
    }

    public boolean generate(int factId, String time) {
        log.info("");
        String matchcode = "Manual: " + Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name") + " " + time;
        MFactReconciliation rec = (MFactReconciliation)new Query(Env.getCtx(), "Fact_Reconciliation", "Fact_Acct_ID = ?", null).setParameters(new Object[]{factId}).first();
        if (rec == null) {
            rec = new MFactReconciliation(Env.getCtx(), 0, null);
            rec.setFact_Acct_ID(factId);
        }
        rec.setMatchCode(matchcode);
        return rec.save();
    }

    public boolean reset(int factId) {
        log.info("");
        MFactReconciliation rec = (MFactReconciliation)new Query(Env.getCtx(), "Fact_Reconciliation", "Fact_Acct_ID = ?", null).setParameters(new Object[]{factId}).first();
        if (rec == null) {
            return false;
        }
        rec.setMatchCode(null);
        return rec.save();
    }

    protected Vector<KeyNamePair> getAccount() {
        Vector<KeyNamePair> vector;
        block6: {
            vector = new Vector<KeyNamePair>();
            String sql = String.valueOf(MRole.getDefault().addAccessSQL("SELECT ev.C_ElementValue_ID, ev.Value || ' ' || ev.Name FROM C_ElementValue ev", "ev", true, false)) + "AND ev.IsActive='Y' AND ev.IsSummary='N' " + "AND ev.C_Element_ID IN (SELECT C_Element_ID FROM C_AcctSchema_Element ase " + "WHERE ase.ElementType='AC' AND ase.AD_Client_ID=" + this.m_AD_Client_ID + ") " + "ORDER BY 2";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        vector.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return vector;
    }
}

