/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.webservices.client;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.axis.soap.MessageFactoryImpl;
import org.apache.axis.soap.SOAPConnectionFactoryImpl;
import org.compiere.model.Lookup;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;
import org.idempiere.adInterface.x10.ADLoginRequest;
import org.idempiere.adInterface.x10.DataField;
import org.idempiere.adInterface.x10.DataRow;
import org.idempiere.adInterface.x10.DataSet;
import org.idempiere.adInterface.x10.ModelGetList;
import org.idempiere.adInterface.x10.ModelGetListRequest;
import org.idempiere.adInterface.x10.ModelGetListRequestDocument;
import org.idempiere.adInterface.x10.WindowTabData;
import org.idempiere.adInterface.x10.WindowTabDataDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GetListLookup
extends Lookup {
    private static final long serialVersionUID = -137206840260406730L;
    private String filter;
    private String serviceType;
    private String endPoint;
    private String keyColumn;
    private String displayColumn;
    private volatile LinkedHashMap<Object, NamePair> dataMap = new LinkedHashMap();
    private boolean m_refreshing = false;
    private ADLoginRequest login;

    public GetListLookup(int windowNo, ADLoginRequest login, String keyColumn, String displayColumn, String filter, String endPoint, String serviceType) {
        super(18, windowNo);
        this.keyColumn = keyColumn;
        this.displayColumn = displayColumn;
        this.filter = filter;
        this.endPoint = endPoint;
        this.serviceType = serviceType;
        this.login = login;
    }

    public String getDisplay(Object key) {
        NamePair pair = this.dataMap.get(key);
        return pair != null ? pair.getName() : "";
    }

    public NamePair get(Object key) {
        return this.dataMap.get(key);
    }

    public ArrayList<Object> getData(boolean mandatory, boolean onlyValidated, boolean onlyActive, boolean temporary, boolean shortlist) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                this.dataMap = new LinkedHashMap();
                SOAPConnectionFactoryImpl cf = new SOAPConnectionFactoryImpl();
                SOAPConnection conn = cf.createConnection();
                MessageFactoryImpl mf = new MessageFactoryImpl();
                SOAPMessage message = mf.createMessage();
                SOAPPart part = message.getSOAPPart();
                SOAPEnvelope env = part.getEnvelope();
                SOAPBody body = env.getBody();
                ModelGetListRequestDocument getListDocument = ModelGetListRequestDocument.Factory.newInstance();
                ModelGetListRequest getListRequest = getListDocument.addNewModelGetListRequest();
                getListRequest.setADLoginRequest(this.login);
                ModelGetList getList = getListRequest.addNewModelGetList();
                getList.setFilter(this.filter);
                getList.setServiceType(this.serviceType);
                body.addDocument((Document)getListDocument.getDomNode());
                URL endpoint = new URL(this.endPoint);
                SOAPMessage responseMsg = null;
                try {
                    responseMsg = conn.call(message, (Object)endpoint);
                }
                finally {
                    conn.close();
                }
                if (responseMsg != null && responseMsg.getSOAPBody() != null) {
                    DataRow[] dataRows;
                    if (responseMsg.getSOAPBody().hasFault()) {
                        throw new RuntimeException(responseMsg.getSOAPBody().getFault().getFaultString());
                    }
                    WindowTabDataDocument responseDoc = WindowTabDataDocument.Factory.parse((Node)responseMsg.getSOAPBody().getFirstChild().getFirstChild());
                    WindowTabData windowTabData = responseDoc.getWindowTabData();
                    if (windowTabData.isSetError()) {
                        throw new RuntimeException(windowTabData.getError());
                    }
                    DataSet dataset = windowTabData.getDataSet();
                    DataRow[] dataRowArray = dataRows = dataset.getDataRowArray();
                    int n = dataRows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DataRow dataRow = dataRowArray[n2];
                        DataField[] dataFields = dataRow.getFieldArray();
                        String key = null;
                        String display = null;
                        DataField[] dataFieldArray = dataFields;
                        int n3 = dataFields.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            DataField dataField = dataFieldArray[n4];
                            if (dataField.getColumn().equals(this.keyColumn)) {
                                key = dataField.getVal();
                            } else if (dataField.getColumn().equals(this.displayColumn)) {
                                display = dataField.getVal();
                            }
                            ++n4;
                        }
                        if (key != null && display != null) {
                            this.dataMap.put(key, (NamePair)new ValueNamePair(key, display));
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return new ArrayList<NamePair>(this.dataMap.values());
    }

    public String getColumnName() {
        return this.keyColumn;
    }

    public boolean containsKey(Object key) {
        return this.dataMap.containsKey(key);
    }

    public int refresh() {
        if (this.m_refreshing) {
            return 0;
        }
        try {
            this.m_refreshing = true;
            this.fillComboBox(this.isMandatory(), true, true, false, this.isShortList());
            int n = this.dataMap.size();
            return n;
        }
        finally {
            this.m_refreshing = false;
        }
    }
}

