/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.adinterface;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.ValueNamePair;
import org.idempiere.adInterface.x10.LookupValue;
import org.idempiere.adInterface.x10.LookupValues;

public class ADLookup {
    protected static CLogger log = CLogger.getCLogger(ADLookup.class);
    private static final String UUID_REGEX = "[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}";

    public static void fillLookupValues(LookupValues lvs, Lookup lookup, boolean isMandatory, boolean isReadOnly, boolean isShortList) {
        if (lookup.getSize() == 0) {
            lookup.refresh();
        }
        Object[] list = lookup.getData(isMandatory, true, !isReadOnly, false, isShortList).toArray();
        int i2 = 0;
        while (i2 < list.length) {
            KeyNamePair p;
            boolean isNumber = list[0] instanceof KeyNamePair;
            LookupValue lv = lvs.addNewLv();
            if (isNumber) {
                p = (KeyNamePair)list[i2];
                lv.setKey(Integer.toString(p.getKey()));
                lv.setVal(p.getName());
            } else {
                p = (ValueNamePair)list[i2];
                lv.setKey(p.getValue());
                lv.setVal(p.getName());
            }
            ++i2;
        }
    }

    public static String getDirectAccessSQL(Lookup lookup, String text) {
        StringBuffer sql;
        String m_tableName;
        String m_columnName;
        block44: {
            int AD_Reference_ID;
            m_columnName = lookup.getColumnName();
            m_tableName = null;
            String m_keyColumnName = null;
            sql = new StringBuffer();
            if (m_columnName.indexOf(".") > 0) {
                m_tableName = m_columnName.substring(0, m_columnName.indexOf("."));
                m_keyColumnName = m_columnName.substring(m_columnName.indexOf(".") + 1);
            } else {
                m_tableName = m_columnName.substring(0, m_columnName.length() - 3);
                m_keyColumnName = m_columnName;
            }
            if (ADLookup.isUUID(text)) {
                sql.append("SELECT ").append(m_keyColumnName).append(" FROM ").append(m_tableName).append(" WHERE ").append(m_tableName).append("_UU=").append(DB.TO_STRING((String)text.toLowerCase()));
            } else if (m_columnName.equals("M_Product_ID")) {
                sql.append("SELECT M_Product_ID FROM M_Product WHERE (UPPER(Value) LIKE ").append(DB.TO_STRING((String)text)).append(" OR UPPER(Name) LIKE ").append(DB.TO_STRING((String)text)).append(" OR UPC LIKE ").append(DB.TO_STRING((String)text)).append(")");
            } else if (m_columnName.equals("C_BPartner_ID")) {
                sql.append("SELECT C_BPartner_ID FROM C_BPartner WHERE (UPPER(Value) LIKE ").append(DB.TO_STRING((String)text)).append(" OR UPPER(Name) LIKE ").append(DB.TO_STRING((String)text)).append(")");
            } else if (m_columnName.equals("C_Order_ID")) {
                sql.append("SELECT C_Order_ID FROM C_Order WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
            } else if (m_columnName.equals("C_Invoice_ID")) {
                sql.append("SELECT C_Invoice_ID FROM C_Invoice WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
            } else if (m_columnName.equals("M_InOut_ID")) {
                sql.append("SELECT M_InOut_ID FROM M_InOut WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
            } else if (m_columnName.equals("C_Payment_ID")) {
                sql.append("SELECT C_Payment_ID FROM C_Payment WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
            } else if (m_columnName.equals("GL_JournalBatch_ID")) {
                sql.append("SELECT GL_JournalBatch_ID FROM GL_JournalBatch WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
            } else if (m_columnName.equals("SalesRep_ID")) {
                sql.append("SELECT AD_User_ID FROM AD_User WHERE UPPER(Name) LIKE ").append(DB.TO_STRING((String)text));
                m_tableName = "AD_User";
                m_keyColumnName = "AD_User_ID";
            }
            if (sql.length() > 0) {
                String wc = ADLookup.getWhereClause(lookup);
                if (wc != null && wc.length() > 0) {
                    sql.append(" AND ").append(wc);
                }
                sql.append(" AND IsActive='Y'");
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(String.valueOf(m_columnName) + " (predefined) " + sql.toString());
                }
                return MRole.getDefault().addAccessSQL(sql.toString(), m_tableName, false, false);
            }
            if (lookup != null && lookup instanceof MLookup && (AD_Reference_ID = ((MLookup)lookup).getAD_Reference_Value_ID()) != 0) {
                String displayColumnName;
                boolean isValueDisplayed;
                block42: {
                    isValueDisplayed = false;
                    String query = "SELECT kc.ColumnName, dc.ColumnName, t.TableName, rt.IsValueDisplayed FROM AD_Ref_Table rt INNER JOIN AD_Column kc ON (rt.AD_Key=kc.AD_Column_ID) INNER JOIN AD_Column dc ON (rt.AD_Display=dc.AD_Column_ID) INNER JOIN AD_Table t ON (rt.AD_Table_ID=t.AD_Table_ID) WHERE rt.AD_Reference_ID=?";
                    displayColumnName = null;
                    CPreparedStatement pstmt2 = null;
                    ResultSet rs = null;
                    try {
                        try {
                            pstmt2 = DB.prepareStatement((String)query, null);
                            pstmt2.setInt(1, AD_Reference_ID);
                            rs = pstmt2.executeQuery();
                            if (rs.next()) {
                                m_keyColumnName = rs.getString(1);
                                displayColumnName = rs.getString(2);
                                m_tableName = rs.getString(3);
                                String t = rs.getString(4);
                                isValueDisplayed = "Y".equalsIgnoreCase(t);
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, query, (Throwable)e);
                            DB.close(rs, (Statement)pstmt2);
                            break block42;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, (Statement)pstmt2);
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt2);
                }
                if (displayColumnName != null) {
                    sql = new StringBuffer();
                    sql.append("SELECT ").append(m_keyColumnName).append(" FROM ").append(m_tableName).append(" WHERE (UPPER(").append(displayColumnName).append(") LIKE ").append(DB.TO_STRING((String)text));
                    if (isValueDisplayed) {
                        sql.append(" OR UPPER(").append("Value").append(") LIKE ").append(DB.TO_STRING((String)text));
                    }
                    sql.append(")");
                    sql.append(" AND IsActive='Y'");
                    String wc = ADLookup.getWhereClause(lookup);
                    if (wc != null && wc.length() > 0) {
                        sql.append(" AND ").append(wc);
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest(String.valueOf(m_columnName) + " (Table) " + sql.toString());
                    }
                    return MRole.getDefault().addAccessSQL(sql.toString(), m_tableName, false, false);
                }
            }
            String query = "SELECT t.TableName, c.ColumnName FROM AD_Column c  INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID AND t.IsView='N') WHERE (c.ColumnName IN ('DocumentNo', 'Value', 'Name') OR c.IsIdentifier='Y') AND c.AD_Reference_ID IN (10,14) AND EXISTS (SELECT * FROM AD_Column cc WHERE cc.AD_Table_ID=t.AD_Table_ID AND cc.IsKey='Y' AND cc.ColumnName=?)";
            sql = new StringBuffer();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)query, null);
                    pstmt.setString(1, m_keyColumnName);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if (sql.length() != 0) {
                            sql.append(" OR ");
                        }
                        m_tableName = rs.getString(1);
                        sql.append("UPPER(").append(rs.getString(2)).append(") LIKE ").append(DB.TO_STRING((String)text));
                    }
                }
                catch (SQLException ex) {
                    log.log(Level.SEVERE, query, (Throwable)ex);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block44;
                }
            }
            catch (Throwable pstmt2) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw pstmt2;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (sql.length() == 0) {
            log.log(Level.SEVERE, String.valueOf(m_columnName) + " (TableDir) - no standard/identifier columns");
            return "";
        }
        StringBuffer retValue = new StringBuffer("SELECT ").append(m_columnName).append(" FROM ").append(m_tableName).append(" WHERE ").append(sql).append(" AND IsActive='Y'");
        String wc = ADLookup.getWhereClause(lookup);
        if (wc != null && wc.length() > 0) {
            retValue.append(" AND ").append(wc);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.valueOf(m_columnName) + " (TableDir) " + sql.toString());
        }
        return MRole.getDefault().addAccessSQL(retValue.toString(), m_tableName, false, false);
    }

    private static String getWhereClause(Lookup lookup) {
        String validation;
        String whereClause = "";
        if (lookup == null) {
            return "";
        }
        if (lookup.getZoomQuery() != null) {
            whereClause = lookup.getZoomQuery().getWhereClause();
        }
        if ((validation = lookup.getValidation()) == null) {
            validation = "";
        }
        if (whereClause.length() == 0) {
            whereClause = validation;
        } else if (validation.length() > 0) {
            whereClause = String.valueOf(whereClause) + " AND " + validation;
        }
        if (whereClause.indexOf(64) != -1) {
            String validated = Env.parseContext((Properties)Env.getCtx(), (int)lookup.getWindowNo(), (String)whereClause, (boolean)false);
            if (validated.length() == 0) {
                log.severe(String.valueOf(lookup.getColumnName()) + " - Cannot Parse=" + whereClause);
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(String.valueOf(lookup.getColumnName()) + " - Parsed: " + validated);
                }
                return validated;
            }
        }
        return whereClause;
    }

    public static boolean isUUID(String value) {
        return value == null ? false : value.matches(UUID_REGEX);
    }
}

