/*
 * Decompiled with CFR 0.152.
 */
package net.sf.compilo.data;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import net.sf.compilo.data.compiereDataSource;
import net.sf.compilo.report.ReportInfo;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRQueryExecuter;
import org.compiere.util.DB;

public class DBDataSource
extends compiereDataSource {
    private PreparedStatement m_pstmt = null;
    private ResultSet m_resultSet = null;

    public DBDataSource(Properties ctx, ReportInfo ri, HashMap<String, Object> params) {
        JasperReport jr = ri.getJasperReport();
        HashMap<String, JRParameter> parametersMap = new HashMap<String, JRParameter>();
        JRParameter[] jpara = jr.getParameters();
        int i2 = 0;
        while (i2 < jpara.length) {
            parametersMap.put(jpara[i2].getName(), jpara[i2]);
            ++i2;
        }
        try {
            this.m_pstmt = JRQueryExecuter.getStatement(jr.getQuery(), parametersMap, params, DB.getConnectionRO());
            if (this.m_pstmt != null) {
                this.m_resultSet = this.m_pstmt.executeQuery();
            }
        }
        catch (JRException jre) {
            this.log.saveError("GetStatement", (Exception)((Object)jre));
            this.m_resultSet = null;
        }
        catch (SQLException sqle) {
            this.log.saveError("GetResultSet", (Exception)sqle);
            this.m_resultSet = null;
        }
    }

    @Override
    public Object getFieldValue(JRField field) throws JRException {
        Object objValue = null;
        if (field != null && this.m_resultSet != null) {
            Class clazz = field.getValueClass();
            try {
                if (clazz.equals(Object.class)) {
                    objValue = this.m_resultSet.getObject(field.getName());
                } else if (clazz.equals(Boolean.class)) {
                    objValue = this.m_resultSet.getBoolean(field.getName()) ? Boolean.TRUE : Boolean.FALSE;
                } else if (clazz.equals(Byte.class)) {
                    objValue = new Byte(this.m_resultSet.getByte(field.getName()));
                    if (this.m_resultSet.wasNull()) {
                        objValue = null;
                    }
                } else if (clazz.equals(Date.class)) {
                    objValue = this.m_resultSet.getDate(field.getName());
                    if (this.m_resultSet.wasNull()) {
                        objValue = null;
                    }
                } else if (clazz.equals(Timestamp.class)) {
                    objValue = this.m_resultSet.getTimestamp(field.getName());
                    if (this.m_resultSet.wasNull()) {
                        objValue = null;
                    }
                } else if (clazz.equals(Time.class)) {
                    objValue = this.m_resultSet.getTime(field.getName());
                    if (this.m_resultSet.wasNull()) {
                        objValue = null;
                    }
                } else if (clazz.equals(Double.class)) {
                    objValue = new Double(this.m_resultSet.getDouble(field.getName()));
                    if (this.m_resultSet.wasNull()) {
                        objValue = null;
                    }
                } else if (clazz.equals(Float.class)) {
                    objValue = new Float(this.m_resultSet.getFloat(field.getName()));
                    if (this.m_resultSet.wasNull()) {
                        objValue = null;
                    }
                } else if (clazz.equals(Integer.class)) {
                    objValue = new Integer(this.m_resultSet.getInt(field.getName()));
                    if (this.m_resultSet.wasNull()) {
                        objValue = null;
                    }
                } else if (clazz.equals(Long.class)) {
                    objValue = new Long(this.m_resultSet.getLong(field.getName()));
                    if (this.m_resultSet.wasNull()) {
                        objValue = null;
                    }
                } else if (clazz.equals(Short.class)) {
                    objValue = new Short(this.m_resultSet.getShort(field.getName()));
                    if (this.m_resultSet.wasNull()) {
                        objValue = null;
                    }
                } else if (clazz.equals(BigDecimal.class)) {
                    objValue = this.m_resultSet.getBigDecimal(field.getName());
                    if (this.m_resultSet.wasNull()) {
                        objValue = null;
                    }
                } else if (clazz.equals(String.class)) {
                    objValue = this.m_resultSet.getString(field.getName());
                    if (this.m_resultSet.wasNull()) {
                        objValue = null;
                    }
                }
            }
            catch (Exception e) {
                throw new JRException("Unable to get value for field '" + field.getName() + "' of class '" + clazz.getName() + "'", (Throwable)e);
            }
        }
        return objValue;
    }

    @Override
    public boolean next() throws JRException {
        boolean retValue = false;
        if (this.m_resultSet == null) {
            return retValue;
        }
        try {
            retValue = this.m_resultSet.next();
        }
        catch (SQLException sqle) {
            throw new JRException((Throwable)sqle);
        }
        return retValue;
    }

    @Override
    public void close() {
        DB.close((ResultSet)this.m_resultSet);
        this.m_resultSet = null;
        DB.close((Statement)this.m_pstmt);
        this.m_pstmt = null;
    }
}

