/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.ws;

import com.trekglobal.ws.CompositeService;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.jws.WebService;
import org.compiere.util.CLogger;
import org.compiere.util.Trx;
import org.idempiere.adInterface.x10.ADLoginRequest;
import org.idempiere.adInterface.x10.CompositeRequest;
import org.idempiere.adInterface.x10.CompositeRequestDocument;
import org.idempiere.adInterface.x10.CompositeResponse;
import org.idempiere.adInterface.x10.CompositeResponses;
import org.idempiere.adInterface.x10.CompositeResponsesDocument;
import org.idempiere.adInterface.x10.ModelCRUDRequest;
import org.idempiere.adInterface.x10.ModelCRUDRequestDocument;
import org.idempiere.adInterface.x10.ModelRunProcessRequest;
import org.idempiere.adInterface.x10.ModelRunProcessRequestDocument;
import org.idempiere.adInterface.x10.ModelSetDocActionRequest;
import org.idempiere.adInterface.x10.ModelSetDocActionRequestDocument;
import org.idempiere.adInterface.x10.Operation;
import org.idempiere.adInterface.x10.Operations;
import org.idempiere.adInterface.x10.RunProcessResponseDocument;
import org.idempiere.adInterface.x10.StandardResponse;
import org.idempiere.adInterface.x10.StandardResponseDocument;
import org.idempiere.adInterface.x10.WindowTabDataDocument;
import org.idempiere.adinterface.ModelADServiceImpl;
import org.idempiere.webservices.AbstractService;

@WebService(endpointInterface="com.trekglobal.ws.CompositeService", serviceName="compositeInterface", targetNamespace="http://idempiere.org/ADInterface/1_0")
public class CompositeServiceImpl
extends AbstractService
implements CompositeService {
    private static CLogger log = CLogger.getCLogger(CompositeServiceImpl.class);
    private static String webServiceName = new String("CompositeInterface");

    public CompositeServiceImpl() {
        if (log.isLoggable(Level.INFO)) {
            log.info("Creating session object compositeInterface");
        }
    }

    @Override
    public CompositeResponsesDocument compositeOperation(CompositeRequestDocument reqs) {
        boolean connected = this.getCompiereService().isConnected();
        try {
            if (!connected) {
                this.getCompiereService().connect();
            }
            CompositeResponsesDocument ret = CompositeResponsesDocument.Factory.newInstance();
            CompositeResponses resps = ret.addNewCompositeResponses();
            CompositeRequest req = reqs.getCompositeRequest();
            String serviceType = req.getServiceType();
            ADLoginRequest reqlogin = req.getADLoginRequest();
            String err = this.login(reqlogin, webServiceName, "composite", serviceType);
            if (err != null && err.length() > 0) {
                CompositeResponse resp = resps.addNewCompositeResponse();
                StandardResponse stdResp = resp.addNewStandardResponse();
                stdResp.setError(err);
                stdResp.setIsError(true);
                CompositeResponsesDocument compositeResponsesDocument = ret;
                return compositeResponsesDocument;
            }
            ModelADServiceImpl modelADService = new ModelADServiceImpl(this.ctx);
            String trxName = Trx.createTrxName((String)webServiceName);
            Trx trx = Trx.get((String)trxName, (boolean)true);
            try {
                Operations[] operationsArr;
                modelADService.setLocalTrxName(trxName);
                Operations[] operationsArray = operationsArr = req.getOperationsArray();
                int n = operationsArr.length;
                int n2 = 0;
                while (n2 < n) {
                    Operations operations = operationsArray[n2];
                    Operation[] operationArr = operations.getOperationArray();
                    if (operationArr.length > 0) {
                        CompositeResponse compResp = resps.addNewCompositeResponse();
                        ArrayList<StandardResponse> respAggregator = new ArrayList<StandardResponse>();
                        try {
                            boolean isSuccess = this.performOperations(trx, operationArr, modelADService, compResp, respAggregator, reqlogin);
                            if (isSuccess) {
                                this.commitTrx(trx, compResp, respAggregator, "Cannot commit at end of process", false);
                            }
                        }
                        catch (RuntimeException e) {
                            this.rollbackAndSetError(trx, compResp, respAggregator, e.getLocalizedMessage());
                            throw e;
                        }
                    }
                    ++n2;
                }
            }
            finally {
                trx.close();
            }
            CompositeResponsesDocument compositeResponsesDocument = ret;
            return compositeResponsesDocument;
        }
        finally {
            if (!connected) {
                this.getCompiereService().disconnect();
            }
        }
    }

    private boolean performOperations(Trx trx, Operation[] ops, ModelADServiceImpl modelADService, CompositeResponse compResp, ArrayList<StandardResponse> respAggregator, ADLoginRequest reqlogin) {
        Operation[] operationArray = ops;
        int n = ops.length;
        int n2 = 0;
        while (n2 < n) {
            ModelCRUDRequestDocument wrapperDoc;
            Operation operation = operationArray[n2];
            if (operation.getPreCommit() && !this.commitTrx(trx, compResp, respAggregator, "Cannot commit before Operation", true)) {
                return false;
            }
            modelADService.setManageTrx(false);
            Operation.TargetPort.Enum portEnum = operation.getTargetPort();
            StandardResponseDocument respDoc = null;
            if (portEnum == Operation.TargetPort.CREATE_DATA) {
                wrapperDoc = this.getWrappedCRUD(operation, reqlogin);
                if (wrapperDoc == null) {
                    this.rollbackAndSetError(trx, compResp, respAggregator, "Operation createData must required ModelCRUD");
                    return false;
                }
                respDoc = modelADService.createData(wrapperDoc);
            } else if (portEnum == Operation.TargetPort.DELETE_DATA) {
                wrapperDoc = this.getWrappedCRUD(operation, reqlogin);
                if (wrapperDoc == null) {
                    this.rollbackAndSetError(trx, compResp, respAggregator, "Operation deleteData must required ModelCRUD");
                    return false;
                }
                respDoc = modelADService.deleteData(wrapperDoc);
            } else if (portEnum == Operation.TargetPort.CREATE_UPDATE_DATA) {
                wrapperDoc = this.getWrappedCRUD(operation, reqlogin);
                if (wrapperDoc == null) {
                    this.rollbackAndSetError(trx, compResp, respAggregator, "Operation createUpdateData must required ModelCRUD");
                    return false;
                }
                respDoc = modelADService.createUpdateData(wrapperDoc);
            } else if (portEnum == Operation.TargetPort.READ_DATA) {
                wrapperDoc = this.getWrappedCRUD(operation, reqlogin);
                if (wrapperDoc == null) {
                    respDoc = StandardResponseDocument.Factory.newInstance();
                    StandardResponse resp = respDoc.addNewStandardResponse();
                    resp.setIsError(false);
                    resp.setError("Operation readData must required ModelCRUD");
                } else {
                    WindowTabDataDocument dataResponse = modelADService.readData(wrapperDoc);
                    if (dataResponse != null) {
                        respDoc = StandardResponseDocument.Factory.newInstance();
                        StandardResponse resp = respDoc.addNewStandardResponse();
                        resp.setIsError(false);
                        resp.setWindowTabData(dataResponse.getWindowTabData());
                    }
                }
            } else if (portEnum == Operation.TargetPort.RUN_PROCESS) {
                if (operation.getModelRunProcess() == null) {
                    this.rollbackAndSetError(trx, compResp, respAggregator, "Operation runProcess must required ModelRunProcess");
                    return false;
                }
                wrapperDoc = ModelRunProcessRequestDocument.Factory.newInstance();
                ModelRunProcessRequest runProcessReq = wrapperDoc.addNewModelRunProcessRequest();
                runProcessReq.setADLoginRequest(reqlogin);
                runProcessReq.setModelRunProcess(operation.getModelRunProcess());
                RunProcessResponseDocument runResponse = modelADService.runProcess((ModelRunProcessRequestDocument)wrapperDoc);
                if (runResponse != null) {
                    respDoc = StandardResponseDocument.Factory.newInstance();
                    StandardResponse resp = respDoc.addNewStandardResponse();
                    resp.setIsError(runResponse.getRunProcessResponse().getIsError());
                    resp.setRunProcessResponse(runResponse.getRunProcessResponse());
                }
            } else if (portEnum == Operation.TargetPort.SET_DOC_ACTION) {
                if (operation.getModelSetDocAction() == null) {
                    this.rollbackAndSetError(trx, compResp, respAggregator, "Operation updateData must required ModelSetDocAction");
                    return false;
                }
                wrapperDoc = ModelSetDocActionRequestDocument.Factory.newInstance();
                ModelSetDocActionRequest actionReq = wrapperDoc.addNewModelSetDocActionRequest();
                actionReq.setADLoginRequest(reqlogin);
                actionReq.setModelSetDocAction(operation.getModelSetDocAction());
                respDoc = modelADService.setDocAction((ModelSetDocActionRequestDocument)wrapperDoc);
            } else if (portEnum == Operation.TargetPort.UPDATE_DATA) {
                wrapperDoc = this.getWrappedCRUD(operation, reqlogin);
                if (wrapperDoc == null) {
                    this.rollbackAndSetError(trx, compResp, respAggregator, "Operation updateData must required ModelCRUD");
                    return false;
                }
                respDoc = modelADService.updateData(wrapperDoc);
            }
            if (respDoc != null) {
                respAggregator.add(respDoc.getStandardResponse());
            }
            if (respDoc != null && respDoc.getStandardResponse().getIsError()) {
                this.rollbackAndSetError(trx, compResp, respAggregator, null);
                return false;
            }
            if (operation.getPostCommit() && !this.commitTrx(trx, compResp, respAggregator, "Cannot commit after operation", false)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private ModelCRUDRequestDocument getWrappedCRUD(Operation operation, ADLoginRequest reqlogin) {
        if (operation.getModelCRUD() == null) {
            return null;
        }
        ModelCRUDRequestDocument wrapperDoc = ModelCRUDRequestDocument.Factory.newInstance();
        ModelCRUDRequest wrapperCRUD = wrapperDoc.addNewModelCRUDRequest();
        wrapperCRUD.setModelCRUD(operation.getModelCRUD());
        wrapperCRUD.setADLoginRequest(reqlogin);
        return wrapperDoc;
    }

    protected void rollbackAndSetError(Trx trx, CompositeResponse compResp, ArrayList<StandardResponse> respAggregator, String string) {
        if (respAggregator == null) {
            StandardResponse resp = compResp.addNewStandardResponse();
            resp.setError(string);
            resp.setIsError(true);
        } else {
            StandardResponse resp2;
            int ind = 0;
            StandardResponse[] orgArr = compResp.getStandardResponseArray();
            StandardResponse[] respArr = new StandardResponse[orgArr.length + respAggregator.size()];
            StandardResponse[] standardResponseArray = orgArr;
            int n = orgArr.length;
            int n2 = 0;
            while (n2 < n) {
                resp2 = standardResponseArray[n2];
                respArr[ind++] = resp2;
                ++n2;
            }
            for (StandardResponse resp2 : respAggregator) {
                resp2.setIsRolledBack(true);
                respArr[ind++] = resp2;
            }
            if (string != null && respAggregator.size() > 0) {
                resp2 = respAggregator.get(respAggregator.size() - 1);
                resp2.setError(string);
                resp2.setIsError(true);
            }
            compResp.setStandardResponseArray(respArr);
            respAggregator.clear();
        }
        trx.rollback();
        trx.close();
    }

    protected boolean commitTrx(Trx trx, CompositeResponse compResp, ArrayList<StandardResponse> respAggregator, String string, boolean addNewResp) {
        if (trx.isActive() && !trx.commit()) {
            if (addNewResp) {
                respAggregator.add(StandardResponse.Factory.newInstance());
            }
            this.rollbackAndSetError(trx, compResp, respAggregator, string);
            return false;
        }
        int ind = 0;
        StandardResponse[] orgArr = compResp.getStandardResponseArray();
        StandardResponse[] respArr = new StandardResponse[orgArr.length + respAggregator.size()];
        StandardResponse[] standardResponseArray = orgArr;
        int n = orgArr.length;
        int n2 = 0;
        while (n2 < n) {
            StandardResponse resp = standardResponseArray[n2];
            respArr[ind++] = resp;
            ++n2;
        }
        for (StandardResponse resp : respAggregator) {
            respArr[ind++] = resp;
        }
        compResp.setStandardResponseArray(respArr);
        respAggregator.clear();
        return true;
    }
}

