/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.ReferenceUtils;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.wf.MWFNode;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WorkflowNodeElementHandler
extends AbstractElementHandler {
    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        PoFiller filler;
        List notfounds;
        List excludes = this.defaultExcludeList("AD_WF_Node");
        String entitytype = this.getStringValue(element, "EntityType");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        if (this.isParentDefer(element, "AD_Workflow")) {
            element.unresolved = "Parent element mark as defer: " + this.getStringValue(element, "AD_Workflow.Value");
            element.defer = true;
            return;
        }
        MWFNode mWFNode = (MWFNode)this.findPO(ctx, element);
        if (mWFNode == null) {
            int workflowId = 0;
            Element wfElement = (Element)element.properties.get("AD_Workflow_ID");
            workflowId = this.getParentId(element, "AD_Workflow") > 0 ? this.getParentId(element, "AD_Workflow") : ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)wfElement, (String)this.getTrxName(ctx));
            if (workflowId <= 0) {
                element.defer = true;
                element.unresolved = "AD_Workflow: " + wfElement.contents;
                return;
            }
            String workflowNodeValue = this.getStringValue(element, "Value", excludes);
            StringBuilder sqlB = new StringBuilder("SELECT AD_WF_Node_ID FROM AD_WF_Node WHERE AD_Workflow_ID=? and Value =?");
            int id = DB.getSQLValue((String)this.getTrxName(ctx), (String)sqlB.toString(), (int)workflowId, (String)workflowNodeValue);
            mWFNode = new MWFNode(ctx.ctx, id > 0 ? id : 0, this.getTrxName(ctx));
            mWFNode.setValue(workflowNodeValue);
            mWFNode.setAD_Workflow_ID(workflowId);
            excludes.add("AD_Workflow_ID");
            excludes.add("Value");
        }
        if ((notfounds = (filler = new PoFiller(ctx, (PO)mWFNode, element, (AbstractElementHandler)this)).autoFill(excludes)).size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        if (!mWFNode.is_new()) {
            if (!mWFNode.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_WF_Node", 129);
        String action = null;
        if (mWFNode.getAD_WF_Node_ID() == 0 && this.isOfficialId(element, "AD_WF_Node_ID")) {
            mWFNode.setAD_WF_Node_ID(this.getIntValue(element, "AD_WF_Node_ID"));
        }
        if (!mWFNode.is_new()) {
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_WF_Node", (PO)mWFNode);
            action = "Update";
        } else {
            action = "New";
        }
        if (mWFNode.save(this.getTrxName(ctx))) {
            this.log.info("m_WFNode save success");
            this.logImportDetail(ctx, impDetail, 1, mWFNode.getName(), mWFNode.get_ID(), action);
            return;
        }
        this.log.info("m_WFNode save failure");
        this.logImportDetail(ctx, impDetail, 0, mWFNode.getName(), mWFNode.get_ID(), action);
        throw new POSaveFailedException("Failed to save WorkflowNode " + mWFNode.getName());
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int AD_WF_Node_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_WF_Node_ID");
        AttributesImpl atts = new AttributesImpl();
        MWFNode m_WF_Node = new MWFNode(ctx.ctx, AD_WF_Node_ID, this.getTrxName(ctx));
        if (ctx.packOut.getFromDate() != null && m_WF_Node.getUpdated().compareTo(ctx.packOut.getFromDate()) < 0) {
            return;
        }
        this.addTypeName(atts, "table");
        document.startElement("", "", "AD_WF_Node", atts);
        this.createWorkflowNodeBinding(ctx, document, m_WF_Node);
        document.endElement("", "", "AD_WF_Node");
    }

    private void createWorkflowNodeBinding(PIPOContext ctx, TransformerHandler document, MWFNode m_WF_Node) {
        PoExporter filler = new PoExporter(ctx, document, (PO)m_WF_Node);
        List excludes = this.defaultExcludeList("AD_WF_Node");
        if (m_WF_Node.getAD_WF_Node_ID() <= 999999) {
            filler.add("AD_WF_Node_ID", new AttributesImpl());
        }
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_WF_Node_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_WF_Node_ID");
    }
}

