/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackIn;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.adempiere.pipo2.handler.ColumnElementHandler;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.model.X_AD_Table;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class TableElementHandler
extends AbstractElementHandler {
    private ColumnElementHandler columnHandler = new ColumnElementHandler();
    private List<Integer> tables = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        PoFiller filler;
        List notfounds;
        PackIn packIn = ctx.packIn;
        List excludes = this.defaultExcludeList("AD_Table");
        String entitytype = this.getStringValue(element, "EntityType");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        MTable mTable = (MTable)this.findPO(ctx, element);
        if (mTable == null) {
            String tableName = this.getStringValue(element, "TableName", excludes);
            int id = packIn.getTableId(tableName);
            if (id <= 0 && (id = this.findIdByColumn(ctx, "AD_Table", "TableName", tableName)) > 0) {
                packIn.addTable(tableName, id);
            }
            if (id > 0 && this.isTableProcess(ctx, id)) {
                return;
            }
            mTable = new MTable(ctx.ctx, id > 0 ? id : 0, this.getTrxName(ctx));
            mTable.setTableName(tableName);
        }
        if (mTable.getAD_Table_ID() == 0 && this.isOfficialId(element, "AD_Table_ID")) {
            mTable.setAD_Table_ID(this.getIntValue(element, "AD_Table_ID"));
        }
        if ((notfounds = (filler = new PoFiller(ctx, (PO)mTable, element, (AbstractElementHandler)this)).autoFill(excludes)).size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        if (!mTable.is_new()) {
            if (!mTable.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Table", 100);
        String action = null;
        if (!mTable.is_new()) {
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_Table", (PO)mTable);
            action = "Update";
        } else {
            action = "New";
        }
        if (mTable.save(this.getTrxName(ctx))) {
            this.logImportDetail(ctx, impDetail, 1, mTable.getName(), mTable.get_ID(), action);
            this.tables.add(mTable.getAD_Table_ID());
            packIn.addTable(mTable.getTableName(), mTable.getAD_Table_ID());
            element.recordId = mTable.getAD_Table_ID();
            return;
        }
        this.logImportDetail(ctx, impDetail, 0, mTable.getName(), mTable.get_ID(), action);
        throw new POSaveFailedException("Failed to save Table " + mTable.getName());
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int AD_Table_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Table_ID");
        PackOut packOut = ctx.packOut;
        boolean exported = this.isTableProcess(ctx, AD_Table_ID);
        AttributesImpl atts = new AttributesImpl();
        if (!exported) {
            boolean createElement = true;
            X_AD_Table m_Table = new X_AD_Table(ctx.ctx, AD_Table_ID, null);
            if (ctx.packOut.getFromDate() != null && m_Table.getUpdated().compareTo(ctx.packOut.getFromDate()) < 0) {
                createElement = false;
            }
            if (createElement) {
                this.addTypeName(atts, "table");
                document.startElement("", "", "AD_Table", atts);
                this.createTableBinding(ctx, document, m_Table);
            }
            String sql = "SELECT * FROM AD_Column WHERE AD_Table_ID = ?  ORDER BY IsKey DESC, AD_Column_ID";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                    pstmt.setInt(1, AD_Table_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ElementHandler handler = packOut.getHandler("AD_Element");
                        handler.packOut(packOut, document, null, rs.getInt("AD_Element_ID"));
                        if (rs.getInt("AD_Reference_ID") > 0) {
                            handler = packOut.getHandler("AD_Reference");
                            handler.packOut(packOut, document, null, rs.getInt("AD_Reference_ID"));
                        }
                        if (rs.getInt("AD_Reference_Value_ID") > 0) {
                            handler = packOut.getHandler("AD_Reference");
                            handler.packOut(packOut, document, null, rs.getInt("AD_Reference_Value_ID"));
                        }
                        if (rs.getInt("AD_Process_ID") > 0) {
                            handler = packOut.getHandler("AD_Process");
                            handler.packOut(packOut, document, null, rs.getInt("AD_Process_ID"));
                        }
                        if (rs.getInt("AD_Val_Rule_ID") > 0) {
                            handler = packOut.getHandler("AD_Val_Rule");
                            handler.packOut(packOut, document, null, rs.getInt("AD_Val_Rule_ID"));
                        }
                        this.createColumn(ctx, document, rs.getInt("AD_Column_ID"));
                    }
                }
                catch (Exception e) {
                    throw new AdempiereException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            if (createElement) {
                document.endElement("", "", "AD_Table");
            }
        }
    }

    private void createColumn(PIPOContext ctx, TransformerHandler document, int AD_Column_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_Column_ID", (int)AD_Column_ID);
        this.columnHandler.create(ctx, document);
        ctx.ctx.remove("AD_Column_ID");
    }

    private boolean isTableProcess(PIPOContext ctx, int AD_Table_ID) {
        if (this.tables.contains(AD_Table_ID)) {
            return true;
        }
        this.tables.add(AD_Table_ID);
        return false;
    }

    private void createTableBinding(PIPOContext ctx, TransformerHandler document, X_AD_Table m_Table) {
        PoExporter filler = new PoExporter(ctx, document, (PO)m_Table);
        if (m_Table.getAD_Table_ID() <= 999999) {
            filler.add("AD_Table_ID", new AttributesImpl());
        }
        List excludes = this.defaultExcludeList("AD_Table");
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Table_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Table_ID");
    }
}

