/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.adempiere.pipo2.handler.CommonTranslationHandler;
import org.compiere.model.PO;
import org.compiere.model.X_AD_ModelValidator;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ModelValidatorElementHandler
extends AbstractElementHandler {
    private List<Integer> validators = new ArrayList<Integer>();
    private static final String AD_MODELVALIDATOR = "AD_ModelValidator";

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        String action = null;
        String entitytype = this.getStringValue(element, "EntityType");
        String name = this.getStringValue(element, "Name");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        X_AD_ModelValidator validator = (X_AD_ModelValidator)this.findPO(ctx, element);
        if (validator == null) {
            int id = this.findIdByColumn(ctx, AD_MODELVALIDATOR, "Name", name, true);
            validator = new X_AD_ModelValidator(ctx.ctx, id, this.getTrxName(ctx));
        }
        List excludes = this.defaultExcludeList(AD_MODELVALIDATOR);
        if (validator.getAD_ModelValidator_ID() == 0 && this.isOfficialId(element, "AD_ModelValidator_ID")) {
            validator.setAD_ModelValidator_ID(this.getIntValue(element, "AD_ModelValidator_ID"));
        }
        if (this.validators.contains(validator.getAD_ModelValidator_ID())) {
            element.skip = true;
            return;
        }
        PoFiller pf = new PoFiller(ctx, (PO)validator, element, (AbstractElementHandler)this);
        List notfounds = pf.autoFill(excludes);
        if (notfounds.size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        if (!validator.is_new()) {
            if (!validator.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, AD_MODELVALIDATOR, 53014);
        if (!validator.is_new()) {
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), AD_MODELVALIDATOR, (PO)validator);
            action = "Update";
        } else {
            action = "New";
        }
        if (validator.save(this.getTrxName(ctx))) {
            this.logImportDetail(ctx, impDetail, 1, validator.getName(), validator.get_ID(), action);
            element.recordId = validator.getAD_ModelValidator_ID();
            this.validators.add(validator.getAD_ModelValidator_ID());
            return;
        }
        this.logImportDetail(ctx, impDetail, 0, validator.getName(), validator.get_ID(), action);
        throw new POSaveFailedException("Failed to save Model Validator " + validator.getName());
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        block4: {
            int ad_modelvalidator_id = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_ModelValidator_ID");
            if (this.validators.contains(ad_modelvalidator_id)) {
                return;
            }
            this.validators.add(ad_modelvalidator_id);
            X_AD_ModelValidator validator = new X_AD_ModelValidator(ctx.ctx, ad_modelvalidator_id, null);
            if (ctx.packOut.getFromDate() != null && validator.getUpdated().compareTo(ctx.packOut.getFromDate()) < 0) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            this.addTypeName(atts, "table");
            document.startElement("", "", AD_MODELVALIDATOR, atts);
            this.createADModelValidatorBinding(ctx, document, validator);
            PackOut packOut = ctx.packOut;
            try {
                new CommonTranslationHandler().packOut(packOut, document, null, validator.get_ID());
            }
            catch (Exception e) {
                if (!this.log.isLoggable(Level.INFO)) break block4;
                this.log.info(e.toString());
            }
        }
        document.endElement("", "", AD_MODELVALIDATOR);
    }

    private void createADModelValidatorBinding(PIPOContext ctx, TransformerHandler document, X_AD_ModelValidator validator) {
        PoExporter filler = new PoExporter(ctx, document, (PO)validator);
        if (validator.getAD_ModelValidator_ID() <= 999999) {
            filler.add("AD_ModelValidator_ID", new AttributesImpl());
        }
        List excludes = this.defaultExcludeList(AD_MODELVALIDATOR);
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_ModelValidator_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_ModelValidator_ID");
    }
}

