/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPayment;
import org.compiere.util.CLogger;
import org.compiere.util.WebUser;
import org.compiere.wstore.WebBasket;
import org.compiere.wstore.WebBasketLine;

public class WebOrder {
    public static final String NAME = "webOrder";
    private CLogger log = CLogger.getCLogger(this.getClass());
    private MOrder m_order;
    private Properties m_ctx;
    private String m_invoiceInfo = null;
    private int m_C_Invoice_ID = -1;

    public WebOrder(WebUser wu, WebBasket wb, Properties ctx) {
        this.m_ctx = ctx;
        this.createOrder(wu, wb);
    }

    public WebOrder(MOrder order) {
        this.m_ctx = order.getCtx();
        this.m_order = order;
    }

    private boolean createOrder(WebUser wu, WebBasket wb) {
        this.m_order = new MOrder(this.m_ctx, 0, null);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("AD_Client_ID=" + this.m_order.getAD_Client_ID() + ",AD_Org_ID=" + this.m_order.getAD_Org_ID() + " - " + this.m_order);
        }
        this.m_order.setC_DocTypeTarget_ID("PR");
        this.m_order.setPaymentRule("K");
        this.m_order.setDeliveryRule("R");
        this.m_order.setInvoiceRule("I");
        this.m_order.setIsSelfService(true);
        if (wb.getM_PriceList_ID() > 0) {
            this.m_order.setM_PriceList_ID(wb.getM_PriceList_ID());
        }
        if (wb.getSalesRep_ID() != 0) {
            this.m_order.setSalesRep_ID(wb.getSalesRep_ID());
        }
        this.m_order.setC_BPartner_ID(wu.getC_BPartner_ID());
        this.m_order.setC_BPartner_Location_ID(wu.getC_BPartner_Location_ID());
        this.m_order.setAD_User_ID(wu.getAD_User_ID());
        this.m_order.setSendEMail(true);
        this.m_order.setDocAction("PR");
        this.m_order.saveEx();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("ID=" + this.m_order.getC_Order_ID() + ", DocNo=" + this.m_order.getDocumentNo());
        }
        ArrayList<WebBasketLine> lines = wb.getLines();
        int i = 0;
        while (i < lines.size()) {
            WebBasketLine wbl = lines.get(i);
            MOrderLine ol = new MOrderLine(this.m_order);
            ol.setM_Product_ID(wbl.getM_Product_ID(), true);
            ol.setQty(wbl.getQuantity());
            ol.setPrice();
            ol.setPrice(wbl.getPrice());
            ol.setTax();
            ol.saveEx();
            ++i;
        }
        boolean ok = this.m_order.processIt("PR");
        this.m_order.saveEx();
        if (!wu.isCustomer()) {
            wu.setIsCustomer(true);
            wu.save();
        }
        BigDecimal amt = this.m_order.getGrandTotal();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Amt=" + amt);
        }
        return ok;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebOrder[");
        sb.append(this.m_order).append("]");
        return sb.toString();
    }

    public boolean process(MPayment payment) {
        if (this.m_order == null) {
            return false;
        }
        if (payment.get_ID() == 0) {
            payment.saveEx();
        }
        this.m_order.setC_Payment_ID(payment.getC_Payment_ID());
        this.m_order.setDocAction("WC");
        boolean ok = this.m_order.processIt("WC");
        this.m_order.saveEx();
        payment.setC_Order_ID(this.m_order.getC_Order_ID());
        payment.setC_Invoice_ID(this.getInvoice_ID());
        return ok;
    }

    public int getC_Order_ID() {
        if (this.m_order != null) {
            return this.m_order.getC_Order_ID();
        }
        return 0;
    }

    public int getAD_Org_ID() {
        if (this.m_order != null) {
            return this.m_order.getAD_Org_ID();
        }
        return 0;
    }

    public boolean isCompleted() {
        if (this.m_order == null) {
            return false;
        }
        return "CO".equals(this.m_order.getDocStatus()) || "CL".equals(this.m_order.getDocStatus());
    }

    public boolean isInProgress() {
        if (this.m_order == null) {
            return false;
        }
        return "IP".equals(this.m_order.getDocStatus());
    }

    public String getDocumentNo() {
        return this.m_order.getDocumentNo();
    }

    public BigDecimal getTotalLines() {
        return this.m_order.getTotalLines();
    }

    public BigDecimal getFreightAmt() {
        return this.m_order.getFreightAmt();
    }

    public BigDecimal getTaxAmt() {
        return this.m_order.getGrandTotal().subtract(this.m_order.getTotalLines()).subtract(this.m_order.getFreightAmt());
    }

    public BigDecimal getGrandTotal() {
        return this.m_order.getGrandTotal();
    }

    public int getSalesRep_ID() {
        return this.m_order.getSalesRep_ID();
    }

    protected MOrder getOrder() {
        return this.m_order;
    }

    public String getInvoiceInfo() {
        MInvoice[] invoices;
        int length;
        if (this.m_invoiceInfo == null && (length = (invoices = this.m_order.getInvoices()).length) > 0) {
            this.m_C_Invoice_ID = invoices[length - 1].getC_Invoice_ID();
            this.m_invoiceInfo = invoices[length - 1].getDocumentNo();
        }
        return this.m_invoiceInfo;
    }

    public int getInvoice_ID() {
        if (this.m_C_Invoice_ID == -1) {
            this.getInvoiceInfo();
        }
        return this.m_C_Invoice_ID;
    }

    public int getC_Currency_ID() {
        if (this.m_order == null) {
            return 0;
        }
        return this.m_order.getC_Currency_ID();
    }

    public String getCurrencyISO() {
        if (this.m_order == null) {
            return "";
        }
        return MCurrency.getISO_Code((Properties)this.m_ctx, (int)this.m_order.getC_Currency_ID());
    }
}

