/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.p;
import org.compiere.util.CLogger;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;

public class StoreFilter
implements Filter {
    private static volatile CLogger log = null;

    public void init(FilterConfig config) throws ServletException {
        WebEnv.initWeb((ServletContext)config.getServletContext());
        if (log == null) {
            log = CLogger.getCLogger(StoreFilter.class);
        }
        if (log.isLoggable(Level.INFO)) {
            log.info(config.getFilterName());
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String uri = "";
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            uri = req.getRequestURI();
        }
        boolean check = uri.indexOf("Servlet") != -1;
        boolean pass = true;
        if (check) {
            String enc = request.getCharacterEncoding();
            try {
                enc = request.getCharacterEncoding();
                if (enc == null) {
                    request.setCharacterEncoding("UTF-8");
                }
                if (enc == null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("Checked=" + uri);
                    }
                } else if (log.isLoggable(Level.FINER)) {
                    log.finer("Checked=" + uri + " - Enc=" + enc);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Set CharacterEndocung=" + enc + "->" + "UTF-8", (Throwable)e);
            }
        }
        if (pass) {
            chain.doFilter(request, response);
        } else {
            log.warning("Rejected " + uri);
            String msg = "Error: Access Rejected";
            WebDoc doc = WebDoc.create((String)msg);
            body b = doc.getBody();
            b.addElement((Element)new p(uri, "center"));
            response.setContentType("text/html");
            PrintWriter out = new PrintWriter((OutputStream)response.getOutputStream());
            doc.output(out);
            out.close();
        }
    }
}

