/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MRegistration;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;

public class RegistrationServlet
extends HttpServlet {
    private static final long serialVersionUID = -6448126312542845680L;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    public static final String NAME = "RegistrationServlet";
    public static final String P_REGISTRATION_ID = "A_Registration_ID";
    private String THANKS = "Thank you for your registration!";
    private String PROBLEM = "Thank you for your registration - We experienced a problem - please let us know!";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb((ServletConfig)config)) {
            throw new ServletException("RegistrationServlet.init");
        }
    }

    public String getServletInfo() {
        return "Adempiere Web Registration Servlet";
    }

    public void destroy() {
        this.log.fine("");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        }
        if (!this.processSystemRegistration(request, response)) {
            this.log.info("Forward to registration.jsp");
            if (!response.isCommitted()) {
                response.sendRedirect("registration.jsp");
            }
        }
    }

    private boolean processSystemRegistration(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name = WebUtil.getParameter((HttpServletRequest)request, (String)"Name");
        String userName = WebUtil.getParameter((HttpServletRequest)request, (String)"UserName");
        String password = WebUtil.getParameter((HttpServletRequest)request, (String)"Password");
        if (!(name != null && name.length() != 0 || userName != null && userName.length() != 0 || password != null && password.length() != 0)) {
            return false;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Name=" + name + ", User=" + userName);
        }
        String description = WebUtil.getParameter((HttpServletRequest)request, (String)"Description");
        boolean inProduction = WebUtil.getParameterAsBoolean((HttpServletRequest)request, (String)"IsInProduction", (String)"Y");
        Timestamp startDate = WebUtil.getParameterAsDate((HttpServletRequest)request, (String)"StartProductionDate");
        if (startDate == null) {
            startDate = new Timestamp(System.currentTimeMillis());
        }
        boolean allowPublish = WebUtil.getParameterAsBoolean((HttpServletRequest)request, (String)"IsAllowPublish", (String)"Y");
        boolean registered = WebUtil.getParameterAsBoolean((HttpServletRequest)request, (String)"IsRegistered", (String)"Y");
        int Record_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"Record_ID");
        Properties ctx = JSPEnv.getCtx(request);
        MUser user = null;
        int AD_User_ID = DB.getSQLValue(null, (String)"SELECT AD_User_ID FROM AD_User WHERE EMail=?", (String)userName);
        if (AD_User_ID > 0) {
            user = MUser.get((Properties)ctx, (int)AD_User_ID);
        } else {
            this.log.warning("User Not found=" + userName);
        }
        MRegistration reg = null;
        if (Record_ID > 0) {
            reg = new MRegistration(ctx, Record_ID, null);
            if (reg.get_ID() != Record_ID) {
                this.log.warning("Registration Not found=" + Record_ID);
                reg = null;
            } else if (user != null) {
                if (reg.getC_BPartner_ID() != user.getC_BPartner_ID()) {
                    this.log.warning("Registration for different BP - AD_User_ID=" + AD_User_ID + "(" + user.getEMail() + "), BP RegistrationBP=" + reg.getC_BPartner_ID() + "<>UserBP=" + user.getC_BPartner_ID());
                    reg = null;
                }
                if (!password.equals(user.getPassword())) {
                    this.log.warning("Password does not match - AD_User_ID=" + AD_User_ID + "(" + user.getEMail() + ")");
                }
            }
        }
        if (reg == null) {
            this.log.fine("New Registration");
            reg = new MRegistration(ctx, name, allowPublish, inProduction, startDate, null);
            Record_ID = 0;
        }
        reg.setDescription(description);
        reg.setRemote_Addr(request.getRemoteAddr());
        reg.setRemote_Host(request.getRemoteHost());
        if (user != null) {
            reg.setAD_User_ID(user.getAD_User_ID());
            reg.setC_BPartner_ID(user.getC_BPartner_ID());
        }
        if (reg.save()) {
            if (Record_ID == 0) {
                reg.loadAttributeValues(request);
            } else {
                reg.updateAttributeValues(request);
            }
            this.sendAnswer(response, String.valueOf(this.THANKS) + " Record_ID=" + reg.getA_Registration_ID());
        } else {
            this.log.log(Level.SEVERE, "Registration not saved");
            this.sendAnswer(response, String.valueOf(this.PROBLEM) + " Record_ID=0");
        }
        return true;
    }

    private void sendAnswer(HttpServletResponse response, String answer) throws IOException {
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.print(answer);
        out.flush();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        }
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        Properties ctx = JSPEnv.getCtx(request);
        WebUser wu = (WebUser)session.getAttribute("webUser");
        if (wu == null) {
            this.log.warning("No web user");
            response.sendRedirect("loginServlet?ForwardTo=registration.jsp");
            return;
        }
        int A_Registration_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)P_REGISTRATION_ID);
        MRegistration reg = null;
        if (A_Registration_ID > 0) {
            reg = new MRegistration(ctx, A_Registration_ID, null);
        }
        if (reg == null) {
            reg = new MRegistration(ctx, 0, null);
            A_Registration_ID = 0;
        }
        if ((name = WebUtil.getParameter((HttpServletRequest)request, (String)"Name")) == null || name.length() == 0) {
            WebUtil.createForwardPage((HttpServletResponse)response, (String)"Name is Mandatory", (String)"registrations.jsp", (int)4);
            return;
        }
        reg.setC_BPartner_ID(wu.getBpartnerID());
        reg.setName(name);
        String description = WebUtil.getParameter((HttpServletRequest)request, (String)"Description");
        if (description != null && description.length() > 0) {
            reg.setDescription(description);
        }
        boolean isInProduction = WebUtil.getParameterAsBoolean((HttpServletRequest)request, (String)"IsInProduction");
        reg.setIsInProduction(isInProduction);
        Timestamp assetServiceDate = WebUtil.getParameterAsDate((HttpServletRequest)request, (String)"AssetServiceDate");
        if (assetServiceDate == null) {
            assetServiceDate = new Timestamp(System.currentTimeMillis());
        }
        reg.setAssetServiceDate(assetServiceDate);
        boolean isAllowPublish = WebUtil.getParameterAsBoolean((HttpServletRequest)request, (String)"IsAllowPublish");
        reg.setIsAllowPublish(isAllowPublish);
        if (reg.save()) {
            if (A_Registration_ID == 0) {
                reg.loadAttributeValues(request);
            } else {
                reg.updateAttributeValues(request);
            }
            WebUtil.createForwardPage((HttpServletResponse)response, (String)this.THANKS, (String)"registrations.jsp", (int)3);
        } else {
            this.log.log(Level.SEVERE, "Registration not saved");
            WebUtil.createForwardPage((HttpServletResponse)response, (String)this.PROBLEM, (String)"registrations.jsp", (int)3);
        }
    }
}

