/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MProductCategory;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.wstore.PriceListProduct;

public class PriceList {
    private static CCache<String, PriceList> s_cache = new CCache("M_PriceList", "PriceList", 5, 60, true);
    public static int MAX_LINES = 50;
    public static final String NAME = "priceList";
    private CLogger log = CLogger.getCLogger(this.getClass());
    private String m_name = "Not found";
    private String m_description;
    private String m_currency;
    private String m_curSymbol;
    private String m_AD_Language;
    private boolean m_taxIncluded;
    private int m_PriceList_ID = 0;
    private int m_PriceList_Version_ID = 0;
    private String m_searchInfo = "";
    private boolean m_notAllPrices = false;
    private ArrayList<PriceListProduct> m_prices = new ArrayList();
    private Properties m_ctx;

    public static PriceList get(Properties ctx, int AD_Client_ID, int M_PriceList_ID, String searchString, String productCategory, boolean allRecords) {
        String search = searchString;
        if (search != null && (search.length() == 0 || search.equals("%"))) {
            search = null;
        }
        if (search != null) {
            if (!search.endsWith("%")) {
                search = String.valueOf(search) + "%";
            }
            if (!search.startsWith("%")) {
                search = "%" + search;
            }
            search = search.toUpperCase();
        }
        int M_Product_Category_ID = 0;
        try {
            if (productCategory != null && productCategory.length() > 0) {
                M_Product_Category_ID = Integer.parseInt(productCategory);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (M_Product_Category_ID < 0) {
            M_Product_Category_ID = 0;
        }
        String key = String.valueOf(String.valueOf(AD_Client_ID)) + "_" + M_PriceList_ID;
        PriceList retValue = null;
        if (search == null && M_Product_Category_ID == 0 && allRecords) {
            retValue = (PriceList)s_cache.get((Object)key);
        }
        if (retValue == null) {
            retValue = new PriceList(ctx, AD_Client_ID, M_PriceList_ID, search, M_Product_Category_ID, allRecords);
            if (search == null && M_Product_Category_ID == 0 && allRecords) {
                s_cache.put((Object)key, (Object)retValue);
            }
        }
        return retValue;
    }

    private PriceList(Properties ctx, int AD_Client_ID, int M_PriceList_ID, String searchString, int M_Product_Category_ID, boolean allRecords) {
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("AD_Client_ID=" + AD_Client_ID + ", M_PriceList_ID=" + M_PriceList_ID + ", Search=" + searchString + ",M_Product_Category_ID=" + M_Product_Category_ID + ", All=" + allRecords);
        }
        this.m_ctx = ctx;
        if (this.getM_PriceList_ID(AD_Client_ID, M_PriceList_ID) == 0 && this.getM_PriceList_ID(AD_Client_ID, 0) == 0) {
            return;
        }
        this.getM_PriceList_Version_ID(this.m_PriceList_ID, new Timestamp(System.currentTimeMillis()));
        this.loadProducts(searchString, M_Product_Category_ID, allRecords);
    }

    private int getM_PriceList_ID(int AD_Client_ID, int M_PriceList_ID) {
        block7: {
            String sql = "SELECT M_PriceList_ID, pl.Name, pl.Description, pl.IsTaxIncluded, c.ISO_Code, c.CurSymbol, cc.AD_Language  FROM M_PriceList pl INNER JOIN C_Currency c ON (pl.C_Currency_ID=c.C_Currency_ID) LEFT OUTER JOIN C_Country cc ON (c.C_Currency_ID=cc.C_Currency_ID) WHERE pl.IsActive='Y' AND pl.AD_Client_ID=?";
            sql = M_PriceList_ID != 0 ? String.valueOf(sql) + " AND pl.M_PriceList_ID=?" : String.valueOf(sql) + " ORDER BY pl.IsDefault DESC";
            this.m_PriceList_ID = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, AD_Client_ID);
                    if (M_PriceList_ID != 0) {
                        pstmt.setInt(2, M_PriceList_ID);
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        this.m_PriceList_ID = rs.getInt(1);
                        this.m_name = rs.getString(2);
                        this.m_description = rs.getString(3);
                        this.m_taxIncluded = "Y".equals(rs.getString(4));
                        this.m_currency = rs.getString(5);
                        this.m_curSymbol = rs.getString(6);
                        this.m_AD_Language = rs.getString(7);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "getM_PriceList_ID", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return this.m_PriceList_ID;
    }

    private int getM_PriceList_Version_ID(int M_PriceList_ID, Timestamp day) {
        block6: {
            String sql = "SELECT plv.M_PriceList_Version_ID, plv.Name, plv.Description, plv.ValidFrom FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=? AND plv.ValidFrom <=? ORDER BY plv.ValidFrom DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            this.m_PriceList_Version_ID = 0;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, M_PriceList_ID);
                    pstmt.setTimestamp(2, day);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_PriceList_Version_ID = rs.getInt(1);
                        this.m_name = rs.getString(2);
                        this.m_description = rs.getString(3);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "getM_PriceList_Version_ID", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return this.m_PriceList_Version_ID;
    }

    private void loadProducts(String searchString, int M_Product_Category_ID, boolean allRecords) {
        block16: {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("loadProducts - M_PriceList_Version_ID=" + this.m_PriceList_Version_ID + ", Search=" + searchString + ", M_Product_Category_ID=" + M_Product_Category_ID);
            }
            this.m_searchInfo = "";
            if (searchString != null) {
                this.m_searchInfo = searchString;
            }
            if (M_Product_Category_ID != 0) {
                if (this.m_searchInfo.length() != 0) {
                    this.m_searchInfo = String.valueOf(this.m_searchInfo) + " - ";
                }
                this.m_searchInfo = String.valueOf(this.m_searchInfo) + MProductCategory.get((Properties)this.m_ctx, (int)M_Product_Category_ID).getName();
            }
            this.m_prices.clear();
            this.m_notAllPrices = false;
            String sql = "SELECT p.M_Product_ID, p.Value, p.Name, p.Description, p.Help, p.DocumentNote, p.ImageURL, p.DescriptionURL, pp.PriceStd, uom.Name, uom.UOMSymbol FROM M_ProductPrice pp  INNER JOIN M_Product p ON (pp.M_Product_ID=p.M_Product_ID AND p.IsActive='Y' AND p.IsSold='Y') INNER JOIN C_UOM uom ON (p.C_UOM_ID=uom.C_UOM_ID) WHERE pp.M_PriceList_Version_ID=? AND pp.PriceStd > 0  AND p.IsSelfService='Y'";
            if (searchString != null) {
                sql = String.valueOf(sql) + " AND UPPER(p.Value||p.Name||p.Description) LIKE ? ";
            }
            if (M_Product_Category_ID != 0) {
                sql = String.valueOf(sql) + " AND p.M_Product_Category_ID=? ";
            }
            if (!allRecords && searchString == null && M_Product_Category_ID == 0) {
                sql = String.valueOf(sql) + " AND p.IsWebStoreFeatured='Y' ";
                this.m_notAllPrices = true;
            }
            sql = String.valueOf(sql) + "ORDER BY p.M_Product_Category_ID, p.Value";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    int index = 1;
                    pstmt.setInt(index++, this.m_PriceList_Version_ID);
                    if (searchString != null) {
                        pstmt.setString(index++, searchString);
                    }
                    if (M_Product_Category_ID != 0) {
                        pstmt.setInt(index++, M_Product_Category_ID);
                    }
                    rs = pstmt.executeQuery();
                    int no = 0;
                    while (rs.next()) {
                        this.m_prices.add(new PriceListProduct(rs.getInt(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7), rs.getString(8), rs.getBigDecimal(9), rs.getString(10), rs.getString(11)));
                        if (allRecords || ++no <= MAX_LINES) continue;
                        this.m_notAllPrices = true;
                        break;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "load", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block16;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("load #" + this.m_prices.size() + ", Search=" + this.m_searchInfo);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PriceList[");
        sb.append(this.m_prices.size()).append("]");
        return sb.toString();
    }

    public int getPriceCount() {
        return this.m_prices.size();
    }

    public boolean isNoLines() {
        return this.getPriceCount() == 0;
    }

    public boolean isNotAllPrices() {
        return this.m_notAllPrices;
    }

    public ArrayList<PriceListProduct> getPrices() {
        return this.m_prices;
    }

    public PriceListProduct getPriceListProduct(int M_Product_ID) {
        int i = 0;
        while (i < this.m_prices.size()) {
            PriceListProduct plp = this.m_prices.get(i);
            if (plp.getId() == M_Product_ID) {
                return plp;
            }
            ++i;
        }
        return null;
    }

    public String getSearchInfo() {
        return this.m_searchInfo;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getCurrency() {
        return this.m_currency;
    }

    public String getCurSymbol() {
        return this.m_curSymbol;
    }

    public String getAD_Language() {
        return this.m_AD_Language;
    }

    public boolean isTaxIncluded() {
        return this.m_taxIncluded;
    }

    public int getPriceList_ID() {
        return this.m_PriceList_ID;
    }

    public int getPriceList_Version_ID() {
        return this.m_PriceList_Version_ID;
    }
}

