/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.util.Properties;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.util.Env;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;

public class JSPEnv {
    private static final String COOKIE_NAME = "AdempiereWebUser";

    public static Properties getCtx(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get((HttpServletRequest)request);
        HttpSession session = request.getSession(true);
        WebUser wu = WebUser.get((HttpServletRequest)request);
        if (wu != null) {
            int AD_User_ID = wu.getAD_User_ID();
            Env.setContext((Properties)wsc.ctx, (String)"#AD_User_ID", (int)AD_User_ID);
        }
        session.setMaxInactiveInterval(1800);
        String info = (String)wsc.ctx.get("hdrInfo");
        if (info != null) {
            session.setAttribute("hdrInfo", (Object)info);
        }
        return wsc.ctx;
    }

    public static String getCookieWebUser(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        int i = 0;
        while (i < cookies.length) {
            if (COOKIE_NAME.equals(cookies[i].getName())) {
                return cookies[i].getValue();
            }
            ++i;
        }
        return null;
    }

    public static void addCookieWebUser(HttpServletRequest request, HttpServletResponse response, String webUser) {
        Cookie cookie = new Cookie(COOKIE_NAME, webUser);
        cookie.setComment("Adempiere Web User");
        cookie.setPath(request.getContextPath());
        cookie.setMaxAge(2592000);
        response.addCookie(cookie);
    }

    public static void deleteCookieWebUser(HttpServletRequest request, HttpServletResponse response) {
        WebUtil.deleteCookieWebUser((HttpServletRequest)request, (HttpServletResponse)response, (String)COOKIE_NAME);
    }

    public static String getFrom(HttpServletRequest request) {
        return WebUtil.getFrom((HttpServletRequest)request);
    }

    public static String sendEMail(HttpServletRequest request, WebUser to, String msgType, Object[] parameter) {
        return WebUtil.sendEMail((HttpServletRequest)request, (WebUser)to, (String)msgType, (Object[])parameter);
    }
}

