/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetDelivery;
import org.compiere.model.MProductDownload;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.WebEnv;
import org.compiere.util.WebInfo;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;

public class AssetServlet
extends HttpServlet {
    private static final long serialVersionUID = 8335032857740563624L;
    private static CLogger log = CLogger.getCLogger(AssetServlet.class);
    public static final String NAME = "assetServlet";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb((ServletConfig)config)) {
            throw new ServletException("AssetServlet.init");
        }
    }

    public String getServletInfo() {
        return "Adempiere Web Assets Servlet";
    }

    public void destroy() {
        log.fine("");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isLoggable(Level.INFO)) {
            log.info("Get from " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        }
        Properties ctx = JSPEnv.getCtx(request);
        HttpSession session = request.getSession(false);
        String url = "/assets.jsp";
        if (session == null || session.getAttribute("info") == null || session.getAttribute("webUser") == null) {
            url = "/login.jsp";
        } else {
            session.removeAttribute("hdrMessage");
            WebInfo info = (WebInfo)session.getAttribute("info");
            if (info != null) {
                info.setMessage("");
            }
            String msg = this.streamAsset(request, response);
            if (info != null) {
                info.setMessage(Msg.parseTranslation((Properties)ctx, (String)msg));
            }
            if (msg == null || msg.length() == 0 || msg.startsWith("**")) {
                return;
            }
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Forward to " + url);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected String streamAsset(HttpServletRequest request, HttpServletResponse response) {
        String ser;
        MProductDownload[] pdls;
        int A_Asset_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"Asset_ID");
        if (A_Asset_ID == 0) {
            log.fine("No ID)");
            return "No Asset ID";
        }
        byte[] assetInfo = String.valueOf(A_Asset_ID).getBytes();
        Properties ctx = JSPEnv.getCtx(request);
        HttpSession session = request.getSession(true);
        WebEnv.dump((HttpServletRequest)request);
        MAsset asset = new MAsset(ctx, A_Asset_ID, null);
        if (asset.getA_Asset_ID() != A_Asset_ID) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Asset not found - ID=" + A_Asset_ID);
            }
            return "Asset not found";
        }
        WebUser wu = (WebUser)session.getAttribute("webUser");
        if (wu.getC_BPartner_ID() != asset.getC_BPartner_ID()) {
            log.warning("A_Asset_ID=" + A_Asset_ID + " - BP_Invoice=" + asset.getC_BPartner_ID() + " <> BP_User=" + wu.getC_BPartner_ID());
            return "Your asset not found";
        }
        if (!asset.isDownloadable() || wu.isCreditStopHold() || !wu.isEMailVerified()) {
            return "Asset not downloadable";
        }
        String pd = WebUtil.getParameter((HttpServletRequest)request, (String)"PD");
        String dl_name = null;
        String dl_url = null;
        InputStream in = null;
        int M_ProductDownload_ID = 0;
        if (pd != null && pd.length() > 0 && (pdls = asset.getProductDownloads()) != null) {
            int i = 0;
            while (i < pdls.length) {
                if (pdls[i].getDownloadURL().indexOf(pd) != -1) {
                    M_ProductDownload_ID = pdls[i].getM_ProductDownload_ID();
                    dl_name = pd;
                    dl_url = pdls[i].getDownloadURL();
                    in = pdls[i].getDownloadStream(ctx.getProperty("documentDir"));
                    break;
                }
                ++i;
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(dl_name) + " - " + dl_url);
        }
        if (dl_name == null || dl_url == null || in == null) {
            return "@NotFound@ @A_Asset_ID@: " + pd;
        }
        String lot = asset.getLot();
        if (lot == null || lot.length() == 0) {
            lot = ".";
        }
        if ((ser = asset.getSerNo()) == null || ser.length() == 0) {
            ser = ".";
        }
        Object[] args = new Object[]{dl_name, String.valueOf(wu.getName()) + " - " + wu.getEmail(), asset.getVersionNo(), lot, ser, asset.getGuaranteeDate()};
        String readme = Msg.getMsg((Properties)ctx, (String)"AssetDeliveryTemplate", (Object[])args);
        MAssetDelivery ad = asset.confirmDelivery(request, wu.getAD_User_ID());
        if (M_ProductDownload_ID != 0) {
            ad.setM_ProductDownload_ID(M_ProductDownload_ID);
        }
        ad.setDescription(dl_name);
        float speed = 0.0f;
        try {
            response.setContentType("application/zip");
            response.setHeader("Content-Location", "asset.zip");
            int bufferSize = 2048;
            response.setBufferSize(bufferSize);
            if (log.isLoggable(Level.FINE)) {
                log.fine(in + ", available=" + in.available());
            }
            long time = System.currentTimeMillis();
            ServletOutputStream out = response.getOutputStream();
            ZipOutputStream zip = new ZipOutputStream((OutputStream)out);
            zip.setMethod(8);
            zip.setLevel(9);
            zip.setComment(readme);
            ZipEntry entry = new ZipEntry("readme.txt");
            entry.setExtra(assetInfo);
            zip.putNextEntry(entry);
            zip.write(readme.getBytes(), 0, readme.length());
            zip.closeEntry();
            entry = new ZipEntry(dl_name);
            entry.setExtra(assetInfo);
            zip.putNextEntry(entry);
            byte[] buffer = new byte[bufferSize];
            int count = 0;
            int totalSize = 0;
            do {
                if ((count = in.read(buffer, 0, bufferSize)) <= 0) continue;
                totalSize += count;
                zip.write(buffer, 0, count);
            } while (count != -1);
            zip.closeEntry();
            zip.finish();
            zip.close();
            in.close();
            time = System.currentTimeMillis() - time;
            speed = (float)totalSize / 1024.0f / ((float)time / 1000.0f);
            String msg = String.valueOf(totalSize / 1024) + "kB - " + time + " ms - " + speed + " kB/sec";
            log.fine(msg);
            ad.setDeliveryConfirmation(msg);
            ad.saveEx();
            asset.saveEx();
        }
        catch (IOException ex) {
            String msg = ex.getMessage();
            if (msg == null || msg.length() == 0) {
                msg = ex.toString();
            }
            log.warning(msg);
            try {
                if (msg.length() > 120) {
                    msg = msg.substring(0, 119);
                }
                ad.setDeliveryConfirmation(msg);
                ad.save();
            }
            catch (Exception ex1) {
                log.log(Level.SEVERE, "2 - " + ex);
            }
            return "** Streaming error; Please Retry";
        }
        return null;
    }
}

