/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackIn;
import org.adempiere.pipo2.ReferenceUtils;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class PoFiller {
    PO po = null;
    private AbstractElementHandler handler;
    private PIPOContext ctx;
    private Element element;

    public PoFiller(PIPOContext ctx, PO po, Element element, AbstractElementHandler handler) {
        this.ctx = ctx;
        this.po = po;
        this.element = element;
        this.handler = handler;
    }

    public void setString(String columnName) {
        Element e = this.element.properties.get(columnName);
        String value = e != null ? e.contents.toString() : null;
        value = "".equals(value) ? null : value;
        Object oldValue = this.po.get_Value(columnName);
        if (value == null && oldValue == null) {
            return;
        }
        if (oldValue != null && oldValue.toString().equals(value)) {
            return;
        }
        this.po.set_ValueNoCheck(columnName, (Object)value);
    }

    public void setBoolean(String columnName) {
        boolean bool;
        Element e = this.element.properties.get(columnName);
        String value = e != null ? e.contents.toString() : null;
        boolean bl = bool = "true".equals(value);
        if (this.po.get_Value(columnName) != null && this.po.get_ValueAsBoolean(columnName) == bool) {
            return;
        }
        this.po.set_ValueNoCheck(columnName, (Object)bool);
    }

    public void setTimestamp(String qName) {
        String value;
        Element e = this.element.properties.get(qName);
        String string = value = e != null ? e.contents.toString() : null;
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        Timestamp ts = value != null ? Timestamp.valueOf(value) : null;
        Object oldValue = this.po.get_Value(qName);
        if (oldValue == null && ts == null) {
            return;
        }
        if (oldValue != null && oldValue.equals(ts)) {
            return;
        }
        this.po.set_ValueNoCheck(qName, (Object)ts);
    }

    public void setInteger(String qName) {
        String value;
        Element e = this.element.properties.get(qName);
        String string = value = e != null ? e.contents.toString() : null;
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        Integer i = value != null ? new Integer(value) : null;
        Object oldValue = this.po.get_Value(qName);
        if (oldValue == null && i == null) {
            return;
        }
        if (oldValue != null && oldValue.equals(i)) {
            return;
        }
        this.po.set_ValueNoCheck(qName, (Object)i);
    }

    public void setBigDecimal(String qName) {
        String value;
        Element e = this.element.properties.get(qName);
        String string = value = e != null ? e.contents.toString() : null;
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        BigDecimal bd = value != null ? new BigDecimal(value) : null;
        Object oldValue = this.po.get_Value(qName);
        if (oldValue == null && bd == null) {
            return;
        }
        if (oldValue != null && oldValue.equals(bd)) {
            return;
        }
        this.po.set_ValueNoCheck(qName, (Object)bd);
    }

    public static int findTableReference(PIPOContext ctx, AbstractElementHandler handler, Element element, String qName) {
        Element propertyElement = element.properties.get(qName);
        if (propertyElement == null) {
            return 0;
        }
        int id = 0;
        String value = propertyElement.contents.toString();
        if (value != null && value.trim().length() > 0) {
            String[] names = qName.split("[.]");
            if (names.length < 2) {
                return 0;
            }
            String columnName = names[0];
            if (names.length != 3) {
                columnName = String.valueOf(columnName) + "_ID";
            }
            String tableName = names.length == 3 ? names[1] : names[0];
            String searchColumn = names.length == 3 ? names[2] : names[1];
            id = handler.findIdByColumn(ctx, tableName, searchColumn, value.trim());
        }
        return id;
    }

    public int setTableReference(String qName) {
        Element e = this.element.properties.get(qName);
        if (e == null) {
            return 0;
        }
        String value = e.contents.toString();
        String columnName = qName;
        if (value != null && value.trim().length() > 0) {
            int id = ReferenceUtils.resolveReference(this.ctx.ctx, e, this.po.get_TrxName());
            if (columnName.equals("AD_Client_ID") && id > 0 && id != Env.getAD_Client_ID((Properties)this.ctx.ctx)) {
                return -1;
            }
            if (this.po.get_ColumnIndex(columnName) >= 0) {
                if (id > 0) {
                    if (this.po.get_ValueAsInt(columnName) != id) {
                        this.po.set_ValueNoCheck(columnName, (Object)id);
                    }
                    return id;
                }
                return -1;
            }
            return 0;
        }
        return 0;
    }

    public List<String> autoFill(List<String> excludes) {
        String sAD_Client_ID;
        POInfo info = POInfo.getPOInfo((Properties)this.po.getCtx(), (int)this.po.get_Table_ID());
        ArrayList<String> notFounds = new ArrayList<String>();
        Element clientElement = this.element.properties.get("AD_Client_ID");
        String string = sAD_Client_ID = clientElement != null ? clientElement.contents.toString() : null;
        if (sAD_Client_ID != null && sAD_Client_ID.equals("0")) {
            this.po.set_ValueNoCheck("AD_Client_ID", (Object)0);
            this.po.setAD_Org_ID(0);
        } else {
            String sAD_Org_ID;
            Element orgElement = this.element.properties.get("AD_Org_ID");
            String string2 = sAD_Org_ID = orgElement != null ? orgElement.contents.toString() : null;
            if (sAD_Org_ID != null && sAD_Org_ID.equals("0")) {
                this.po.setAD_Org_ID(0);
            } else if (sAD_Org_ID != null && sAD_Org_ID.equals("@AD_Org_ID@")) {
                this.po.setAD_Org_ID(Env.getAD_Org_ID((Properties)this.ctx.ctx));
            } else if (this.setTableReference("AD_Client_ID") >= 0) {
                this.setTableReference("AD_Org_ID");
            }
        }
        for (String qName : this.element.properties.keySet()) {
            Element e;
            if (excludes != null) {
                boolean exclude = false;
                for (String ex : excludes) {
                    if (!ex.equalsIgnoreCase(qName)) continue;
                    exclude = true;
                    break;
                }
                if (exclude) continue;
            }
            if (ReferenceUtils.isTableLookup(e = this.element.properties.get(qName)) || ReferenceUtils.isUUIDLookup(e)) {
                int id = this.setTableReference(qName);
                if (id >= 0) continue;
                notFounds.add(qName);
                continue;
            }
            int index = info.getColumnIndex(qName);
            if (index < 0) continue;
            if (info.getColumnClass(index) == Boolean.class) {
                this.setBoolean(qName);
                continue;
            }
            if (info.getColumnClass(index) == BigDecimal.class) {
                this.setBigDecimal(qName);
                continue;
            }
            if (info.getColumnClass(index) == Integer.class) {
                this.setInteger(qName);
                continue;
            }
            if (info.getColumnClass(index) == Timestamp.class) {
                this.setTimestamp(qName);
                continue;
            }
            if (DisplayType.isLOB((int)info.getColumnDisplayType(index))) {
                this.setBlob(qName);
                continue;
            }
            this.setString(qName);
        }
        return notFounds;
    }

    private void setBlob(String qName) {
        String[] component;
        Element pe = this.element.properties.get(qName);
        String value = pe != null ? pe.contents.toString() : null;
        Object data = null;
        if (value != null && value.trim().length() > 0 && (component = value.split("[|]")).length == 2) {
            String fileName = component[0];
            String dataType = component[1];
            PackIn packIn = this.ctx.packIn;
            try {
                byte[] bytes = packIn.readBlob(fileName);
                data = "byte[]".equals(dataType) ? bytes : (Object)new String(bytes, "UTF-8");
            }
            catch (IOException e) {
                throw new AdempiereException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        this.po.set_ValueNoCheck(qName, data);
    }
}

