/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.List;
import org.restlet.engine.util.SystemUtils;
import org.restlet.util.NamedValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CacheDirective
implements NamedValue<String> {
    private boolean digit;
    private volatile String name;
    private volatile String value;

    public static CacheDirective maxAge(int maxAge) {
        return new CacheDirective("max-age", Integer.toString(maxAge), true);
    }

    public static CacheDirective maxStale() {
        return new CacheDirective("max-stale");
    }

    public static CacheDirective maxStale(int maxStale) {
        return new CacheDirective("max-stale", Integer.toString(maxStale), true);
    }

    public static CacheDirective minFresh(int minFresh) {
        return new CacheDirective("min-fresh", Integer.toString(minFresh), true);
    }

    public static CacheDirective mustRevalidate() {
        return new CacheDirective("must-revalidate");
    }

    public static CacheDirective noCache() {
        return new CacheDirective("no-cache");
    }

    public static CacheDirective noCache(List<String> fieldNames) {
        StringBuilder sb = new StringBuilder();
        if (fieldNames != null) {
            for (int i = 0; i < fieldNames.size(); ++i) {
                sb.append("\"" + fieldNames.get(i) + "\"");
                if (i >= fieldNames.size() - 1) continue;
                sb.append(',');
            }
        }
        return new CacheDirective("no-cache", sb.toString());
    }

    public static CacheDirective noCache(String fieldName) {
        return new CacheDirective("no-cache", "\"" + fieldName + "\"");
    }

    public static CacheDirective noStore() {
        return new CacheDirective("no-store");
    }

    public static CacheDirective noTransform() {
        return new CacheDirective("no-transform");
    }

    public static CacheDirective onlyIfCached() {
        return new CacheDirective("only-if-cached");
    }

    public static CacheDirective privateInfo() {
        return new CacheDirective("private");
    }

    public static CacheDirective privateInfo(List<String> fieldNames) {
        StringBuilder sb = new StringBuilder();
        if (fieldNames != null) {
            for (int i = 0; i < fieldNames.size(); ++i) {
                sb.append("\"" + fieldNames.get(i) + "\"");
                if (i >= fieldNames.size() - 1) continue;
                sb.append(',');
            }
        }
        return new CacheDirective("private", sb.toString());
    }

    public static CacheDirective privateInfo(String fieldName) {
        return new CacheDirective("private", "\"" + fieldName + "\"");
    }

    public static CacheDirective proxyMustRevalidate() {
        return new CacheDirective("proxy-revalidate");
    }

    public static CacheDirective publicInfo() {
        return new CacheDirective("public");
    }

    public static CacheDirective sharedMaxAge(int sharedMaxAge) {
        return new CacheDirective("s-maxage", Integer.toString(sharedMaxAge), true);
    }

    public CacheDirective(String name) {
        this(name, null);
    }

    public CacheDirective(String name, String value) {
        this(name, value, false);
    }

    public CacheDirective(String name, String value, boolean digit) {
        this.name = name;
        this.value = value;
        this.digit = digit;
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && (result = obj instanceof CacheDirective)) {
            CacheDirective that = (CacheDirective)obj;
            boolean bl2 = result = that.getName() == null && this.getName() == null || this.getName() != null && this.getName().equals(that.getName());
            if (result) {
                boolean bl3 = result = that.getValue() == null && this.getValue() == null || this.getValue() != null && this.getValue().equals(that.getValue());
                if (result) {
                    result = this.digit == that.digit;
                }
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return SystemUtils.hashCode(this.getName(), this.getValue(), this.isDigit());
    }

    public boolean isDigit() {
        return this.digit;
    }

    public void setDigit(boolean digit) {
        this.digit = digit;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "CacheDirective [digit=" + this.digit + ", name=" + this.name + ", value=" + this.value + "]";
    }
}

