/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.util.CollectionsX;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.XMLResourcesLocator;
import org.zkoss.zk.library.Activator;

public class ClassLocator
implements XMLResourcesLocator {
    private static final Log log = Log.lookup(ClassLocator.class);

    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> en;
        ClassLoader cl;
        Enumeration<URL> en2;
        ArrayList<URL> list = null;
        name = ClassLocator.resolveName(name);
        if (Activator.getContext() != null && (en2 = Activator.getContext().getBundle().getResources(name)) != null && en2.hasMoreElements()) {
            list = Collections.list(en2);
        }
        if (list == null && (cl = Thread.currentThread().getContextClassLoader()) != null && (en = cl.getResources(name)).hasMoreElements()) {
            list = Collections.list(en);
        }
        if (list == null && (cl = ClassLocator.class.getClassLoader()) != null && (en = cl.getResources(name)).hasMoreElements()) {
            list = Collections.list(en);
        }
        if (list == null) {
            en2 = ClassLoader.getSystemResources(name);
            list = Collections.list(en2);
        }
        return Collections.enumeration(list);
    }

    public List<XMLResourcesLocator.Resource> getDependentXMLResources(String name, String elName, String elDepends) throws IOException {
        LinkedHashMap<String, XMLResource> rcmap = new LinkedHashMap<String, XMLResource>();
        Enumeration<URL> en = this.getResources(name);
        while (en.hasMoreElements()) {
            URL url = en.nextElement();
            XMLResource xr = new XMLResource(url, elName, elDepends);
            XMLResource old = rcmap.put(xr.name, xr);
            if (old == null) continue;
            log.warning("Replicate resource: " + xr.name + "\nOverwrite " + old.url + "\nwith " + xr.url);
        }
        LinkedList<XMLResourcesLocator.Resource> rcs = new LinkedList<XMLResourcesLocator.Resource>();
        LinkedHashSet<String> resolving = new LinkedHashSet<String>();
        while (!rcmap.isEmpty()) {
            Iterator it = rcmap.values().iterator();
            XMLResource xr = (XMLResource)it.next();
            it.remove();
            ClassLocator.resolveDependency(xr, rcs, rcmap, resolving);
            assert (resolving.isEmpty());
        }
        return rcs;
    }

    private static void resolveDependency(XMLResource xr, List<XMLResourcesLocator.Resource> rcs, Map<String, XMLResource> rcmap, Set<String> resolving) {
        if (!resolving.add(xr.name)) {
            throw new IllegalStateException("Recusrive reference among " + resolving);
        }
        for (String nm : xr.depends) {
            XMLResource dep = rcmap.remove(nm);
            if (dep == null) continue;
            ClassLocator.resolveDependency(dep, rcs, rcmap, resolving);
        }
        rcs.add(new XMLResourcesLocator.Resource(xr.url, xr.document));
        resolving.remove(xr.name);
        if (log.debugable()) {
            log.debug("Adding resolved resource: " + xr.name);
        }
    }

    public String getDirectory() {
        return null;
    }

    public URL getResource(String name) {
        URL url;
        if (Activator.getContext() != null && (url = Activator.getContext().getBundle().getResource(name)) != null) {
            return url;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url2 = cl != null ? cl.getResource(ClassLocator.resolveName(name)) : null;
        return url2 != null ? url2 : ClassLocator.class.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl != null ? cl.getResourceAsStream(ClassLocator.resolveName(name)) : null;
        return is != null ? is : ClassLocator.class.getResourceAsStream(name);
    }

    private static String resolveName(String name) {
        return name != null && name.startsWith("/") ? name.substring(1) : name;
    }

    public int hashCode() {
        return 1123;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof ClassLocator;
    }

    private static class XMLResource {
        private final String name;
        private final URL url;
        private final Document document;
        private final List<String> depends;

        private XMLResource(URL url, String elName, String elDepends) throws IOException {
            if (log.debugable()) {
                log.debug("Loading " + url);
            }
            try {
                this.document = new SAXBuilder(false, false, true).build(url);
            }
            catch (Exception ex) {
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                IOException ioex = new IOException("Unable to load " + url);
                ioex.initCause(ex);
                throw ioex;
            }
            this.url = url;
            Element root = this.document.getRootElement();
            this.name = IDOMs.getRequiredElementValue((Element)root, (String)elName);
            String deps = root.getElementValue(elDepends, true);
            if (deps == null || deps.length() == 0) {
                this.depends = Collections.emptyList();
            } else {
                this.depends = new LinkedList<String>();
                CollectionsX.parse(this.depends, (String)deps, (char)',');
                if (log.finerable()) {
                    log.finer(String.valueOf(this.name) + " depends on " + this.depends);
                }
            }
        }

        public String toString() {
            return "[" + this.name + ": " + this.url + " depends on " + this.depends + ']';
        }
    }
}

