/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.model.GridTabWrapper;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.I_M_Requisition;
import org.compiere.model.I_M_RequisitionLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.util.Env;

public class CalloutRequisition
extends CalloutEngine {
    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        I_M_Requisition req = (I_M_Requisition)GridTabWrapper.create((GridTab)mTab, I_M_Requisition.class);
        I_M_RequisitionLine line = (I_M_RequisitionLine)GridTabWrapper.create((GridTab)mTab, I_M_RequisitionLine.class);
        this.setPrice(ctx, WindowNo, req, line);
        MProduct product = MProduct.get((Properties)ctx, (int)M_Product_ID);
        line.setC_UOM_ID(product.getC_UOM_ID());
        return "";
    }

    public String amt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal LineNetAmt;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        I_M_Requisition req = (I_M_Requisition)GridTabWrapper.create((GridTab)mTab, I_M_Requisition.class);
        I_M_RequisitionLine line = (I_M_RequisitionLine)GridTabWrapper.create((GridTab)mTab, I_M_RequisitionLine.class);
        if (mField.getColumnName().equals("Qty") && "Y".equals(Env.getContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema"))) {
            this.setPrice(ctx, WindowNo, req, line);
        }
        int StdPrecision = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"StdPrecision");
        BigDecimal Qty = line.getQty();
        BigDecimal PriceActual = line.getPriceActual();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("amt - Qty=" + Qty + ", Price=" + PriceActual + ", Precision=" + StdPrecision);
        }
        if ((LineNetAmt = Qty.multiply(PriceActual)).scale() > StdPrecision) {
            LineNetAmt = LineNetAmt.setScale(StdPrecision, 4);
        }
        line.setLineNetAmt(LineNetAmt);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("amt - LineNetAmt=" + LineNetAmt);
        }
        return "";
    }

    private void setPrice(Properties ctx, int WindowNo, I_M_Requisition req, I_M_RequisitionLine line) {
        int C_BPartner_ID = line.getC_BPartner_ID();
        BigDecimal Qty = line.getQty();
        boolean isSOTrx = false;
        MProductPricing pp = new MProductPricing(line.getM_Product_ID(), C_BPartner_ID, Qty, isSOTrx);
        int M_PriceList_ID = req.getM_PriceList_ID();
        pp.setM_PriceList_ID(M_PriceList_ID);
        int M_PriceList_Version_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID");
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        Timestamp orderDate = req.getDateRequired();
        pp.setPriceDate(orderDate);
        line.setPriceActual(pp.getPriceStd());
        Env.setContext((Properties)ctx, (int)WindowNo, (String)"EnforcePriceLimit", (String)(pp.isEnforcePriceLimit() ? "Y" : "N"));
        Env.setContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema", (String)(pp.isDiscountSchema() ? "Y" : "N"));
    }
}

