/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.MClient;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MUserRoles;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.server.AdempiereServer;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFProcess;
import org.compiere.wf.MWFResponsible;
import org.compiere.wf.MWorkflowProcessor;
import org.compiere.wf.MWorkflowProcessorLog;

public class WorkflowProcessor
extends AdempiereServer {
    private MWorkflowProcessor m_model = null;
    private StringBuffer m_summary = new StringBuffer();
    private MClient m_client = null;

    public WorkflowProcessor(MWorkflowProcessor model) {
        super((AdempiereProcessor)model, 30);
        this.m_model = model;
        this.m_client = MClient.get((Properties)model.getCtx(), (int)model.getAD_Client_ID());
    }

    @Override
    protected void doWork() {
        this.m_summary = new StringBuffer();
        this.wakeup();
        this.dynamicPriority();
        this.sendAlerts();
        int no = this.m_model.deleteLog();
        this.m_summary.append("Logs deleted=").append(no);
        MWorkflowProcessorLog pLog = new MWorkflowProcessorLog(this.m_model, this.m_summary.toString());
        pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed((Timestamp)new Timestamp(this.p_startWork)));
        pLog.saveEx();
    }

    private void wakeup() {
        int count;
        block6: {
            String sql = "SELECT * FROM AD_WF_Activity a WHERE Processed='N' AND WFState='OS' AND EndWaitTime <= SysDate AND AD_Client_ID=? AND EXISTS (SELECT * FROM AD_Workflow wf  INNER JOIN AD_WF_Node wfn ON (wf.AD_Workflow_ID=wfn.AD_Workflow_ID) WHERE a.AD_WF_Node_ID=wfn.AD_WF_Node_ID AND wfn.Action='Z' AND (wf.AD_WorkflowProcessor_ID IS NULL OR wf.AD_WorkflowProcessor_ID=?))";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            count = 0;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_model.getAD_Client_ID());
                    pstmt.setInt(2, this.m_model.getAD_WorkflowProcessor_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MWFActivity activity = new MWFActivity(this.getCtx(), rs, null);
                        activity.setWFState("CC");
                        ++count;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "wakeup", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_summary.append("Wakeup #").append(count).append(" - ");
    }

    private void dynamicPriority() {
        int count;
        block7: {
            String sql = "SELECT * FROM AD_WF_Activity a WHERE Processed='N' AND WFState='OS' AND EXISTS (SELECT * FROM AD_Workflow wf INNER JOIN AD_WF_Node wfn ON (wf.AD_Workflow_ID=wfn.AD_Workflow_ID) WHERE a.AD_WF_Node_ID=wfn.AD_WF_Node_ID AND wf.AD_WorkflowProcessor_ID=? AND wfn.DynPriorityUnit IS NOT NULL AND wfn.DynPriorityChange IS NOT NULL)";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            count = 0;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_model.getAD_WorkflowProcessor_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MWFActivity activity = new MWFActivity(this.getCtx(), rs, null);
                        if (activity.getDynPriorityStart() == 0) {
                            activity.setDynPriorityStart(activity.getPriority());
                        }
                        long ms = System.currentTimeMillis() - activity.getCreated().getTime();
                        MWFNode node = activity.getNode();
                        int prioDiff = node.calculateDynamicPriority((int)(ms / 1000L));
                        activity.setPriority(activity.getDynPriorityStart() + prioDiff);
                        activity.saveEx();
                        ++count;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_summary.append("DynPriority #").append(count).append(" - ");
    }

    private void sendAlerts() {
        int countEMails;
        int count;
        ResultSet rs;
        CPreparedStatement pstmt;
        boolean escalate;
        MWFActivity activity;
        String sql;
        block26: {
            if (this.m_model.getAlertOverPriority() > 0) {
                int countEMails2;
                int count2;
                block24: {
                    sql = "SELECT * FROM AD_WF_Activity a WHERE Processed='N' AND WFState='OS' AND Priority >= ? AND (DateLastAlert IS NULL";
                    if (this.m_model.getRemindDays() > 0) {
                        sql = String.valueOf(sql) + " OR (DateLastAlert+" + this.m_model.getRemindDays() + ") < SysDate";
                    }
                    sql = String.valueOf(sql) + ") AND EXISTS (SELECT * FROM AD_Workflow wf  INNER JOIN AD_WF_Node wfn ON (wf.AD_Workflow_ID=wfn.AD_Workflow_ID) WHERE a.AD_WF_Node_ID=wfn.AD_WF_Node_ID AND (wf.AD_WorkflowProcessor_ID IS NULL OR wf.AD_WorkflowProcessor_ID=?))";
                    count2 = 0;
                    countEMails2 = 0;
                    CPreparedStatement pstmt2 = null;
                    ResultSet rs2 = null;
                    try {
                        try {
                            pstmt2 = DB.prepareStatement((String)sql, null);
                            pstmt2.setInt(1, this.m_model.getAlertOverPriority());
                            pstmt2.setInt(2, this.m_model.getAD_WorkflowProcessor_ID());
                            rs2 = pstmt2.executeQuery();
                            while (rs2.next()) {
                                activity = new MWFActivity(this.getCtx(), rs2, null);
                                escalate = activity.getDateLastAlert() != null;
                                countEMails2 += this.sendEmail(activity, "ActivityOverPriority", escalate, true);
                                activity.setDateLastAlert(new Timestamp(System.currentTimeMillis()));
                                activity.saveEx();
                                ++count2;
                            }
                        }
                        catch (SQLException e) {
                            this.log.log(Level.SEVERE, "(Priority) - " + sql, (Throwable)e);
                            DB.close(rs2, (Statement)pstmt2);
                            rs2 = null;
                            pstmt2 = null;
                            break block24;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs2, (Statement)pstmt2);
                        rs2 = null;
                        pstmt2 = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs2, (Statement)pstmt2);
                    rs2 = null;
                    pstmt2 = null;
                }
                this.m_summary.append("OverPriority #").append(count2);
                if (countEMails2 > 0) {
                    this.m_summary.append(" (").append(countEMails2).append(" EMail)");
                }
                this.m_summary.append(" - ");
            }
            sql = "SELECT * FROM AD_WF_Activity a WHERE Processed='N' AND WFState='OS' AND EndWaitTime > SysDate AND (DateLastAlert IS NULL";
            if (this.m_model.getRemindDays() > 0) {
                sql = String.valueOf(sql) + " OR (DateLastAlert+" + this.m_model.getRemindDays() + ") < SysDate";
            }
            sql = String.valueOf(sql) + ") AND EXISTS (SELECT * FROM AD_Workflow wf  INNER JOIN AD_WF_Node wfn ON (wf.AD_Workflow_ID=wfn.AD_Workflow_ID) WHERE a.AD_WF_Node_ID=wfn.AD_WF_Node_ID AND wfn.Action<>'Z' AND (wf.AD_WorkflowProcessor_ID IS NULL OR wf.AD_WorkflowProcessor_ID=?))";
            pstmt = null;
            rs = null;
            count = 0;
            countEMails = 0;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_model.getAD_WorkflowProcessor_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        activity = new MWFActivity(this.getCtx(), rs, null);
                        escalate = activity.getDateLastAlert() != null;
                        countEMails += this.sendEmail(activity, "ActivityEndWaitTime", escalate, false);
                        activity.setDateLastAlert(new Timestamp(System.currentTimeMillis()));
                        activity.saveEx();
                        ++count;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "(EndWaitTime) - " + sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block26;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_summary.append("EndWaitTime #").append(count);
        if (countEMails > 0) {
            this.m_summary.append(" (").append(countEMails).append(" EMail)");
        }
        this.m_summary.append(" - ");
        if (this.m_model.getInactivityAlertDays() > 0) {
            block28: {
                sql = "SELECT * FROM AD_WF_Activity a WHERE Processed='N' AND WFState='OS' AND (Updated+" + this.m_model.getInactivityAlertDays() + ") < SysDate" + " AND (DateLastAlert IS NULL";
                if (this.m_model.getRemindDays() > 0) {
                    sql = String.valueOf(sql) + " OR (DateLastAlert+" + this.m_model.getRemindDays() + ") < SysDate";
                }
                sql = String.valueOf(sql) + ") AND EXISTS (SELECT * FROM AD_Workflow wf  INNER JOIN AD_WF_Node wfn ON (wf.AD_Workflow_ID=wfn.AD_Workflow_ID) WHERE a.AD_WF_Node_ID=wfn.AD_WF_Node_ID AND (wf.AD_WorkflowProcessor_ID IS NULL OR wf.AD_WorkflowProcessor_ID=?))";
                count = 0;
                countEMails = 0;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, null);
                        pstmt.setInt(1, this.m_model.getAD_WorkflowProcessor_ID());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            activity = new MWFActivity(this.getCtx(), rs, null);
                            escalate = activity.getDateLastAlert() != null;
                            countEMails += this.sendEmail(activity, "ActivityInactivity", escalate, false);
                            activity.setDateLastAlert(new Timestamp(System.currentTimeMillis()));
                            activity.saveEx();
                            ++count;
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, "(Inactivity): " + sql, (Throwable)e);
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            this.m_summary.append("Inactivity #").append(count);
            if (countEMails > 0) {
                this.m_summary.append(" (").append(countEMails).append(" EMail)");
            }
            this.m_summary.append(" - ");
        }
    }

    private int sendEmail(MWFActivity activity, String AD_Message, boolean toProcess, boolean toSupervisor) {
        if (this.m_client == null || this.m_client.getAD_Client_ID() != activity.getAD_Client_ID()) {
            this.m_client = MClient.get((Properties)this.getCtx(), (int)activity.getAD_Client_ID());
        }
        MWFProcess process = new MWFProcess(this.getCtx(), activity.getAD_WF_Process_ID(), null);
        String subjectVar = activity.getNode().getName();
        String message = activity.getTextMsg();
        if (message == null || message.length() == 0) {
            message = process.getTextMsg();
        }
        File pdf = null;
        PO po = activity.getPO();
        if (po instanceof DocAction) {
            message = String.valueOf(((DocAction)po).getDocumentInfo()) + "\n" + message;
            pdf = ((DocAction)po).createPDF();
        }
        String subject = Msg.getMsg((String)this.m_client.getAD_Language(), (String)AD_Message, (Object[])new Object[]{subjectVar});
        ArrayList<Integer> list = new ArrayList<Integer>();
        int counter = 0;
        if (this.m_client.sendEMail(activity.getAD_User_ID(), subject, message, pdf)) {
            ++counter;
        }
        list.add(new Integer(activity.getAD_User_ID()));
        if (toProcess && process.getAD_User_ID() != activity.getAD_User_ID()) {
            if (this.m_client.sendEMail(process.getAD_User_ID(), subject, message, pdf)) {
                ++counter;
            }
            list.add(new Integer(process.getAD_User_ID()));
        }
        MWFResponsible responsible = MWFResponsible.get((Properties)this.getCtx(), (int)activity.getAD_WF_Responsible_ID());
        counter += this.sendAlertToResponsible(responsible, list, process, subject, message, pdf);
        if (toProcess && process.getAD_WF_Responsible_ID() != activity.getAD_WF_Responsible_ID()) {
            responsible = MWFResponsible.get((Properties)this.getCtx(), (int)process.getAD_WF_Responsible_ID());
            counter += this.sendAlertToResponsible(responsible, list, process, subject, message, pdf);
        }
        if (toSupervisor && this.m_model.getSupervisor_ID() != 0 && !list.contains(new Integer(this.m_model.getSupervisor_ID()))) {
            if (this.m_client.sendEMail(this.m_model.getSupervisor_ID(), subject, message, pdf)) {
                ++counter;
            }
            list.add(new Integer(this.m_model.getSupervisor_ID()));
        }
        return counter;
    }

    private int sendAlertToResponsible(MWFResponsible responsible, ArrayList<Integer> list, MWFProcess process, String subject, String message, File pdf) {
        int counter = 0;
        if (!responsible.isInvoker()) {
            if ("H".equals(responsible.getResponsibleType()) && responsible.getAD_User_ID() != 0 && !list.contains(new Integer(responsible.getAD_User_ID()))) {
                if (this.m_client.sendEMail(responsible.getAD_User_ID(), subject, message, pdf)) {
                    ++counter;
                }
                list.add(new Integer(responsible.getAD_User_ID()));
            } else if ("O".equals(responsible.getResponsibleType())) {
                MOrgInfo org;
                PO document = process.getPO();
                if (document != null && (org = MOrgInfo.get((Properties)this.getCtx(), (int)document.getAD_Org_ID(), null)).getSupervisor_ID() != 0 && !list.contains(new Integer(org.getSupervisor_ID()))) {
                    if (this.m_client.sendEMail(org.getSupervisor_ID(), subject, message, pdf)) {
                        ++counter;
                    }
                    list.add(new Integer(org.getSupervisor_ID()));
                }
            } else if ("R".equals(responsible.getResponsibleType()) && responsible.getAD_Role_ID() != 0) {
                MUserRoles[] userRoles = MUserRoles.getOfRole((Properties)this.getCtx(), (int)responsible.getAD_Role_ID());
                int i = 0;
                while (i < userRoles.length) {
                    int AD_User_ID;
                    MUserRoles roles = userRoles[i];
                    if (roles.isActive() && !list.contains(new Integer(AD_User_ID = roles.getAD_User_ID()))) {
                        if (this.m_client.sendEMail(AD_User_ID, subject, message, pdf)) {
                            ++counter;
                        }
                        list.add(new Integer(AD_User_ID));
                    }
                    ++i;
                }
            }
        }
        return counter;
    }

    @Override
    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString();
    }
}

