/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.ServerContext;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.MAttachment;
import org.compiere.model.MClient;
import org.compiere.model.MNote;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MRole;
import org.compiere.model.MScheduler;
import org.compiere.model.MSchedulerLog;
import org.compiere.model.MSchedulerPara;
import org.compiere.model.MUser;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.process.ServerProcessCtl;
import org.compiere.server.AdempiereServer;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;

public class Scheduler
extends AdempiereServer {
    private MScheduler m_model = null;
    private StringBuffer m_summary = new StringBuffer();
    private Trx m_trx = null;
    Properties m_schedulerctx = new Properties();

    public Scheduler(MScheduler model) {
        super((AdempiereProcessor)model, 30);
        this.m_model = model;
    }

    @Override
    protected void doWork() {
        block11: {
            MOrgInfo schedorg;
            this.m_summary = new StringBuffer(this.m_model.toString()).append(" - ");
            this.m_schedulerctx.clear();
            MClient schedclient = MClient.get((Properties)this.getCtx(), (int)this.m_model.getAD_Client_ID());
            Env.setContext((Properties)this.m_schedulerctx, (String)"#AD_Client_ID", (int)schedclient.getAD_Client_ID());
            Env.setContext((Properties)this.m_schedulerctx, (String)"#AD_Language", (String)schedclient.getAD_Language());
            Env.setContext((Properties)this.m_schedulerctx, (String)"#AD_Org_ID", (int)this.m_model.getAD_Org_ID());
            if (this.m_model.getAD_Org_ID() != 0 && (schedorg = MOrgInfo.get((Properties)this.getCtx(), (int)this.m_model.getAD_Org_ID(), null)).getM_Warehouse_ID() > 0) {
                Env.setContext((Properties)this.m_schedulerctx, (String)"#M_Warehouse_ID", (int)schedorg.getM_Warehouse_ID());
            }
            Env.setContext((Properties)this.m_schedulerctx, (String)"#AD_User_ID", (int)this.getAD_User_ID());
            Env.setContext((Properties)this.m_schedulerctx, (String)"#SalesRep_ID", (int)this.getAD_User_ID());
            MUser scheduser = MUser.get((Properties)this.getCtx(), (int)this.getAD_User_ID());
            MRole[] schedroles = scheduser.getRoles(this.m_model.getAD_Org_ID());
            if (schedroles != null && schedroles.length > 0) {
                Env.setContext((Properties)this.m_schedulerctx, (String)"#AD_Role_ID", (int)schedroles[0].getAD_Role_ID());
            }
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            SimpleDateFormat dateFormat4Timestamp = new SimpleDateFormat("yyyy-MM-dd");
            Env.setContext((Properties)this.m_schedulerctx, (String)"#Date", (String)(String.valueOf(dateFormat4Timestamp.format(ts)) + " 00:00:00"));
            ServerContext.setCurrentInstance((Properties)this.m_schedulerctx);
            MProcess process = new MProcess(this.m_schedulerctx, this.m_model.getAD_Process_ID(), null);
            try {
                try {
                    this.m_trx = Trx.get((String)Trx.createTrxName((String)"Scheduler"), (boolean)true);
                    this.m_summary.append(this.runProcess(process));
                    this.m_trx.commit(true);
                }
                catch (Exception e) {
                    if (this.m_trx != null) {
                        this.m_trx.rollback();
                    }
                    this.log.log(Level.WARNING, process.toString(), (Throwable)e);
                    this.m_summary.append(e.toString());
                    if (this.m_trx != null) {
                        this.m_trx.close();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (this.m_trx != null) {
                    this.m_trx.close();
                }
                throw throwable;
            }
            if (this.m_trx != null) {
                this.m_trx.close();
            }
        }
        ServerContext.dispose();
        int no = this.m_model.deleteLog();
        this.m_summary.append(" Logs deleted=").append(no);
        MSchedulerLog pLog = new MSchedulerLog(this.m_model, this.m_summary.toString());
        pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed((Timestamp)new Timestamp(this.p_startWork)));
        pLog.saveEx();
    }

    private String runProcess(MProcess process) throws Exception {
        ProcessInfo pi;
        block18: {
            MUser from;
            int Record_ID;
            int AD_Table_ID;
            boolean isReport;
            block17: {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info(process.toString());
                }
                isReport = process.isReport() || process.getAD_ReportView_ID() > 0;
                AD_Table_ID = this.m_model.getAD_Table_ID();
                Record_ID = this.m_model.getRecord_ID();
                MPInstance pInstance = new MPInstance(process, Record_ID);
                this.fillParameter(pInstance);
                pi = new ProcessInfo(process.getName(), process.getAD_Process_ID(), AD_Table_ID, Record_ID);
                pi.setAD_User_ID(this.getAD_User_ID());
                pi.setAD_Client_ID(this.m_model.getAD_Client_ID());
                pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
                from = new MUser(this.getCtx(), pi.getAD_User_ID().intValue(), null);
                if (process.processIt(pi, this.m_trx)) break block17;
                int supervisor = this.m_model.getSupervisor_ID();
                if (supervisor <= 0) break block18;
                MUser user = new MUser(this.getCtx(), supervisor, null);
                boolean email = user.isNotificationEMail();
                boolean notice = user.isNotificationNote();
                if (email || notice) {
                    ProcessInfoUtil.setLogFromDB((ProcessInfo)pi);
                }
                if (email) {
                    MClient client = MClient.get((Properties)this.m_model.getCtx(), (int)this.m_model.getAD_Client_ID());
                    client.sendEMail(from, user, process.getName(), String.valueOf(pi.getSummary()) + " " + pi.getLogInfo(), null);
                }
                if (!notice) break block18;
                int AD_Message_ID = 442;
                MNote note = new MNote(this.getCtx(), AD_Message_ID, supervisor, null);
                note.setClientOrg(this.m_model.getAD_Client_ID(), this.m_model.getAD_Org_ID());
                note.setTextMsg(pi.getSummary());
                note.setRecord(282, pi.getAD_PInstance_ID());
                note.saveEx();
                break block18;
            }
            Integer[] userIDs = this.m_model.getRecipientAD_User_IDs();
            if (userIDs.length > 0) {
                ProcessInfoUtil.setLogFromDB((ProcessInfo)pi);
                int i = 0;
                while (i < userIDs.length) {
                    MUser user = new MUser(this.getCtx(), userIDs[i].intValue(), null);
                    boolean email = user.isNotificationEMail();
                    boolean notice = user.isNotificationNote();
                    File report = null;
                    if (isReport) {
                        ReportEngine re = ReportEngine.get((Properties)this.m_schedulerctx, (ProcessInfo)pi);
                        if (process.getJasperReport() != null || re != null && re.getPrintFormat().getJasperProcess_ID() > 0) {
                            ProcessInfo jasperpi = new ProcessInfo("", process.getAD_Process_ID());
                            jasperpi.setIsBatch(true);
                            ServerProcessCtl.process((ProcessInfo)jasperpi, null);
                            report = jasperpi.getPDFReport();
                        } else {
                            if (re == null) {
                                return "Cannot create Report AD_Process_ID=" + process.getAD_Process_ID() + " - " + process.getName();
                            }
                            report = re.getPDF();
                        }
                    }
                    if (notice) {
                        int AD_Message_ID = 441;
                        if (isReport) {
                            AD_Message_ID = 884;
                        }
                        MNote note = new MNote(this.getCtx(), AD_Message_ID, userIDs[i].intValue(), null);
                        note.setClientOrg(this.m_model.getAD_Client_ID(), this.m_model.getAD_Org_ID());
                        if (isReport) {
                            note.setTextMsg(this.m_model.getName());
                            note.setDescription(this.m_model.getDescription());
                            note.setRecord(AD_Table_ID, Record_ID);
                        } else {
                            note.setTextMsg(pi.getSummary());
                            note.setRecord(282, pi.getAD_PInstance_ID());
                        }
                        if (note.save() && isReport) {
                            MAttachment attachment = new MAttachment(this.getCtx(), 389, note.getAD_Note_ID(), null);
                            attachment.setClientOrg(this.m_model.getAD_Client_ID(), this.m_model.getAD_Org_ID());
                            attachment.addEntry(report);
                            attachment.setTextMsg(this.m_model.getName());
                            attachment.saveEx();
                        }
                    }
                    if (email) {
                        MClient client = MClient.get((Properties)this.m_model.getCtx(), (int)this.m_model.getAD_Client_ID());
                        if (isReport) {
                            client.sendEMail(from, user, this.m_model.getName(), this.m_model.getDescription(), report);
                        } else {
                            client.sendEMail(from, user, process.getName(), String.valueOf(pi.getSummary()) + " " + pi.getLogInfo(), null);
                        }
                    }
                    ++i;
                }
            }
        }
        return pi.getSummary();
    }

    private int getAD_User_ID() {
        int AD_User_ID = this.m_model.getSupervisor_ID() > 0 ? this.m_model.getSupervisor_ID() : (this.m_model.getCreatedBy() > 0 ? this.m_model.getCreatedBy() : (this.m_model.getUpdatedBy() > 0 ? this.m_model.getUpdatedBy() : 100));
        return AD_User_ID;
    }

    private void fillParameter(MPInstance pInstance) {
        MSchedulerPara[] sParams = this.m_model.getParameters(false);
        MPInstancePara[] iParams = pInstance.getParameters();
        int pi = 0;
        while (pi < iParams.length) {
            MPInstancePara iPara = iParams[pi];
            int np = 0;
            while (np < sParams.length) {
                MSchedulerPara sPara = sParams[np];
                if (iPara.getParameterName().equals(sPara.getColumnName())) {
                    String paraDesc = sPara.getDescription();
                    if (paraDesc != null && paraDesc.trim().length() > 0) {
                        iPara.setInfo(sPara.getDescription());
                    }
                    String variable = sPara.getParameterDefault();
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(String.valueOf(sPara.getColumnName()) + " = " + variable);
                    }
                    String value = variable;
                    if (variable == null || variable != null && variable.length() == 0) {
                        value = null;
                    } else if (variable.indexOf(64) != -1 && variable.indexOf(64) != variable.lastIndexOf(64)) {
                        int index = variable.indexOf(64);
                        String columnName = variable.substring(index + 1);
                        if ((index = columnName.indexOf(64)) == -1) {
                            this.log.warning(String.valueOf(sPara.getColumnName()) + " - cannot evaluate=" + variable);
                            break;
                        }
                        String env = Env.getContext((Properties)this.m_schedulerctx, (String)(columnName = columnName.substring(0, index)));
                        if (env == null || env.length() == 0) {
                            env = Env.getContext((Properties)this.getCtx(), (String)columnName);
                        }
                        if (env.length() == 0) {
                            this.log.warning(String.valueOf(sPara.getColumnName()) + " - not in environment =" + columnName + "(" + variable + ")");
                            break;
                        }
                        value = env;
                    }
                    if (value == null) {
                        if (!this.log.isLoggable(Level.FINE)) break;
                        this.log.fine(String.valueOf(sPara.getColumnName()) + " - empty");
                        break;
                    }
                    try {
                        if (DisplayType.isNumeric((int)sPara.getDisplayType()) || DisplayType.isID((int)sPara.getDisplayType())) {
                            BigDecimal bd = null;
                            bd = value instanceof BigDecimal ? (BigDecimal)((Object)value) : (value instanceof Integer ? new BigDecimal((Integer)((Object)value)) : new BigDecimal(value.toString()));
                            iPara.setP_Number(bd);
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine(String.valueOf(sPara.getColumnName()) + " = " + variable + " (=" + bd + "=)");
                            }
                        } else if (DisplayType.isDate((int)sPara.getDisplayType())) {
                            Timestamp ts = null;
                            ts = value instanceof Timestamp ? (Timestamp)((Object)value) : Timestamp.valueOf(value.toString());
                            iPara.setP_Date(ts);
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine(String.valueOf(sPara.getColumnName()) + " = " + variable + " (=" + ts + "=)");
                            }
                        } else {
                            iPara.setP_String(value.toString());
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine(String.valueOf(sPara.getColumnName()) + " = " + variable + " (=" + value + "=) " + value.getClass().getName());
                            }
                        }
                        if (iPara.save()) break;
                        this.log.warning("Not Saved - " + sPara.getColumnName());
                    }
                    catch (Exception e) {
                        this.log.warning(String.valueOf(sPara.getColumnName()) + " = " + variable + " (" + value + ") " + value.getClass().getName() + " - " + e.getLocalizedMessage());
                    }
                    break;
                }
                ++np;
            }
            ++pi;
        }
    }

    @Override
    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString();
    }
}

