/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.adempiere.base.Service;
import org.adempiere.server.IServerFactory;
import org.compiere.Adempiere;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.MAcctProcessor;
import org.compiere.model.MAlertProcessor;
import org.compiere.model.MLdapProcessor;
import org.compiere.model.MRequestProcessor;
import org.compiere.model.MScheduler;
import org.compiere.model.MSession;
import org.compiere.server.AdempiereServer;
import org.compiere.server.AdempiereServerGroup;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.wf.MWorkflowProcessor;

public class AdempiereServerMgr {
    private static AdempiereServerMgr m_serverMgr = null;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private ArrayList<ServerWrapper> m_servers = new ArrayList();
    private Properties m_ctx = Env.getCtx();
    private Timestamp m_start = new Timestamp(System.currentTimeMillis());

    public static synchronized AdempiereServerMgr get() {
        if (m_serverMgr == null) {
            m_serverMgr = new AdempiereServerMgr();
            m_serverMgr.startServers();
            AdempiereServerMgr.m_serverMgr.log.info(m_serverMgr.toString());
        }
        return m_serverMgr;
    }

    private AdempiereServerMgr() {
        this.startEnvironment();
    }

    private boolean startEnvironment() {
        Adempiere.startup((boolean)false);
        this.log.info("");
        MSession session = MSession.get((Properties)this.getCtx(), (boolean)true);
        session.setWebStoreSession(false);
        session.setWebSession("Server");
        session.saveEx();
        return true;
    }

    public boolean startServers() {
        this.log.info("");
        int noServers = 0;
        this.m_servers = new ArrayList();
        MAcctProcessor[] acctModels = MAcctProcessor.getActive((Properties)this.m_ctx);
        int i = 0;
        while (i < acctModels.length) {
            MAcctProcessor pModel = acctModels[i];
            AdempiereServer server = AdempiereServer.create((AdempiereProcessor)pModel);
            if (server != null) {
                this.m_servers.add(new ServerWrapper(server));
            }
            ++i;
        }
        MRequestProcessor[] requestModels = MRequestProcessor.getActive((Properties)this.m_ctx);
        int i2 = 0;
        while (i2 < requestModels.length) {
            MRequestProcessor pModel = requestModels[i2];
            AdempiereServer server = AdempiereServer.create((AdempiereProcessor)pModel);
            if (server != null) {
                this.m_servers.add(new ServerWrapper(server));
            }
            ++i2;
        }
        MWorkflowProcessor[] workflowModels = MWorkflowProcessor.getActive((Properties)this.m_ctx);
        int i3 = 0;
        while (i3 < workflowModels.length) {
            MWorkflowProcessor pModel = workflowModels[i3];
            AdempiereServer server = AdempiereServer.create((AdempiereProcessor)pModel);
            if (server != null) {
                this.m_servers.add(new ServerWrapper(server));
            }
            ++i3;
        }
        MAlertProcessor[] alertModels = MAlertProcessor.getActive((Properties)this.m_ctx);
        int i4 = 0;
        while (i4 < alertModels.length) {
            MAlertProcessor pModel = alertModels[i4];
            AdempiereServer server = AdempiereServer.create((AdempiereProcessor)pModel);
            if (server != null) {
                this.m_servers.add(new ServerWrapper(server));
            }
            ++i4;
        }
        MScheduler[] schedulerModels = MScheduler.getActive((Properties)this.m_ctx);
        int i5 = 0;
        while (i5 < schedulerModels.length) {
            MScheduler pModel = schedulerModels[i5];
            AdempiereServer server = AdempiereServer.create((AdempiereProcessor)pModel);
            if (server != null) {
                this.m_servers.add(new ServerWrapper(server));
            }
            ++i5;
        }
        MLdapProcessor[] ldapModels = MLdapProcessor.getActive((Properties)this.m_ctx);
        int i6 = 0;
        while (i6 < ldapModels.length) {
            MLdapProcessor lp = ldapModels[i6];
            AdempiereServer server = AdempiereServer.create((AdempiereProcessor)lp);
            if (server != null) {
                this.m_servers.add(new ServerWrapper(server));
            }
            ++i6;
        }
        List serverFactoryList = Service.locator().list(IServerFactory.class).getServices();
        if (serverFactoryList != null && !serverFactoryList.isEmpty()) {
            for (IServerFactory factory : serverFactoryList) {
                AdempiereServer[] servers = factory.create(this.m_ctx);
                if (servers == null || servers.length <= 0) continue;
                AdempiereServer[] adempiereServerArray = servers;
                int n = servers.length;
                int n2 = 0;
                while (n2 < n) {
                    AdempiereServer server = adempiereServerArray[n2];
                    this.m_servers.add(new ServerWrapper(server));
                    ++n2;
                }
            }
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + noServers);
        }
        return this.startAll();
    }

    public Properties getCtx() {
        return this.m_ctx;
    }

    public boolean startAll() {
        this.log.info("");
        ServerWrapper[] servers = this.getInActive();
        int i = 0;
        while (i < servers.length) {
            ServerWrapper server = servers[i];
            try {
                if (server.scheduleFuture == null && server.scheduleFuture.isDone()) {
                    server.start();
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Server: " + server, (Throwable)e);
            }
            ++i;
        }
        int noRunning = 0;
        int noStopped = 0;
        int i2 = 0;
        while (i2 < servers.length) {
            ServerWrapper server = servers[i2];
            try {
                if (server.scheduleFuture != null && !server.scheduleFuture.isDone()) {
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info("Alive: " + server);
                    }
                    ++noRunning;
                } else {
                    this.log.warning("Dead: " + server);
                    ++noStopped;
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "(checking) - " + server, (Throwable)e);
                ++noStopped;
            }
            ++i2;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Running=" + noRunning + ", Stopped=" + noStopped);
        }
        return noStopped == 0;
    }

    public boolean start(String serverID) {
        ServerWrapper server = this.getServer(serverID);
        if (server == null) {
            return false;
        }
        if (server.scheduleFuture != null && !server.scheduleFuture.isDone()) {
            return true;
        }
        try {
            server.start();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Server=" + serverID, (Throwable)e);
            return false;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(server.toString());
        }
        return server.scheduleFuture != null && !server.scheduleFuture.isDone();
    }

    public boolean stopAll() {
        ServerWrapper server;
        this.log.info("");
        ServerWrapper[] servers = this.getActive();
        int i = 0;
        while (i < servers.length) {
            server = servers[i];
            try {
                if (server.scheduleFuture != null && !server.scheduleFuture.isDone()) {
                    server.scheduleFuture.cancel(true);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "(interrupting) - " + server, (Throwable)e);
            }
            ++i;
        }
        Thread.yield();
        i = 0;
        while (i < servers.length) {
            server = servers[i];
            try {
                int maxWait = 10;
                while (server.scheduleFuture != null && !server.scheduleFuture.isDone()) {
                    if (maxWait-- == 0) {
                        this.log.severe("Wait timeout for interruped " + server);
                        break;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "(waiting) - " + server, (Throwable)e);
            }
            ++i;
        }
        int noRunning = 0;
        int noStopped = 0;
        int i2 = 0;
        while (i2 < servers.length) {
            ServerWrapper server2 = servers[i2];
            try {
                if (server2.scheduleFuture != null && !server2.scheduleFuture.isDone()) {
                    this.log.warning("Alive: " + server2);
                    ++noRunning;
                } else {
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info("Stopped: " + server2);
                    }
                    ++noStopped;
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "(checking) - " + server2, (Throwable)e);
                ++noRunning;
            }
            ++i2;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Running=" + noRunning + ", Stopped=" + noStopped);
        }
        AdempiereServerGroup.get().dump();
        return noRunning == 0;
    }

    public boolean stop(String serverID) {
        ServerWrapper server = this.getServer(serverID);
        if (server == null) {
            return false;
        }
        if (server.scheduleFuture == null || server.scheduleFuture.isDone()) {
            return true;
        }
        try {
            server.scheduleFuture.cancel(true);
            Thread.sleep(10L);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "stop", (Throwable)e);
            return false;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(server.toString());
        }
        return server.scheduleFuture == null || server.scheduleFuture.isDone();
    }

    public void destroy() {
        this.log.info("");
        this.stopAll();
        this.m_servers.clear();
    }

    protected ServerWrapper[] getActive() {
        ArrayList<ServerWrapper> list = new ArrayList<ServerWrapper>();
        int i = 0;
        while (i < this.m_servers.size()) {
            ServerWrapper server = this.m_servers.get(i);
            if (server != null && server.scheduleFuture != null && !server.scheduleFuture.isDone()) {
                list.add(server);
            }
            ++i;
        }
        ServerWrapper[] retValue = new ServerWrapper[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    protected ServerWrapper[] getInActive() {
        ArrayList<ServerWrapper> list = new ArrayList<ServerWrapper>();
        int i = 0;
        while (i < this.m_servers.size()) {
            ServerWrapper server = this.m_servers.get(i);
            if (server != null && (server.scheduleFuture == null || server.scheduleFuture.isDone())) {
                list.add(server);
            }
            ++i;
        }
        ServerWrapper[] retValue = new ServerWrapper[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public ServerWrapper[] getAll() {
        ServerWrapper[] retValue = new ServerWrapper[this.m_servers.size()];
        this.m_servers.toArray(retValue);
        return retValue;
    }

    public ServerWrapper getServer(String serverID) {
        if (serverID == null) {
            return null;
        }
        int i = 0;
        while (i < this.m_servers.size()) {
            ServerWrapper server = this.m_servers.get(i);
            if (serverID.equals(server.server.getServerID())) {
                return server;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AdempiereServerMgr[");
        sb.append("Servers=").append(this.m_servers.size()).append(",ContextSize=").append(this.m_ctx.size()).append(",Started=").append(this.m_start).append("]");
        return sb.toString();
    }

    public String getDescription() {
        return "$Revision: 1.4 $";
    }

    public String getServerCount() {
        int noRunning = 0;
        int noStopped = 0;
        int i = 0;
        while (i < this.m_servers.size()) {
            ServerWrapper server = this.m_servers.get(i);
            if (server.scheduleFuture != null && !server.scheduleFuture.isDone()) {
                ++noRunning;
            } else {
                ++noStopped;
            }
            ++i;
        }
        String info = String.valueOf(String.valueOf(this.m_servers.size())) + " - Running=" + noRunning + " - Stopped=" + noStopped;
        return info;
    }

    public Timestamp getStartTime() {
        return this.m_start;
    }

    public static class ServerWrapper
    implements Runnable {
        protected AdempiereServer server;
        protected volatile ScheduledFuture<?> scheduleFuture;

        public ServerWrapper(AdempiereServer server) {
            this.server = server;
            this.start();
        }

        public void start() {
            this.scheduleFuture = Adempiere.getThreadPoolExecutor().schedule(this, this.server.getInitialNap() * 1000L + this.server.getSleepMS(), TimeUnit.MILLISECONDS);
        }

        @Override
        public void run() {
            this.server.run();
            this.scheduleFuture = Adempiere.getThreadPoolExecutor().schedule(this, this.server.getSleepMS(), TimeUnit.MILLISECONDS);
        }

        public AdempiereServer getServer() {
            return this.server;
        }

        public boolean isAlive() {
            return this.scheduleFuture != null && !this.scheduleFuture.isDone();
        }

        public boolean isInterrupted() {
            return this.scheduleFuture != null && this.scheduleFuture.isCancelled();
        }
    }
}

