/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.ldap.LdapProcessor;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessor2;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MAcctProcessor;
import org.compiere.model.MAlertProcessor;
import org.compiere.model.MClient;
import org.compiere.model.MLdapProcessor;
import org.compiere.model.MRequestProcessor;
import org.compiere.model.MSchedule;
import org.compiere.model.MScheduler;
import org.compiere.model.MSystem;
import org.compiere.server.AcctProcessor;
import org.compiere.server.AlertProcessor;
import org.compiere.server.RequestProcessor;
import org.compiere.server.Scheduler;
import org.compiere.server.WorkflowProcessor;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflowProcessor;

public abstract class AdempiereServer
implements Runnable {
    protected volatile AdempiereProcessor p_model;
    private int m_initialNap = 0;
    protected long m_sleepMS = 0L;
    private volatile boolean m_sleeping = true;
    protected long m_start = 0L;
    protected int p_runCount = 0;
    protected long p_startWork = 0L;
    private long m_runLastMS = 0L;
    private long m_runTotalMS = 0L;
    private long m_nextWork = 0L;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private Properties m_ctx = null;
    protected static volatile MSystem p_system = null;
    protected MClient p_client = null;

    public static AdempiereServer create(AdempiereProcessor model) {
        if (!AdempiereServer.isOKtoRunOnIP(model)) {
            return null;
        }
        if (model instanceof MRequestProcessor) {
            return new RequestProcessor((MRequestProcessor)model);
        }
        if (model instanceof MWorkflowProcessor) {
            return new WorkflowProcessor((MWorkflowProcessor)model);
        }
        if (model instanceof MAcctProcessor) {
            return new AcctProcessor((MAcctProcessor)model);
        }
        if (model instanceof MAlertProcessor) {
            return new AlertProcessor((MAlertProcessor)model);
        }
        if (model instanceof MScheduler) {
            return new Scheduler((MScheduler)model);
        }
        if (model instanceof MLdapProcessor) {
            return new LdapProcessor((MLdapProcessor)model);
        }
        throw new IllegalArgumentException("Unknown Processor");
    }

    protected AdempiereServer(AdempiereProcessor model, int initialNap) {
        long now;
        this.p_model = model;
        this.m_ctx = new Properties(model.getCtx());
        if (p_system == null) {
            p_system = MSystem.get((Properties)this.m_ctx);
        }
        this.p_client = MClient.get((Properties)this.m_ctx);
        Env.setContext((Properties)this.m_ctx, (String)"#AD_Client_ID", (int)this.p_client.getAD_Client_ID());
        this.m_initialNap = initialNap;
        Timestamp dateNextRun = this.getDateNextRun(true);
        if (dateNextRun != null) {
            this.m_nextWork = dateNextRun.getTime();
        }
        if (this.m_nextWork > (now = System.currentTimeMillis())) {
            this.m_sleepMS = this.m_nextWork - now;
        }
    }

    public Properties getCtx() {
        return this.m_ctx;
    }

    public long getSleepMS() {
        return this.m_sleepMS;
    }

    public long getInitialNap() {
        return this.m_initialNap;
    }

    public void runNow() {
        this.m_sleeping = false;
        this.p_startWork = System.currentTimeMillis();
        this.doWork();
        long now = System.currentTimeMillis();
        ++this.p_runCount;
        this.m_runLastMS = now - this.p_startWork;
        this.m_runTotalMS += this.m_runLastMS;
        this.p_model.setDateLastRun(new Timestamp(now));
        this.p_model.saveEx();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.getStatistics());
        }
        this.m_sleeping = true;
    }

    @Override
    public void run() {
        AdempiereProcessor2 ap;
        Thread currentThread = Thread.currentThread();
        String oldThreadName = currentThread.getName();
        String newThreadName = this.getName();
        boolean renamed = false;
        if (!oldThreadName.equals(newThreadName)) {
            try {
                currentThread.setName(newThreadName);
                renamed = true;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        this.m_sleeping = false;
        if (this.m_start == 0L) {
            this.m_start = System.currentTimeMillis();
        }
        this.p_startWork = System.currentTimeMillis();
        this.doWork();
        long now = System.currentTimeMillis();
        ++this.p_runCount;
        this.m_runLastMS = now - this.p_startWork;
        this.m_runTotalMS += this.m_runLastMS;
        Timestamp lastRun = new Timestamp(now);
        if (this.p_model instanceof AdempiereProcessor2 && (ap = (AdempiereProcessor2)this.p_model).isIgnoreProcessingTime()) {
            lastRun = new Timestamp(this.p_startWork);
        }
        this.m_nextWork = MSchedule.getNextRunMS((long)lastRun.getTime(), (String)this.p_model.getScheduleType(), (String)this.p_model.getFrequencyType(), (int)this.p_model.getFrequency(), (String)this.p_model.getCronPattern());
        this.m_sleepMS = this.m_nextWork - now;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(" Next run: " + new Timestamp(this.m_nextWork) + " sleep " + this.m_sleepMS);
        }
        this.p_model.setDateLastRun(lastRun);
        this.p_model.setDateNextRun(new Timestamp(this.m_nextWork));
        this.p_model.saveEx();
        this.m_sleeping = true;
        if (renamed) {
            currentThread.setName(oldThreadName);
        }
    }

    public String getStatistics() {
        return "Run #" + this.p_runCount + " - Last=" + TimeUtil.formatElapsed((long)this.m_runLastMS) + " - Total=" + TimeUtil.formatElapsed((long)this.m_runTotalMS) + " - Next " + TimeUtil.formatElapsed((long)(this.m_nextWork - System.currentTimeMillis()));
    }

    protected abstract void doWork();

    public abstract String getServerInfo();

    public String getServerID() {
        return this.p_model.getServerID();
    }

    public Timestamp getDateNextRun(boolean requery) {
        return this.p_model.getDateNextRun(requery);
    }

    public Timestamp getDateLastRun() {
        return this.p_model.getDateLastRun();
    }

    public String getDescription() {
        return this.p_model.getDescription();
    }

    public AdempiereProcessor getModel() {
        return this.p_model;
    }

    public boolean isSleeping() {
        return this.m_sleeping;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append("Sleeping=").append(this.m_sleeping).append(",Last=").append(this.getDateLastRun());
        if (this.m_sleeping) {
            sb.append(",Next=").append(this.getDateNextRun(false));
        }
        return sb.toString();
    }

    public int getSecondsAlive() {
        if (this.m_start == 0L) {
            return 0;
        }
        long now = System.currentTimeMillis();
        long ms = (now - this.m_start) / 1000L;
        return (int)ms;
    }

    public Timestamp getStartTime() {
        if (this.m_start == 0L) {
            return null;
        }
        return new Timestamp(this.m_start);
    }

    public AdempiereProcessorLog[] getLogs() {
        return this.p_model.getLogs();
    }

    protected boolean isInterrupted() {
        return Thread.currentThread().isInterrupted();
    }

    public String getName() {
        return this.p_model.getName();
    }

    public static boolean isOKtoRunOnIP(AdempiereProcessor model) {
        if (model instanceof AdempiereProcessor2) {
            int AD_Schedule_ID = ((AdempiereProcessor2)model).getAD_Schedule_ID();
            MSchedule schedule = MSchedule.get((Properties)Env.getCtx(), (int)AD_Schedule_ID);
            if (!schedule.isOKtoRunOnIP()) {
                return false;
            }
        }
        return true;
    }
}

