/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.AdempiereUserError;

public class ProductionProcess
extends SvrProcess {
    private int p_M_Production_ID = 0;
    private Timestamp p_MovementDate = null;
    private MProduction m_production = null;
    private boolean mustBeStocked = false;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("MovementDate")) {
                    this.p_MovementDate = (Timestamp)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_M_Production_ID = this.getRecord_ID();
        this.m_production = new MProduction(this.getCtx(), this.p_M_Production_ID, this.get_TrxName());
    }

    protected String doIt() throws Exception {
        if (this.m_production.get_ID() == 0) {
            throw new AdempiereUserError("Could not load production header");
        }
        if (this.m_production.getIsCreated().equals("N")) {
            return "Not created";
        }
        if (this.m_production.isProcessed()) {
            return "Already processed";
        }
        return this.processLines();
    }

    protected String processLines() throws Exception {
        int processed = 0;
        this.m_production.setMovementDate(this.p_MovementDate);
        MProductionLine[] lines = this.m_production.getLines();
        StringBuilder errors = new StringBuilder();
        int i2 = 0;
        while (i2 < lines.length) {
            errors.append(lines[i2].createTransactions(this.m_production.getMovementDate(), this.mustBeStocked));
            lines[i2].setProcessed(true);
            lines[i2].saveEx(this.get_TrxName());
            ++processed;
            ++i2;
        }
        if (errors.toString().compareTo("") != 0) {
            this.log.log(Level.WARNING, errors.toString());
            throw new AdempiereSystemError(errors.toString());
        }
        this.m_production.setProcessed(true);
        this.m_production.saveEx(this.get_TrxName());
        if (MClient.isClientAccountingImmediate()) {
            String i2 = DocumentEngine.postImmediate((Properties)this.getCtx(), (int)this.getAD_Client_ID(), (int)this.m_production.get_Table_ID(), (int)this.m_production.get_ID(), (boolean)true, (String)this.get_TrxName());
        }
        StringBuilder msgreturn = new StringBuilder("@Processed@ #").append(processed);
        return msgreturn.toString();
    }
}

