/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MCurrency;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderPaySchedule;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class InOutCreateInvoice
extends SvrProcess {
    private int p_M_InOut_ID = 0;
    private int p_M_PriceList_ID = 0;
    private String p_InvoiceDocumentNo = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_PriceList_ID")) {
                    this.p_M_PriceList_ID = para[i].getParameterAsInt();
                } else if (name.equals("InvoiceDocumentNo")) {
                    this.p_InvoiceDocumentNo = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_M_InOut_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("M_InOut_ID=" + this.p_M_InOut_ID + ", M_PriceList_ID=" + this.p_M_PriceList_ID + ", InvoiceDocumentNo=" + this.p_InvoiceDocumentNo);
        }
        if (this.p_M_InOut_ID == 0) {
            throw new IllegalArgumentException("No Shipment");
        }
        MInOut ship = new MInOut(this.getCtx(), this.p_M_InOut_ID, this.get_TrxName());
        if (ship.get_ID() == 0) {
            throw new IllegalArgumentException("Shipment not found");
        }
        if (!"CO".equals(ship.getDocStatus())) {
            throw new IllegalArgumentException("Shipment not completed");
        }
        MInvoice invoice = new MInvoice(ship, null);
        if (this.p_M_PriceList_ID != 0 && ship.getM_RMA_ID() == 0) {
            invoice.setM_PriceList_ID(this.p_M_PriceList_ID);
        }
        if (this.p_InvoiceDocumentNo != null && this.p_InvoiceDocumentNo.length() > 0) {
            invoice.setDocumentNo(this.p_InvoiceDocumentNo);
        }
        if (!invoice.save()) {
            throw new IllegalArgumentException("Cannot save Invoice");
        }
        MInOutLine[] shipLines = ship.getLines(false);
        int i = 0;
        while (i < shipLines.length) {
            MInOutLine sLine = shipLines[i];
            MInvoiceLine line = new MInvoiceLine(invoice);
            line.setShipLine(sLine);
            if (sLine.sameOrderLineUOM()) {
                line.setQtyEntered(sLine.getQtyEntered());
            } else {
                line.setQtyEntered(sLine.getMovementQty());
            }
            line.setQtyInvoiced(sLine.getMovementQty());
            if (!line.save()) {
                throw new IllegalArgumentException("Cannot save Invoice Line");
            }
            ++i;
        }
        if (invoice.getC_Order_ID() > 0) {
            MOrder order = new MOrder(this.getCtx(), invoice.getC_Order_ID(), this.get_TrxName());
            invoice.setPaymentRule(order.getPaymentRule());
            invoice.setC_PaymentTerm_ID(order.getC_PaymentTerm_ID());
            invoice.saveEx();
            invoice.load(invoice.get_TrxName());
            MOrderPaySchedule[] opss = MOrderPaySchedule.getOrderPaySchedule((Properties)this.getCtx(), (int)order.getC_Order_ID(), (int)0, (String)this.get_TrxName());
            MInvoicePaySchedule[] ipss = MInvoicePaySchedule.getInvoicePaySchedule((Properties)this.getCtx(), (int)invoice.getC_Invoice_ID(), (int)0, (String)this.get_TrxName());
            if (ipss.length == 0 && opss.length > 0) {
                BigDecimal ogt = order.getGrandTotal();
                BigDecimal igt = invoice.getGrandTotal();
                BigDecimal percent = Env.ONE;
                if (ogt.compareTo(igt) != 0) {
                    percent = igt.divide(ogt, 10, 4);
                }
                MCurrency cur = MCurrency.get((Properties)order.getCtx(), (int)order.getC_Currency_ID());
                int scale = cur.getStdPrecision();
                MOrderPaySchedule[] mOrderPayScheduleArray = opss;
                int n = opss.length;
                int n2 = 0;
                while (n2 < n) {
                    MOrderPaySchedule ops = mOrderPayScheduleArray[n2];
                    MInvoicePaySchedule ips = new MInvoicePaySchedule(this.getCtx(), 0, this.get_TrxName());
                    PO.copyValues((PO)ops, (PO)ips);
                    if (percent != Env.ONE) {
                        BigDecimal propDueAmt = ops.getDueAmt().multiply(percent);
                        if (propDueAmt.scale() > scale) {
                            propDueAmt = propDueAmt.setScale(scale, 4);
                        }
                        ips.setDueAmt(propDueAmt);
                    }
                    ips.setC_Invoice_ID(invoice.getC_Invoice_ID());
                    ips.setAD_Org_ID(ops.getAD_Org_ID());
                    ips.setProcessing(ops.isProcessing());
                    ips.setIsActive(ops.isActive());
                    ips.saveEx();
                    ++n2;
                }
            }
            invoice.validatePaySchedule();
            invoice.saveEx();
        }
        this.addLog(invoice.getC_Invoice_ID(), invoice.getDateInvoiced(), invoice.getGrandTotal(), invoice.getDocumentNo(), invoice.get_Table_ID(), invoice.getC_Invoice_ID());
        return invoice.getDocumentNo();
    }
}

