/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MConversionRate;
import org.compiere.model.PO;
import org.compiere.model.X_I_Conversion_Rate;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ImportConversionRate
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_C_ConversionType_ID = 0;
    private Timestamp p_ValidFrom = null;
    private boolean p_CreateReciprocalRate = false;
    private boolean p_DeleteOldImported = false;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Client_ID")) {
                    this.p_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("C_ConversionType_ID")) {
                    this.p_C_ConversionType_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("ValidFrom")) {
                    this.p_ValidFrom = (Timestamp)para[i].getParameter();
                } else if (name.equals("CreateReciprocalRate")) {
                    this.p_CreateReciprocalRate = "Y".equals(para[i].getParameter());
                } else if (name.equals("DeleteOldImported")) {
                    this.p_DeleteOldImported = "Y".equals(para[i].getParameter());
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int noInsert;
        StringBuilder clientCheck;
        int no;
        StringBuilder sql;
        block25: {
            StringBuilder msglog = new StringBuilder("doIt - AD_Client_ID=").append(this.p_AD_Client_ID).append(",AD_Org_ID=").append(this.p_AD_Org_ID).append(",C_ConversionType_ID=").append(this.p_C_ConversionType_ID).append(",ValidFrom=").append(this.p_ValidFrom).append(",CreateReciprocalRate=").append(this.p_CreateReciprocalRate);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(msglog.toString());
            }
            sql = null;
            no = 0;
            clientCheck = new StringBuilder(" AND AD_Client_ID=").append(this.p_AD_Client_ID);
            if (this.p_DeleteOldImported) {
                sql = new StringBuilder("DELETE I_Conversion_Rate ").append("WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Delete Old Impored =" + no);
                }
            }
            sql = new StringBuilder("UPDATE I_Conversion_Rate ").append("SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.p_AD_Client_ID).append("),").append(" AD_Org_ID = COALESCE (AD_Org_ID,").append(this.p_AD_Org_ID).append("),");
            if (this.p_C_ConversionType_ID != 0) {
                sql.append(" C_ConversionType_ID = COALESCE (C_ConversionType_ID,").append(this.p_C_ConversionType_ID).append("),");
            }
            if (this.p_ValidFrom != null) {
                sql.append(" ValidFrom = COALESCE (ValidFrom,").append(DB.TO_DATE((Timestamp)this.p_ValidFrom)).append("),");
            } else {
                sql.append(" ValidFrom = COALESCE (ValidFrom,SysDate),");
            }
            sql.append(" CreateReciprocalRate = COALESCE (CreateReciprocalRate,'").append(this.p_CreateReciprocalRate ? "Y" : "N").append("'),").append(" IsActive = COALESCE (IsActive, 'Y'),").append(" Created = COALESCE (Created, SysDate),").append(" CreatedBy = COALESCE (CreatedBy, 0),").append(" Updated = COALESCE (Updated, SysDate),").append(" UpdatedBy = ").append(this.getAD_User_ID()).append(",").append(" I_ErrorMsg = ' ',").append(" Processed = 'N',").append(" I_IsImported = 'N' ").append("WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Reset =" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Conversion_Rate o ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, '").append("WHERE (AD_Org_ID IS NULL").append(" OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N')))").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                this.log.warning("Invalid Org =" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Conversion_Rate i ").append("SET C_ConversionType_ID = (SELECT C_ConversionType_ID FROM C_ConversionType c").append(" WHERE c.Value=i.ConversionTypeValue AND c.AD_Client_ID IN (0,i.AD_Client_ID) AND c.IsActive='Y') ").append("WHERE C_ConversionType_ID IS NULL AND ConversionTypeValue IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) > 0 && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set ConversionType =" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Conversion_Rate i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid ConversionType, ' ").append("WHERE (C_ConversionType_ID IS NULL").append(" OR NOT EXISTS (SELECT * FROM C_ConversionType c ").append("WHERE i.C_ConversionType_ID=c.C_ConversionType_ID AND c.IsActive='Y'").append(" AND c.AD_Client_ID IN (0,i.AD_Client_ID)))").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                this.log.warning("Invalid ConversionType =" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Conversion_Rate i ").append("SET C_Currency_ID = (SELECT C_Currency_ID FROM C_Currency c").append("\tWHERE c.ISO_Code=i.ISO_Code AND c.AD_Client_ID IN (0,i.AD_Client_ID) AND c.IsActive='Y') ").append("WHERE C_Currency_ID IS NULL AND ISO_Code IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) > 0 && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set Currency =" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Conversion_Rate i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Currency, ' ").append("WHERE (C_Currency_ID IS NULL").append(" OR NOT EXISTS (SELECT * FROM C_Currency c ").append("WHERE i.C_Currency_ID=c.C_Currency_ID AND c.IsActive='Y'").append(" AND c.AD_Client_ID IN (0,i.AD_Client_ID)))").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                this.log.warning("Invalid Currency =" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Conversion_Rate i ").append("SET C_Currency_ID_To = (SELECT C_Currency_ID FROM C_Currency c").append("\tWHERE c.ISO_Code=i.ISO_Code_To AND c.AD_Client_ID IN (0,i.AD_Client_ID) AND c.IsActive='Y') ").append("WHERE C_Currency_ID_To IS NULL AND ISO_Code_To IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) > 0 && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set Currency To =" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Conversion_Rate i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Currency To, ' ").append("WHERE (C_Currency_ID_To IS NULL").append(" OR NOT EXISTS (SELECT * FROM C_Currency c ").append("WHERE i.C_Currency_ID_To=c.C_Currency_ID AND c.IsActive='Y'").append(" AND c.AD_Client_ID IN (0,i.AD_Client_ID)))").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                this.log.warning("Invalid Currency To =" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Conversion_Rate i ").append("SET MultiplyRate = 1 / DivideRate ").append("WHERE (MultiplyRate IS NULL OR MultiplyRate = 0) AND DivideRate IS NOT NULL AND DivideRate<>0").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) > 0 && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set MultiplyRate =" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Conversion_Rate i ").append("SET DivideRate = 1 / MultiplyRate ").append("WHERE (DivideRate IS NULL OR DivideRate = 0) AND MultiplyRate IS NOT NULL AND MultiplyRate<>0").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) > 0 && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set DivideRate =" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Conversion_Rate i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Rates, ' ").append("WHERE (MultiplyRate IS NULL OR MultiplyRate = 0 OR DivideRate IS NULL OR DivideRate = 0)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                this.log.warning("Invalid Rates =" + no);
            }
            this.commitEx();
            noInsert = 0;
            sql = new StringBuilder("SELECT * FROM I_Conversion_Rate ").append("WHERE I_IsImported='N'").append((CharSequence)clientCheck).append(" ORDER BY C_Currency_ID, C_Currency_ID_To, ValidFrom");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        X_I_Conversion_Rate imp = new X_I_Conversion_Rate(this.getCtx(), rs, this.get_TrxName());
                        MConversionRate rate = new MConversionRate((PO)imp, imp.getC_ConversionType_ID(), imp.getC_Currency_ID(), imp.getC_Currency_ID_To(), imp.getMultiplyRate(), imp.getValidFrom());
                        if (imp.getValidTo() != null) {
                            rate.setValidTo(imp.getValidTo());
                        }
                        if (!rate.save()) continue;
                        imp.setC_Conversion_Rate_ID(rate.getC_Conversion_Rate_ID());
                        imp.setI_IsImported(true);
                        imp.setProcessed(true);
                        imp.saveEx();
                        ++noInsert;
                        if (!imp.isCreateReciprocalRate()) continue;
                        rate = new MConversionRate((PO)imp, imp.getC_ConversionType_ID(), imp.getC_Currency_ID_To(), imp.getC_Currency_ID(), imp.getDivideRate(), imp.getValidFrom());
                        if (imp.getValidTo() != null) {
                            rate.setValidTo(imp.getValidTo());
                        }
                        if (!rate.save()) continue;
                        ++noInsert;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block25;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        sql = new StringBuilder("UPDATE I_Conversion_Rate ").append("SET I_IsImported='N', Updated=SysDate ").append("WHERE I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@C_Conversion_Rate_ID@: @Inserted@");
        return "";
    }
}

