/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MConversionRate;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProject;
import org.compiere.model.MTimeExpense;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ExpenseSOrder
extends SvrProcess {
    private int p_C_BPartner_ID = 0;
    private Timestamp p_DateFrom = null;
    private Timestamp m_DateTo = null;
    private int m_noOrders = 0;
    private MOrder m_order = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null || para[i].getParameter_To() != null) {
                if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("DateExpense")) {
                    this.p_DateFrom = (Timestamp)para[i].getParameter();
                    this.m_DateTo = (Timestamp)para[i].getParameter_To();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        block16: {
            StringBuilder sql = new StringBuilder("SELECT * FROM S_TimeExpenseLine el ").append("WHERE el.AD_Client_ID=?").append(" AND el.C_BPartner_ID>0 AND el.IsInvoiced='Y'").append(" AND el.C_OrderLine_ID IS NULL").append(" AND EXISTS (SELECT * FROM S_TimeExpense e ").append("WHERE el.S_TimeExpense_ID=e.S_TimeExpense_ID AND e.Processed='Y')");
            if (this.p_C_BPartner_ID != 0) {
                sql.append(" AND el.C_BPartner_ID=?");
            }
            if (this.p_DateFrom != null || this.m_DateTo != null) {
                sql.append(" AND EXISTS (SELECT * FROM S_TimeExpense e ").append("WHERE el.S_TimeExpense_ID=e.S_TimeExpense_ID");
                if (this.p_DateFrom != null) {
                    sql.append(" AND e.DateReport >= ?");
                }
                if (this.m_DateTo != null) {
                    sql.append(" AND e.DateReport <= ?");
                }
                sql.append(")");
            }
            sql.append(" ORDER BY el.C_BPartner_ID, el.C_Project_ID, el.S_TimeExpense_ID, el.Line");
            MBPartner oldBPartner = null;
            int old_Project_ID = -1;
            MTimeExpense te = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    int par = 1;
                    pstmt.setInt(par++, this.getAD_Client_ID());
                    if (this.p_C_BPartner_ID != 0) {
                        pstmt.setInt(par++, this.p_C_BPartner_ID);
                    }
                    if (this.p_DateFrom != null) {
                        pstmt.setTimestamp(par++, this.p_DateFrom);
                    }
                    if (this.m_DateTo != null) {
                        pstmt.setTimestamp(par++, this.m_DateTo);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MTimeExpenseLine tel = new MTimeExpenseLine(this.getCtx(), rs, this.get_TrxName());
                        if (!tel.isInvoiced()) continue;
                        if (oldBPartner == null || oldBPartner.getC_BPartner_ID() != tel.getC_BPartner_ID()) {
                            this.completeOrder();
                            oldBPartner = new MBPartner(this.getCtx(), tel.getC_BPartner_ID(), this.get_TrxName());
                        }
                        if (old_Project_ID != tel.getC_Project_ID()) {
                            this.completeOrder();
                            old_Project_ID = tel.getC_Project_ID();
                        }
                        if (te == null || te.getS_TimeExpense_ID() != tel.getS_TimeExpense_ID()) {
                            te = new MTimeExpense(this.getCtx(), tel.getS_TimeExpense_ID(), this.get_TrxName());
                        }
                        this.processLine(te, tel, oldBPartner);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block16;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.completeOrder();
        StringBuilder msgreturn = new StringBuilder("@Created@=").append(this.m_noOrders);
        return msgreturn.toString();
    }

    private void processLine(MTimeExpense te, MTimeExpenseLine tel, MBPartner bp) {
        if (this.m_order == null) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("New Order for " + bp + ", Project=" + tel.getC_Project_ID());
            }
            this.m_order = new MOrder(this.getCtx(), 0, this.get_TrxName());
            this.m_order.setAD_Org_ID(tel.getAD_Org_ID());
            this.m_order.setC_DocTypeTarget_ID("WI");
            this.m_order.setBPartner(bp);
            if (this.m_order.getC_BPartner_Location_ID() == 0) {
                StringBuilder msglog = new StringBuilder("No BP Location: ").append(bp);
                this.log.log(Level.SEVERE, msglog.toString());
                msglog = new StringBuilder("No Location: ").append(te.getDocumentNo()).append(" ").append(bp.getName());
                this.addLog(0, te.getDateReport(), null, msglog.toString());
                this.m_order = null;
                return;
            }
            this.m_order.setM_Warehouse_ID(te.getM_Warehouse_ID());
            if (tel.getC_Activity_ID() != 0) {
                this.m_order.setC_Activity_ID(tel.getC_Activity_ID());
            }
            if (tel.getC_Campaign_ID() != 0) {
                this.m_order.setC_Campaign_ID(tel.getC_Campaign_ID());
            }
            if (tel.getC_Project_ID() != 0) {
                this.m_order.setC_Project_ID(tel.getC_Project_ID());
                MProject project = new MProject(this.getCtx(), tel.getC_Project_ID(), this.get_TrxName());
                if (project.getM_PriceList_ID() != 0) {
                    this.m_order.setM_PriceList_ID(project.getM_PriceList_ID());
                }
            }
            this.m_order.setSalesRep_ID(te.getDoc_User_ID());
            if (!this.m_order.save()) {
                throw new IllegalStateException("Cannot save Order");
            }
        } else {
            if (tel.getC_Activity_ID() != 0 && tel.getC_Activity_ID() != this.m_order.getC_Activity_ID()) {
                this.m_order.setC_Activity_ID(tel.getC_Activity_ID());
            }
            if (tel.getC_Campaign_ID() != 0 && tel.getC_Campaign_ID() != this.m_order.getC_Campaign_ID()) {
                this.m_order.setC_Campaign_ID(tel.getC_Campaign_ID());
            }
            if (!this.m_order.save()) {
                throw new IllegalStateException("Cannot save Order");
            }
        }
        MOrderLine ol = new MOrderLine(this.m_order);
        if (tel.getM_Product_ID() != 0) {
            ol.setM_Product_ID(tel.getM_Product_ID(), tel.getC_UOM_ID());
        }
        if (tel.getS_ResourceAssignment_ID() != 0) {
            ol.setS_ResourceAssignment_ID(tel.getS_ResourceAssignment_ID());
        }
        ol.setQty(tel.getQtyInvoiced());
        ol.setDescription(tel.getDescription());
        ol.setC_Project_ID(tel.getC_Project_ID());
        ol.setC_ProjectPhase_ID(tel.getC_ProjectPhase_ID());
        ol.setC_ProjectTask_ID(tel.getC_ProjectTask_ID());
        ol.setC_Activity_ID(tel.getC_Activity_ID());
        ol.setC_Campaign_ID(tel.getC_Campaign_ID());
        BigDecimal price = tel.getPriceInvoiced();
        if (price != null && price.compareTo(Env.ZERO) != 0) {
            if (tel.getC_Currency_ID() != this.m_order.getC_Currency_ID()) {
                price = MConversionRate.convert((Properties)this.getCtx(), (BigDecimal)price, (int)tel.getC_Currency_ID(), (int)this.m_order.getC_Currency_ID(), (int)this.m_order.getAD_Client_ID(), (int)this.m_order.getAD_Org_ID());
            }
            ol.setPrice(price);
        } else {
            ol.setPrice();
        }
        if (tel.getC_UOM_ID() != 0 && ol.getC_UOM_ID() == 0) {
            ol.setC_UOM_ID(tel.getC_UOM_ID());
        }
        ol.setTax();
        if (!ol.save()) {
            throw new IllegalStateException("Cannot save Order Line");
        }
        tel.setC_OrderLine_ID(ol.getC_OrderLine_ID());
        if (tel.save()) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Updated " + tel + " with C_OrderLine_ID");
            }
        } else {
            this.log.log(Level.SEVERE, "Not Updated " + tel + " with C_OrderLine_ID");
        }
    }

    private void completeOrder() {
        if (this.m_order == null) {
            return;
        }
        this.m_order.setDocAction("PR");
        if (!this.m_order.processIt("PR")) {
            StringBuilder msglog = new StringBuilder("Order Process Failed: ").append(this.m_order).append(" - ").append(this.m_order.getProcessMsg());
            this.log.warning(msglog.toString());
            msglog = new StringBuilder("Order Process Failed: ").append(this.m_order).append(" - ").append(this.m_order.getProcessMsg());
            throw new IllegalStateException(msglog.toString());
        }
        if (!this.m_order.save()) {
            throw new IllegalStateException("Cannot save Order");
        }
        ++this.m_noOrders;
        this.addLog(this.m_order.get_ID(), this.m_order.getDateOrdered(), this.m_order.getGrandTotal(), this.m_order.getDocumentNo());
        this.m_order = null;
    }
}

