/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MProduct;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class CostUpdate
extends SvrProcess {
    private int p_M_Product_Category_ID = 0;
    private String p_SetFutureCostTo = null;
    private String p_SetStandardCostTo = null;
    private int p_M_PriceList_Version_ID = 0;
    private static final String TO_AveragePO = "A";
    private static final String TO_AverageInvoiceHistory = "DI";
    private static final String TO_AveragePOHistory = "DP";
    private static final String TO_FiFo = "F";
    private static final String TO_AverageInvoice = "I";
    private static final String TO_LiFo = "L";
    private static final String TO_PriceListLimit = "LL";
    private static final String TO_StandardCost = "S";
    private static final String TO_FutureStandardCost = "f";
    private static final String TO_LastInvoicePrice = "i";
    private static final String TO_LastPOPrice = "p";
    private MCostElement m_ce = null;
    private MAcctSchema[] m_ass = null;
    private HashMap<String, MCostElement> m_ces = new HashMap();

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Product_Category_ID")) {
                    this.p_M_Product_Category_ID = para[i].getParameterAsInt();
                } else if (name.equals("SetFutureCostTo")) {
                    this.p_SetFutureCostTo = (String)para[i].getParameter();
                } else if (name.equals("SetStandardCostTo")) {
                    this.p_SetStandardCostTo = (String)para[i].getParameter();
                } else if (name.equals("M_PriceList_Version_ID")) {
                    this.p_M_PriceList_Version_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("M_Product_Category_ID=" + this.p_M_Product_Category_ID + ", Future=" + this.p_SetFutureCostTo + ", Standard=" + this.p_SetStandardCostTo + "; M_PriceList_Version_ID=" + this.p_M_PriceList_Version_ID);
        }
        if (this.p_SetFutureCostTo == null) {
            this.p_SetFutureCostTo = "";
        }
        if (this.p_SetStandardCostTo == null) {
            this.p_SetStandardCostTo = "";
        }
        if (this.p_SetFutureCostTo.length() == 0 && this.p_SetStandardCostTo.length() == 0) {
            return "-";
        }
        if (this.p_M_PriceList_Version_ID == 0 && (this.p_SetFutureCostTo.equals(TO_PriceListLimit) || this.p_SetStandardCostTo.equals(TO_PriceListLimit))) {
            throw new AdempiereUserError("@FillMandatory@  @M_PriceList_Version_ID@");
        }
        if (!this.isValid(this.p_SetFutureCostTo)) {
            throw new AdempiereUserError("@NotFound@ @M_CostElement_ID@ (Future) " + this.p_SetFutureCostTo);
        }
        if (!this.isValid(this.p_SetStandardCostTo)) {
            throw new AdempiereUserError("@NotFound@ @M_CostElement_ID@ (Standard) " + this.p_SetStandardCostTo);
        }
        MClient client = MClient.get((Properties)this.getCtx());
        this.m_ce = MCostElement.getMaterialCostElement((PO)client, (String)TO_StandardCost);
        if (this.m_ce.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @M_CostElement_ID@ (StdCost)");
        }
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(this.m_ce.toString());
        }
        this.m_ass = MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)client.getAD_Client_ID());
        int i = 0;
        while (i < this.m_ass.length) {
            this.createNew(this.m_ass[i]);
            ++i;
        }
        this.commitEx();
        int counter = this.update();
        return "#" + counter;
    }

    private boolean isValid(String to) {
        if (this.p_SetFutureCostTo.length() == 0) {
            return true;
        }
        if (to.equals(TO_AverageInvoiceHistory)) {
            to = TO_AverageInvoice;
        }
        if (to.equals(TO_AveragePOHistory)) {
            to = TO_AveragePO;
        }
        if (to.equals(TO_FutureStandardCost)) {
            to = TO_StandardCost;
        }
        if (to.equals(TO_AverageInvoice) || to.equals(TO_AveragePO) || to.equals(TO_FiFo) || to.equals(TO_LiFo) || to.equals(TO_StandardCost)) {
            MCostElement ce = this.getCostElement(this.p_SetFutureCostTo);
            return ce != null;
        }
        return true;
    }

    private void createNew(MAcctSchema as) {
        int counter;
        block10: {
            if (!as.getCostingLevel().equals("C")) {
                String txt = "Costing Level prevents creating new Costing records for " + as.getName();
                this.log.warning(txt);
                this.addLog(0, null, null, txt);
                return;
            }
            String sql = "SELECT * FROM M_Product p WHERE NOT EXISTS (SELECT * FROM M_Cost c WHERE c.M_Product_ID=p.M_Product_ID AND c.M_CostType_ID=? AND c.C_AcctSchema_ID=? AND c.M_CostElement_ID=? AND c.M_AttributeSetInstance_ID=0) AND AD_Client_ID=?";
            if (this.p_M_Product_Category_ID != 0) {
                sql = String.valueOf(sql) + " AND M_Product_Category_ID=?";
            }
            counter = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, as.getM_CostType_ID());
                    pstmt.setInt(2, as.getC_AcctSchema_ID());
                    pstmt.setInt(3, this.m_ce.getM_CostElement_ID());
                    pstmt.setInt(4, as.getAD_Client_ID());
                    if (this.p_M_Product_Category_ID != 0) {
                        pstmt.setInt(5, this.p_M_Product_Category_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if (!this.createNew(new MProduct(this.getCtx(), rs, null), as)) continue;
                        ++counter;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("#" + counter);
        }
        this.addLog(0, null, new BigDecimal(counter), "Created for " + as.getName());
    }

    private boolean createNew(MProduct product, MAcctSchema as) {
        MCost cost = MCost.get((MProduct)product, (int)0, (MAcctSchema)as, (int)0, (int)this.m_ce.getM_CostElement_ID(), (String)this.get_TrxName());
        if (cost.is_new()) {
            return cost.save();
        }
        return false;
    }

    private int update() {
        int counter;
        block11: {
            counter = 0;
            String sql = "SELECT * FROM M_Cost c WHERE M_CostElement_ID=?";
            if (this.p_M_Product_Category_ID != 0) {
                sql = String.valueOf(sql) + " AND EXISTS (SELECT * FROM M_Product p WHERE c.M_Product_ID=p.M_Product_ID AND p.M_Product_Category_ID=?)";
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_ce.getM_CostElement_ID());
                    if (this.p_M_Product_Category_ID != 0) {
                        pstmt.setInt(2, this.p_M_Product_Category_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MCost cost = new MCost(this.getCtx(), rs, this.get_TrxName());
                        int i = 0;
                        while (i < this.m_ass.length) {
                            if (this.m_ass[i].getC_AcctSchema_ID() == cost.getC_AcctSchema_ID() && this.m_ass[i].getM_CostType_ID() == cost.getM_CostType_ID() && this.update(cost)) {
                                ++counter;
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("#" + counter);
        }
        this.addLog(0, null, new BigDecimal(counter), "@Updated@");
        return counter;
    }

    private boolean update(MCost cost) throws Exception {
        boolean updated = false;
        if (this.p_SetFutureCostTo.equals(this.p_SetStandardCostTo)) {
            BigDecimal costs = this.getCosts(cost, this.p_SetFutureCostTo);
            if (costs != null && costs.signum() != 0) {
                cost.setFutureCostPrice(costs);
                cost.setCurrentCostPrice(costs);
                updated = true;
            }
        } else {
            BigDecimal costs;
            if (this.p_SetStandardCostTo.length() > 0 && (costs = this.getCosts(cost, this.p_SetStandardCostTo)) != null && costs.signum() != 0) {
                cost.setCurrentCostPrice(costs);
                updated = true;
            }
            if (this.p_SetFutureCostTo.length() > 0 && (costs = this.getCosts(cost, this.p_SetFutureCostTo)) != null && costs.signum() != 0) {
                cost.setFutureCostPrice(costs);
                updated = true;
            }
        }
        if (updated) {
            updated = cost.save();
        }
        return updated;
    }

    private BigDecimal getCosts(MCost cost, String to) throws Exception {
        BigDecimal retValue = null;
        if (to.equals(TO_AverageInvoice)) {
            MCostElement ce = this.getCostElement(TO_AverageInvoice);
            if (ce == null) {
                throw new AdempiereSystemError("CostElement not found: I");
            }
            MCost xCost = MCost.get((Properties)this.getCtx(), (int)cost.getAD_Client_ID(), (int)cost.getAD_Org_ID(), (int)cost.getM_Product_ID(), (int)cost.getM_CostType_ID(), (int)cost.getC_AcctSchema_ID(), (int)ce.getM_CostElement_ID(), (int)cost.getM_AttributeSetInstance_ID(), (String)this.get_TrxName());
            if (xCost != null) {
                retValue = xCost.getCurrentCostPrice();
            }
        } else if (to.equals(TO_AverageInvoiceHistory)) {
            MCostElement ce = this.getCostElement(TO_AverageInvoice);
            if (ce == null) {
                throw new AdempiereSystemError("CostElement not found: I");
            }
            MCost xCost = MCost.get((Properties)this.getCtx(), (int)cost.getAD_Client_ID(), (int)cost.getAD_Org_ID(), (int)cost.getM_Product_ID(), (int)cost.getM_CostType_ID(), (int)cost.getC_AcctSchema_ID(), (int)ce.getM_CostElement_ID(), (int)cost.getM_AttributeSetInstance_ID(), (String)this.get_TrxName());
            if (xCost != null) {
                retValue = xCost.getHistoryAverage();
            }
        } else if (to.equals(TO_AveragePO)) {
            MCostElement ce = this.getCostElement(TO_AveragePO);
            if (ce == null) {
                throw new AdempiereSystemError("CostElement not found: A");
            }
            MCost xCost = MCost.get((Properties)this.getCtx(), (int)cost.getAD_Client_ID(), (int)cost.getAD_Org_ID(), (int)cost.getM_Product_ID(), (int)cost.getM_CostType_ID(), (int)cost.getC_AcctSchema_ID(), (int)ce.getM_CostElement_ID(), (int)cost.getM_AttributeSetInstance_ID(), (String)this.get_TrxName());
            if (xCost != null) {
                retValue = xCost.getCurrentCostPrice();
            }
        } else if (to.equals(TO_AveragePOHistory)) {
            MCostElement ce = this.getCostElement(TO_AveragePO);
            if (ce == null) {
                throw new AdempiereSystemError("CostElement not found: A");
            }
            MCost xCost = MCost.get((Properties)this.getCtx(), (int)cost.getAD_Client_ID(), (int)cost.getAD_Org_ID(), (int)cost.getM_Product_ID(), (int)cost.getM_CostType_ID(), (int)cost.getC_AcctSchema_ID(), (int)ce.getM_CostElement_ID(), (int)cost.getM_AttributeSetInstance_ID(), (String)this.get_TrxName());
            if (xCost != null) {
                retValue = xCost.getHistoryAverage();
            }
        } else if (to.equals(TO_FiFo)) {
            MCostElement ce = this.getCostElement(TO_FiFo);
            if (ce == null) {
                throw new AdempiereSystemError("CostElement not found: F");
            }
            MCost xCost = MCost.get((Properties)this.getCtx(), (int)cost.getAD_Client_ID(), (int)cost.getAD_Org_ID(), (int)cost.getM_Product_ID(), (int)cost.getM_CostType_ID(), (int)cost.getC_AcctSchema_ID(), (int)ce.getM_CostElement_ID(), (int)cost.getM_AttributeSetInstance_ID(), (String)this.get_TrxName());
            if (xCost != null) {
                retValue = xCost.getCurrentCostPrice();
            }
        } else if (to.equals(TO_FutureStandardCost)) {
            retValue = cost.getFutureCostPrice();
        } else if (to.equals(TO_LastInvoicePrice)) {
            MCost xCost;
            MCostElement ce = this.getCostElement(TO_LastInvoicePrice);
            if (ce != null && (xCost = MCost.get((Properties)this.getCtx(), (int)cost.getAD_Client_ID(), (int)cost.getAD_Org_ID(), (int)cost.getM_Product_ID(), (int)cost.getM_CostType_ID(), (int)cost.getC_AcctSchema_ID(), (int)ce.getM_CostElement_ID(), (int)cost.getM_AttributeSetInstance_ID(), (String)this.get_TrxName())) != null) {
                retValue = xCost.getCurrentCostPrice();
            }
            if (retValue == null) {
                MProduct product = MProduct.get((Properties)this.getCtx(), (int)cost.getM_Product_ID());
                MAcctSchema as = MAcctSchema.get((Properties)this.getCtx(), (int)cost.getC_AcctSchema_ID());
                retValue = MCost.getLastInvoicePrice((MProduct)product, (int)cost.getM_AttributeSetInstance_ID(), (int)cost.getAD_Org_ID(), (int)as.getC_Currency_ID());
            }
        } else if (to.equals(TO_LastPOPrice)) {
            MCost xCost;
            MCostElement ce = this.getCostElement(TO_LastPOPrice);
            if (ce != null && (xCost = MCost.get((Properties)this.getCtx(), (int)cost.getAD_Client_ID(), (int)cost.getAD_Org_ID(), (int)cost.getM_Product_ID(), (int)cost.getM_CostType_ID(), (int)cost.getC_AcctSchema_ID(), (int)ce.getM_CostElement_ID(), (int)cost.getM_AttributeSetInstance_ID(), (String)this.get_TrxName())) != null) {
                retValue = xCost.getCurrentCostPrice();
            }
            if (retValue == null) {
                MProduct product = MProduct.get((Properties)this.getCtx(), (int)cost.getM_Product_ID());
                MAcctSchema as = MAcctSchema.get((Properties)this.getCtx(), (int)cost.getC_AcctSchema_ID());
                retValue = MCost.getLastPOPrice((MProduct)product, (int)cost.getM_AttributeSetInstance_ID(), (int)cost.getAD_Org_ID(), (int)as.getC_Currency_ID());
            }
        } else if (to.equals(TO_LiFo)) {
            MCostElement ce = this.getCostElement(TO_LiFo);
            if (ce == null) {
                throw new AdempiereSystemError("CostElement not found: L");
            }
            MCost xCost = MCost.get((Properties)this.getCtx(), (int)cost.getAD_Client_ID(), (int)cost.getAD_Org_ID(), (int)cost.getM_Product_ID(), (int)cost.getM_CostType_ID(), (int)cost.getC_AcctSchema_ID(), (int)ce.getM_CostElement_ID(), (int)cost.getM_AttributeSetInstance_ID(), (String)this.get_TrxName());
            if (xCost != null) {
                retValue = xCost.getCurrentCostPrice();
            }
        } else if (to.equals(TO_PriceListLimit)) {
            retValue = this.getPrice(cost);
        } else if (to.equals(TO_StandardCost)) {
            retValue = cost.getCurrentCostPrice();
        }
        return retValue;
    }

    private MCostElement getCostElement(String CostingMethod) {
        MCostElement ce = this.m_ces.get(CostingMethod);
        if (ce == null) {
            ce = MCostElement.getMaterialCostElement((Properties)this.getCtx(), (String)CostingMethod);
            this.m_ces.put(CostingMethod, ce);
        }
        return ce;
    }

    private BigDecimal getPrice(MCost cost) {
        BigDecimal retValue;
        block6: {
            retValue = null;
            String sql = "SELECT PriceLimit FROM M_ProductPrice WHERE M_Product_ID=? AND M_PriceList_Version_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, cost.getM_Product_ID());
                    pstmt.setInt(2, this.p_M_PriceList_Version_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = rs.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }
}

