/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class InOutGenerateRMA
extends SvrProcess {
    private boolean p_Selection = false;
    private int p_M_Warehouse_ID = 0;
    private String p_docAction = "CO";
    private int m_created = 0;
    private Timestamp m_movementDate = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Warehouse_ID")) {
                    this.p_M_Warehouse_ID = para[i].getParameterAsInt();
                } else if (name.equals("Selection")) {
                    this.p_Selection = "Y".equals(para[i].getParameter());
                } else if (name.equals("DocAction")) {
                    this.p_docAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.m_movementDate = Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date");
        if (this.m_movementDate == null) {
            this.m_movementDate = new Timestamp(System.currentTimeMillis());
        }
    }

    protected String doIt() throws Exception {
        block7: {
            if (!this.p_Selection) {
                throw new IllegalStateException("Shipments can only be generated from selection");
            }
            String sql = "SELECT rma.M_RMA_ID FROM M_RMA rma, T_Selection WHERE rma.DocStatus='CO' AND rma.IsSOTrx='N' AND rma.AD_Client_ID=? AND rma.M_RMA_ID = T_Selection.T_Selection_ID AND T_Selection.AD_PInstance_ID=? ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
                    pstmt.setInt(2, this.getAD_PInstance_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.generateShipment(rs.getInt(1));
                    }
                }
                catch (Exception ex) {
                    this.log.log(Level.SEVERE, sql, (Throwable)ex);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        StringBuilder msgreturn = new StringBuilder("@Created@ = ").append(this.m_created);
        return msgreturn.toString();
    }

    private int getShipmentDocTypeId(int M_RMA_ID) {
        String docTypeSQl = "SELECT dt.C_DocTypeShipment_ID FROM C_DocType dt INNER JOIN M_RMA rma ON dt.C_DocType_ID=rma.C_DocType_ID WHERE rma.M_RMA_ID=?";
        int docTypeId = DB.getSQLValue(null, (String)docTypeSQl, (int)M_RMA_ID);
        return docTypeId;
    }

    private MInOut createShipment(MRMA rma) {
        int docTypeId = this.getShipmentDocTypeId(rma.get_ID());
        if (docTypeId == -1) {
            throw new IllegalStateException("Could not get invoice document type for Vendor RMA");
        }
        MInOut originalReceipt = rma.getShipment();
        MInOut shipment = new MInOut(this.getCtx(), 0, this.get_TrxName());
        shipment.setM_RMA_ID(rma.get_ID());
        shipment.setAD_Org_ID(rma.getAD_Org_ID());
        shipment.setAD_OrgTrx_ID(originalReceipt.getAD_OrgTrx_ID());
        shipment.setDescription(rma.getDescription());
        shipment.setC_BPartner_ID(rma.getC_BPartner_ID());
        shipment.setC_BPartner_Location_ID(originalReceipt.getC_BPartner_Location_ID());
        shipment.setIsSOTrx(rma.isSOTrx());
        shipment.setC_DocType_ID(docTypeId);
        shipment.setM_Warehouse_ID(originalReceipt.getM_Warehouse_ID());
        shipment.setMovementType("V-");
        shipment.setC_Project_ID(originalReceipt.getC_Project_ID());
        shipment.setC_Campaign_ID(originalReceipt.getC_Campaign_ID());
        shipment.setC_Activity_ID(originalReceipt.getC_Activity_ID());
        shipment.setUser1_ID(originalReceipt.getUser1_ID());
        shipment.setUser2_ID(originalReceipt.getUser2_ID());
        if (!shipment.save()) {
            throw new IllegalStateException("Could not create Shipment");
        }
        return shipment;
    }

    private MInOutLine[] createShipmentLines(MRMA rma, MInOut shipment) {
        MRMALine[] rmaLines;
        ArrayList<MInOutLine> shipLineList = new ArrayList<MInOutLine>();
        MRMALine[] mRMALineArray = rmaLines = rma.getLines(true);
        int n = rmaLines.length;
        int n2 = 0;
        while (n2 < n) {
            MRMALine rmaLine = mRMALineArray[n2];
            if (rmaLine.getM_InOutLine_ID() != 0 || rmaLine.getC_Charge_ID() != 0 || rmaLine.getM_Product_ID() != 0) {
                MInOutLine shipLine = new MInOutLine(shipment);
                shipLine.setM_RMALine_ID(rmaLine.get_ID());
                shipLine.setLine(rmaLine.getLine());
                shipLine.setDescription(rmaLine.getDescription());
                if (rmaLine.getC_Charge_ID() != 0) {
                    shipLine.setC_Charge_ID(rmaLine.getC_Charge_ID());
                    shipLine.set_ValueNoCheck("M_Product_ID", null);
                    shipLine.set_ValueNoCheck("M_AttributeSetInstance_ID", null);
                    shipLine.set_ValueNoCheck("M_Locator_ID", null);
                } else {
                    shipLine.setM_Product_ID(rmaLine.getM_Product_ID());
                    shipLine.setM_AttributeSetInstance_ID(rmaLine.getM_AttributeSetInstance_ID());
                    shipLine.setM_Locator_ID(rmaLine.getM_Locator_ID());
                }
                shipLine.setC_UOM_ID(rmaLine.getC_UOM_ID());
                shipLine.setQty(rmaLine.getQty());
                shipLine.setC_Project_ID(rmaLine.getC_Project_ID());
                shipLine.setC_Campaign_ID(rmaLine.getC_Campaign_ID());
                shipLine.setC_Activity_ID(rmaLine.getC_Activity_ID());
                shipLine.setC_ProjectPhase_ID(rmaLine.getC_ProjectPhase_ID());
                shipLine.setC_ProjectTask_ID(rmaLine.getC_ProjectTask_ID());
                shipLine.setUser1_ID(rmaLine.getUser1_ID());
                shipLine.setUser2_ID(rmaLine.getUser2_ID());
                shipLine.saveEx();
                shipLineList.add(shipLine);
                MInvoiceLine invoiceLine = (MInvoiceLine)new Query(shipment.getCtx(), "C_InvoiceLine", "M_RMALine_ID=?", shipment.get_TrxName()).setParameters(new Object[]{rmaLine.getM_RMALine_ID()}).firstOnly();
                if (invoiceLine != null) {
                    invoiceLine.setM_InOutLine_ID(shipLine.getM_InOutLine_ID());
                    invoiceLine.saveEx();
                }
            }
            ++n2;
        }
        MInOutLine[] shipLines = new MInOutLine[shipLineList.size()];
        shipLineList.toArray(shipLines);
        return shipLines;
    }

    private void generateShipment(int M_RMA_ID) {
        MRMA rma = new MRMA(this.getCtx(), M_RMA_ID, this.get_TrxName());
        this.statusUpdate(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Processing")) + " " + rma.getDocumentInfo());
        MInOut shipment = this.createShipment(rma);
        MInOutLine[] shipmentLines = this.createShipmentLines(rma, shipment);
        if (shipmentLines.length == 0) {
            StringBuilder msglog = new StringBuilder("No shipment lines created: M_RMA_ID=").append(M_RMA_ID).append(", M_InOut_ID=").append(shipment.get_ID());
            this.log.log(Level.WARNING, msglog.toString());
        }
        StringBuffer processMsg = new StringBuffer().append(shipment.getDocumentNo());
        if (!shipment.processIt(this.p_docAction)) {
            processMsg.append(" (NOT Processed)");
            StringBuilder msglog = new StringBuilder("Shipment Processing failed: ").append(shipment).append(" - ").append(shipment.getProcessMsg());
            this.log.warning(msglog.toString());
            throw new IllegalStateException("Shipment Processing failed: " + shipment + " - " + shipment.getProcessMsg());
        }
        if (!shipment.save()) {
            throw new IllegalStateException("Could not update shipment");
        }
        this.addLog(shipment.getM_InOut_ID(), shipment.getMovementDate(), null, processMsg.toString(), shipment.get_Table_ID(), shipment.getM_InOut_ID());
        ++this.m_created;
    }
}

