/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.sf.jasperreports.components.BaseElementHtmlHandler;
import net.sf.jasperreports.components.sort.FieldFilter;
import net.sf.jasperreports.components.sort.FilterTypeBooleanOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypeDateOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypeNumericOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypeTextOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypesEnum;
import net.sf.jasperreports.components.sort.SortElementUtils;
import net.sf.jasperreports.components.sort.actions.FilterAction;
import net.sf.jasperreports.components.sort.actions.SortAction;
import net.sf.jasperreports.components.sort.actions.SortData;
import net.sf.jasperreports.engine.CompositeDatasetFilter;
import net.sf.jasperreports.engine.DatasetFilter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBasePrintHyperlink;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.engine.export.JRXhtmlExporter;
import net.sf.jasperreports.engine.type.JREnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.MessageProvider;
import net.sf.jasperreports.engine.util.MessageUtil;
import net.sf.jasperreports.repo.JasperDesignCache;
import net.sf.jasperreports.web.commands.CommandTarget;
import net.sf.jasperreports.web.util.JacksonUtil;
import net.sf.jasperreports.web.util.VelocityUtil;
import net.sf.jasperreports.web.util.WebUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;

public class SortElementHtmlHandler
extends BaseElementHtmlHandler {
    private static final Log log = LogFactory.getLog(SortElementHtmlHandler.class);
    private static final String RESOURCE_SORT_JS = "net/sf/jasperreports/components/sort/resources/sort.js";
    private static final String RESOURCE_HEADERTOOLBAR_CSS = "net/sf/jasperreports/components/headertoolbar/resources/jasperreports-tableHeaderToolbar.vm.css";
    private static final String CSS_FILTER_DEFAULT = "filterBtnDefault";
    private static final String CSS_FILTER_WRONG = "filterBtnWrong";
    private static final String CSS_SORT_DEFAULT_ASC = "sortAscBtnDefault";
    private static final String CSS_SORT_DEFAULT_DESC = "sortDescBtnDefault";
    private static final String SORT_ELEMENT_HTML_TEMPLATE = "net/sf/jasperreports/components/sort/resources/SortElementHtmlTemplate.vm";
    protected static final String HTML_VERTICAL_ALIGN_TOP = "top";
    protected static final String CSS_TEXT_ALIGN_LEFT = "left";
    protected static final String SORT_SYMBOL_ASCENDING = "&#9650;";
    protected static final String SORT_SYMBOL_DESCENDING = "&#9660;";
    protected static final String FILTER_SYMBOL_ACTIVE = "Active";
    protected static final String FILTER_SYMBOL_INACTIVE = "Inactive";

    @Override
    public String getHtmlFragment(JRHtmlExporterContext context, JRGenericPrintElement element) {
        String htmlFragment = null;
        ReportContext reportContext = context.getExporter().getReportContext();
        if (reportContext != null) {
            FilterTypesEnum filterType;
            Color sortHandlerColor;
            String sortColumnName = (String)element.getParameterValue("sortColumnName");
            String sortColumnType = (String)element.getParameterValue("sortColumnType");
            String sortHandlerVAlign = (String)element.getParameterValue("sortHandlerVerticalAlign");
            String sortHandlerHAlign = (String)element.getParameterValue("sortHandlerHorizontalAlign");
            String sortDatasetName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.jr.dsr");
            JRBaseFont sortHandlerFont = (JRBaseFont)element.getParameterValue("sortHandlerFont");
            if (sortHandlerFont == null) {
                sortHandlerFont = new JRBaseFont(element);
            }
            if ((sortHandlerColor = (Color)element.getParameterValue("sortHandlerColor")) == null) {
                sortHandlerColor = Color.WHITE;
            }
            if ((filterType = FilterTypesEnum.getByName(element.getPropertiesMap().getProperty("net.sf.jasperreports.export.jr.fltrTp"))) == null) {
                return null;
            }
            String filterPattern = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.jr.fltrPtrn");
            Locale locale = (Locale)reportContext.getParameterValue("REPORT_LOCALE");
            if (log.isDebugEnabled()) {
                log.debug((Object)("report locale: " + locale));
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            Map<String, String> translatedOperators = null;
            boolean isBooleanFilterType = false;
            switch (filterType) {
                case NUMERIC: {
                    translatedOperators = this.getTranslatedOperators(context.getJasperReportsContext(), FilterTypeNumericOperatorsEnum.class.getName(), FilterTypeNumericOperatorsEnum.values(), locale);
                    break;
                }
                case DATE: {
                    translatedOperators = this.getTranslatedOperators(context.getJasperReportsContext(), FilterTypeDateOperatorsEnum.class.getName(), FilterTypeDateOperatorsEnum.values(), locale);
                    break;
                }
                case TEXT: {
                    translatedOperators = this.getTranslatedOperators(context.getJasperReportsContext(), FilterTypeTextOperatorsEnum.class.getName(), FilterTypeTextOperatorsEnum.values(), locale);
                    break;
                }
                case BOOLEAN: {
                    translatedOperators = this.getTranslatedOperators(context.getJasperReportsContext(), FilterTypeBooleanOperatorsEnum.class.getName(), FilterTypeBooleanOperatorsEnum.values(), locale);
                    isBooleanFilterType = true;
                }
            }
            VelocityContext velocityContext = new VelocityContext();
            WebUtil webUtil = WebUtil.getInstance(context.getJasperReportsContext());
            String webResourcesBasePath = webUtil.getResourcesBasePath();
            velocityContext.put("actionBaseUrl", (Object)this.getActionBaseUrl(context));
            velocityContext.put("actionBaseData", (Object)this.getActionBaseJsonData(context));
            velocityContext.put("resourceSortJs", (Object)webUtil.getResourcePath(webResourcesBasePath, RESOURCE_SORT_JS));
            velocityContext.put("jasperreports_tableHeaderToolbar_css", (Object)webUtil.getResourcePath(webResourcesBasePath, RESOURCE_HEADERTOOLBAR_CSS, true));
            if (context.getExporter() instanceof JRXhtmlExporter) {
                velocityContext.put("elementX", (Object)((JRXhtmlExporter)context.getExporter()).toSizeUnit(element.getX()));
                velocityContext.put("elementY", (Object)((JRXhtmlExporter)context.getExporter()).toSizeUnit(element.getY()));
            }
            velocityContext.put("elementWidth", (Object)element.getWidth());
            velocityContext.put("elementHeight", (Object)element.getHeight());
            velocityContext.put("sortLinkClass", (Object)sortDatasetName);
            velocityContext.put("sortHandlerHAlign", (Object)(sortHandlerHAlign != null ? sortHandlerHAlign : CSS_TEXT_ALIGN_LEFT));
            velocityContext.put("sortHandlerVAlign", (Object)(sortHandlerVAlign != null ? sortHandlerVAlign : HTML_VERTICAL_ALIGN_TOP));
            velocityContext.put("sortHandlerColor", (Object)JRColorUtil.getColorHexa(sortHandlerColor));
            velocityContext.put("sortHandlerFontSize", (Object)sortHandlerFont.getFontSize());
            velocityContext.put("isFilterable", (Object)(filterType != null ? 1 : 0));
            velocityContext.put("filterDivId", (Object)("filter_" + sortDatasetName + "_" + sortColumnName));
            String reportUriParamName = JRPropertiesUtil.getInstance(context.getJasperReportsContext()).getProperty("net.sf.jasperreports.web.request.parameter.report.uri");
            velocityContext.put("filterReportUriParamName", (Object)reportUriParamName);
            velocityContext.put("filterReportUriParamValue", reportContext.getParameterValue(reportUriParamName));
            velocityContext.put("filterColumnName", (Object)sortColumnName);
            velocityContext.put("filterTableNameValue", (Object)sortDatasetName);
            velocityContext.put("filterTypeParamNameValue", (Object)filterType.getName());
            velocityContext.put("filterPatternParamValue", (Object)filterPattern);
            velocityContext.put("filterTypeValuesMap", translatedOperators);
            velocityContext.put("isBooleanFilterType", (Object)isBooleanFilterType);
            if (element.getModeValue() == ModeEnum.OPAQUE) {
                velocityContext.put("backgroundColor", (Object)JRColorUtil.getColorHexa(element.getBackcolor()));
            }
            String sortField = this.getCurrentSortField(context.getJasperReportsContext(), reportContext, element.getUUID().toString(), sortDatasetName, sortColumnName, sortColumnType);
            SortData sortData = null;
            if (sortField == null) {
                sortData = new SortData(element.getUUID().toString(), sortColumnName, sortColumnType, "Asc");
                velocityContext.put("isSorted", (Object)false);
            } else {
                String[] sortActionData = SortElementUtils.extractColumnInfo(sortField);
                boolean isAscending = "Asc".equals(sortActionData[2]);
                String sortOrder = !isAscending ? "None" : "Dsc";
                sortData = new SortData(element.getUUID().toString(), sortColumnName, sortColumnType, sortOrder);
                velocityContext.put("isSorted", (Object)true);
                velocityContext.put("sortSymbolResource", (Object)(isAscending ? CSS_SORT_DEFAULT_ASC : CSS_SORT_DEFAULT_DESC));
            }
            velocityContext.put("tableUuid", (Object)element.getUUID().toString());
            velocityContext.put("actionData", (Object)this.getActionData(context, sortData));
            String filterValueStart = "";
            String filterValueEnd = "";
            String filterTypeOperatorValue = "";
            String filterActiveInactive = FILTER_SYMBOL_INACTIVE;
            boolean isFiltered = false;
            boolean enableFilterEndParameter = false;
            List<Object> fieldFilters = new ArrayList();
            String filterSymbolImageResource = CSS_FILTER_DEFAULT;
            fieldFilters = this.getExistingFiltersForField(context.getJasperReportsContext(), reportContext, element.getUUID().toString(), sortColumnName);
            if (fieldFilters.size() > 0) {
                FieldFilter ff = (FieldFilter)fieldFilters.get(0);
                if (ff.getFilterValueStart() != null) {
                    filterValueStart = ff.getFilterValueStart();
                }
                if (ff.getFilterValueEnd() != null) {
                    filterValueEnd = ff.getFilterValueEnd();
                }
                filterTypeOperatorValue = ff.getFilterTypeOperator();
                filterActiveInactive = FILTER_SYMBOL_ACTIVE;
                isFiltered = true;
                if (filterTypeOperatorValue != null && filterTypeOperatorValue.toLowerCase().contains("between")) {
                    enableFilterEndParameter = true;
                }
                if (ff.getIsValid() != null && !ff.getIsValid().booleanValue()) {
                    filterSymbolImageResource = CSS_FILTER_WRONG;
                }
            }
            velocityContext.put("isFiltered", (Object)isFiltered);
            velocityContext.put("filterSymbolImageResource", (Object)filterSymbolImageResource);
            velocityContext.put("filterToRemoveParamName", (Object)"jr.rmvFltr");
            velocityContext.put("filterToRemoveParamvalue", (Object)sortColumnName);
            String filtersJsonString = JacksonUtil.getInstance(context.getJasperReportsContext()).getEscapedJsonString(fieldFilters);
            if (log.isDebugEnabled()) {
                log.debug((Object)("filtersJsonString: " + filtersJsonString));
            }
            velocityContext.put("filtersJsonString", (Object)filtersJsonString);
            velocityContext.put("filterValueStartParamValue", (Object)filterValueStart);
            velocityContext.put("filterValueEndParamValue", (Object)filterValueEnd);
            velocityContext.put("filterTypeOperatorParamValue", (Object)filterTypeOperatorValue);
            velocityContext.put("filterActiveInactive", (Object)filterActiveInactive);
            velocityContext.put("isField", (Object)SortFieldTypeEnum.FIELD.equals(SortFieldTypeEnum.getByName(sortColumnType)));
            velocityContext.put("enableFilterEndParameter", (Object)enableFilterEndParameter);
            htmlFragment = VelocityUtil.processTemplate(SORT_ELEMENT_HTML_TEMPLATE, velocityContext);
        }
        return htmlFragment;
    }

    private String getCurrentSortField(JasperReportsContext jasperReportsContext, ReportContext reportContext, String uuid, String sortDatasetName, String sortColumnName, String sortColumnType) {
        JasperDesignCache cache = JasperDesignCache.getInstance(jasperReportsContext, reportContext);
        SortAction action = new SortAction();
        action.init(jasperReportsContext, reportContext);
        CommandTarget target = action.getCommandTarget(UUID.fromString(uuid));
        if (target != null) {
            JasperDesign jasperDesign = cache.getJasperDesign(target.getUri());
            JRDesignDataset dataset = (JRDesignDataset)jasperDesign.getMainDataset();
            List<JRSortField> existingFields = dataset.getSortFieldsList();
            String sortField = null;
            if (existingFields != null && existingFields.size() > 0) {
                for (JRSortField field : existingFields) {
                    if (!field.getName().equals(sortColumnName) || !field.getType().getName().equals(sortColumnType)) continue;
                    sortField = sortColumnName + ":" + sortColumnType + ":";
                    switch (field.getOrderValue()) {
                        case ASCENDING: {
                            sortField = sortField + "Asc";
                            break;
                        }
                        case DESCENDING: {
                            sortField = sortField + "Dsc";
                        }
                    }
                    break;
                }
            }
            return sortField;
        }
        return null;
    }

    @Override
    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }

    private Map<String, String> getTranslatedOperators(JasperReportsContext jasperReportsContext, String bundleName, JREnum[] operators, Locale locale) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        MessageProvider messageProvider = MessageUtil.getInstance(jasperReportsContext).getMessageProvider(bundleName);
        for (JREnum operator : operators) {
            String key = bundleName + "." + ((Enum)((Object)operator)).name();
            result.put(((Enum)((Object)operator)).name(), messageProvider.getMessage(key, null, locale));
        }
        return result;
    }

    public static void getFieldFilters(DatasetFilter existingFilter, List<FieldFilter> fieldFilters, String fieldName) {
        if (existingFilter instanceof FieldFilter) {
            if (fieldName == null || fieldName != null && ((FieldFilter)existingFilter).getField().equals(fieldName)) {
                fieldFilters.add((FieldFilter)existingFilter);
            }
        } else if (existingFilter instanceof CompositeDatasetFilter) {
            for (DatasetFilter datasetFilter : ((CompositeDatasetFilter)existingFilter).getFilters()) {
                SortElementHtmlHandler.getFieldFilters(datasetFilter, fieldFilters, fieldName);
            }
        }
    }

    private String getActionBaseUrl(JRHtmlExporterContext context) {
        JRBasePrintHyperlink hyperlink = new JRBasePrintHyperlink();
        hyperlink.setLinkType("ReportInteraction");
        return context.getHyperlinkURL(hyperlink);
    }

    private String getActionBaseJsonData(JRHtmlExporterContext context) {
        ReportContext reportContext = context.getExporter().getReportContext();
        HashMap<String, Object> actionParams = new HashMap<String, Object>();
        actionParams.put("jr.ctxid", reportContext.getId());
        String runReportParamName = JRPropertiesUtil.getInstance(context.getJasperReportsContext()).getProperty("net.sf.jasperreports.web.request.parameter.run.report");
        actionParams.put(runReportParamName, true);
        return JacksonUtil.getInstance(context.getJasperReportsContext()).getJsonString(actionParams);
    }

    private String getActionData(JRHtmlExporterContext context, SortData sortData) {
        return "{\"actionName\":\"sortica\",\"sortData\":" + JacksonUtil.getInstance(context.getJasperReportsContext()).getJsonString(sortData) + "}";
    }

    private List<FieldFilter> getExistingFiltersForField(JasperReportsContext jasperReportsContext, ReportContext reportContext, String uuid, String filterFieldName) {
        JasperDesignCache cache = JasperDesignCache.getInstance(jasperReportsContext, reportContext);
        FilterAction action = new FilterAction();
        action.init(jasperReportsContext, reportContext);
        CommandTarget target = action.getCommandTarget(UUID.fromString(uuid));
        ArrayList<FieldFilter> result = new ArrayList<FieldFilter>();
        if (target != null) {
            List<FieldFilter> existingFilters;
            JasperDesign jasperDesign = cache.getJasperDesign(target.getUri());
            JRDesignDataset dataset = (JRDesignDataset)jasperDesign.getMainDataset();
            String serializedFilters = "[]";
            JRPropertiesMap propertiesMap = dataset.getPropertiesMap();
            if (propertiesMap.getProperty("net.sf.jasperreports.filters") != null) {
                serializedFilters = propertiesMap.getProperty("net.sf.jasperreports.filters");
            }
            if ((existingFilters = JacksonUtil.getInstance(jasperReportsContext).loadList(serializedFilters, FieldFilter.class)).size() > 0) {
                for (DatasetFilter datasetFilter : existingFilters) {
                    if (!((FieldFilter)datasetFilter).getField().equals(filterFieldName)) continue;
                    result.add((FieldFilter)datasetFilter);
                    break;
                }
            }
        }
        return result;
    }
}

