/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.dao;

import com.clustercontrol.accesscontrol.util.LdapConnectionManager;
import com.clustercontrol.repository.dao.DeviceInfoDAO;
import com.clustercontrol.repository.ejb.entity.DeviceInfoBean;
import com.clustercontrol.repository.ejb.entity.DeviceInfoPK;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeviceInfoDAOImpl
implements DeviceInfoDAO {
    protected static Log m_log = LogFactory.getLog(DeviceInfoDAOImpl.class);
    protected static final String OBJECTCLASS = "objectClass";
    protected static final String BASE_DN = "ou=facility";
    protected static final String OBJECT_CLASS_DEVICE_INFO = "ccDeviceInfo";

    public void init() {
    }

    public void load(DeviceInfoPK pk, DeviceInfoBean ejb) throws EJBException {
        DirContext ctx = null;
        try {
            this.clearBean(ejb);
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            Attributes attrs = ctx.getAttributes(pk.getDn());
            ejb.setDn(pk.getDn());
            ejb.setCn((String)attrs.get("cn").get(0));
            if (attrs.get("ccSnmpOID") != null) {
                ejb.setSnmpOID((String)attrs.get("ccSnmpOID").get(0));
            }
            if (attrs.get("ccDeviceIndex") != null) {
                ejb.setDeviceIndex(new Integer((String)attrs.get("ccDeviceIndex").get(0)));
            }
            if (attrs.get("ccDeviceType") != null) {
                ejb.setDeviceType((String)attrs.get("ccDeviceType").get(0));
            }
            if (attrs.get("description") != null) {
                ejb.setDescription((String)attrs.get("description").get(0));
            }
            String dn = ejb.getDn();
            dn = dn.replaceFirst("[\\s\\w=]*,", "");
            dn = dn.replaceFirst(",[\\s\\w=]*", "");
            dn = dn.replaceFirst("ccFacilityId=", "");
            ejb.setFacilityId(dn);
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            throw new EJBException((Exception)ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
    }

    public void store(DeviceInfoBean ejb) throws EJBException {
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            Attributes attrs = ctx.getAttributes(ejb.getDn());
            BasicAttributes addAttrs = new BasicAttributes();
            BasicAttributes replaceAttrs = new BasicAttributes();
            BasicAttributes removeAttrs = new BasicAttributes();
            if (attrs.get("description") == null && ejb.getDescription() != null) {
                addAttrs.put("description", ejb.getDescription());
            } else if (attrs.get("description") != null && ejb.getDescription() == null) {
                removeAttrs.put("description", null);
            } else if (attrs.get("description") != null && ejb.getDescription() != null) {
                replaceAttrs.put("description", ejb.getDescription());
            }
            if (attrs.get("ccSnmpOID") == null && ejb.getSnmpOID() != null) {
                addAttrs.put("ccSnmpOID", ejb.getSnmpOID());
            } else if (attrs.get("ccSnmpOID") != null && ejb.getSnmpOID() == null) {
                removeAttrs.put("ccSnmpOID", null);
            } else if (attrs.get("ccSnmpOID") != null && ejb.getSnmpOID() != null) {
                replaceAttrs.put("ccSnmpOID", ejb.getSnmpOID());
            }
            if (attrs.get("ccDeviceIndex") == null && ejb.getDeviceIndex() != null) {
                addAttrs.put("ccDeviceIndex", ejb.getDeviceIndex().toString());
            } else if (attrs.get("ccDeviceIndex") != null && ejb.getDeviceIndex() == null) {
                removeAttrs.put("ccDeviceIndex", null);
            } else if (attrs.get("ccDeviceIndex") != null && ejb.getDeviceIndex() != null) {
                replaceAttrs.put("ccDeviceIndex", ejb.getDeviceIndex().toString());
            }
            if (attrs.get("ccDeviceType") == null && ejb.getDeviceType() != null) {
                addAttrs.put("ccDeviceType", ejb.getDeviceType());
            } else if (attrs.get("ccDeviceType") != null && ejb.getDeviceType() == null) {
                removeAttrs.put("ccDeviceType", null);
            } else if (attrs.get("ccDeviceType") != null && ejb.getDeviceType() != null) {
                replaceAttrs.put("ccDeviceType", ejb.getDeviceType());
            }
            ctx.modifyAttributes(ejb.getDn(), 1, (Attributes)addAttrs);
            ctx.modifyAttributes(ejb.getDn(), 2, (Attributes)replaceAttrs);
            ctx.modifyAttributes(ejb.getDn(), 3, (Attributes)removeAttrs);
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            throw new EJBException((Exception)ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
    }

    public void remove(DeviceInfoPK pk) throws RemoveException, EJBException {
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            ctx.destroySubcontext(pk.getDn());
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{pk.getDn()};
            apllog.put("SYS", "004", args);
            throw new EJBException((Exception)ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
    }

    public DeviceInfoPK create(DeviceInfoBean ejb) throws CreateException, EJBException {
        DeviceInfoPK pk = null;
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            BasicAttributes attrs = new BasicAttributes();
            attrs.put(OBJECTCLASS, OBJECT_CLASS_DEVICE_INFO);
            attrs.put("cn", ejb.getCn());
            StringBuffer dn = new StringBuffer();
            dn.append("cn");
            dn.append("=");
            dn.append(ejb.getCn());
            dn.append(",");
            dn.append("ccFacilityId");
            dn.append("=");
            dn.append(ejb.getFacilityId());
            dn.append(",");
            dn.append(BASE_DN);
            ejb.setDn(dn.toString());
            ctx.createSubcontext(ejb.getDn(), (Attributes)attrs);
            pk = new DeviceInfoPK(ejb.getDn());
        }
        catch (NamingException ex) {
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{ejb.getDn()};
            apllog.put("SYS", "003", args);
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            } else if (ex instanceof NameAlreadyBoundException) {
                throw new DuplicateKeyException(ex.getMessage());
            }
            throw new CreateException(ex.getMessage());
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findAll() throws FinderException {
        ArrayList<DeviceInfoPK> ret = new ArrayList<DeviceInfoPK>();
        m_log.debug((Object)"findAll()");
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_DEVICE_INFO);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            results = ctx.search(BASE_DN, search.toString(), constraints);
            if (results == null) {
                m_log.debug((Object)"findAll() : No Search Result");
                ArrayList<DeviceInfoPK> arrayList = ret;
                return arrayList;
            }
            while (results.hasMoreElements()) {
                SearchResult aResult = (SearchResult)results.nextElement();
                DeviceInfoPK pk = new DeviceInfoPK(aResult.getName() + "," + BASE_DN);
                ret.add(pk);
            }
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findAll() : " + e.getMessage()));
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return ret;
    }

    public DeviceInfoPK findByPrimaryKey(DeviceInfoPK pk) throws FinderException {
        Context ctx = null;
        try {
            m_log.debug((Object)("findByPrimaryKey() : dn = " + pk.getDn()));
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            Attributes attrs = ctx.getAttributes(pk.getDn());
            DeviceInfoPK deviceInfoPK = pk;
            return deviceInfoPK;
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findByPrimaryKey() : " + ex.getMessage()));
            throw new FinderException("dn=" + pk.getDn() + " not found.");
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findByFacilityId(String facilityId) throws FinderException {
        ArrayList<DeviceInfoPK> ret = new ArrayList<DeviceInfoPK>();
        m_log.debug((Object)("findByFacilityId() : FacilityId = " + facilityId));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer baseDn = new StringBuffer();
        baseDn.append("ccFacilityId");
        baseDn.append("=");
        baseDn.append(facilityId);
        baseDn.append(",");
        baseDn.append(BASE_DN);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_DEVICE_INFO);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            results = ctx.search(baseDn.toString(), search.toString(), constraints);
            if (results == null) {
                m_log.debug((Object)("findByFacilityId() : No Search Result : FacilityId = " + facilityId));
                ArrayList<DeviceInfoPK> arrayList = ret;
                return arrayList;
            }
            while (results.hasMoreElements()) {
                SearchResult aResult = (SearchResult)results.nextElement();
                DeviceInfoPK pk = new DeviceInfoPK(aResult.getName() + "," + baseDn.toString());
                ret.add(pk);
            }
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findByFacilityId() : " + e.getMessage()));
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return ret;
    }

    public DeviceInfoPK findByFacilityIdAndName(String facilityId, String name) throws FinderException {
        DeviceInfoPK pk;
        block13: {
            m_log.debug((Object)("findByFacilityIdAndName() : FacilityId = " + facilityId + ", FacilityName = " + name));
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            StringBuffer baseDn = new StringBuffer();
            baseDn.append("ccFacilityId");
            baseDn.append("=");
            baseDn.append(facilityId);
            baseDn.append(",");
            baseDn.append(BASE_DN);
            StringBuffer search = new StringBuffer();
            search.append("(&(");
            search.append(OBJECTCLASS);
            search.append("=");
            search.append(OBJECT_CLASS_DEVICE_INFO);
            search.append(")(");
            search.append("cn");
            search.append("=");
            search.append(name);
            search.append("))");
            NamingEnumeration<SearchResult> results = null;
            DirContext ctx = null;
            pk = null;
            try {
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                results = ctx.search(baseDn.toString(), search.toString(), constraints);
                if (results.hasMoreElements()) {
                    SearchResult aResult = (SearchResult)results.nextElement();
                    pk = new DeviceInfoPK(aResult.getName() + "," + baseDn.toString());
                    break block13;
                }
                throw new FinderException("FacilityId = " + facilityId + ", FacilityName = " + name + " not found.");
            }
            catch (NamingException ex) {
                if (ex instanceof CommunicationException) {
                    LdapConnectionManager.getConnectionManager().setDirContext(null);
                }
                m_log.debug((Object)("findByFacilityIdAndName() : " + ex.getMessage()));
                throw new FinderException("FacilityId = " + facilityId + ", FacilityName = " + name + " not found.");
            }
            finally {
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {}
            }
        }
        return pk;
    }

    protected void clearBean(DeviceInfoBean ejb) {
        ejb.setCn(null);
        ejb.setDescription(null);
        ejb.setDeviceIndex(null);
        ejb.setDeviceType(null);
        ejb.setDn(null);
        ejb.setFacilityId(null);
        ejb.setSnmpOID(null);
    }
}

