/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;

public abstract class QueuedSemaphore
extends Semaphore {
    protected final WaitQueue wq_;

    QueuedSemaphore(WaitQueue q, long initialPermits) {
        super(initialPermits);
        this.wq_ = q;
    }

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.precheck()) {
            return;
        }
        WaitQueue.WaitNode w = new WaitQueue.WaitNode();
        w.doWait(this);
    }

    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.precheck()) {
            return true;
        }
        if (msecs <= 0L) {
            return false;
        }
        WaitQueue.WaitNode w = new WaitQueue.WaitNode();
        return w.doTimedWait(this, msecs);
    }

    protected synchronized boolean precheck() {
        boolean pass;
        boolean bl = pass = this.permits_ > 0L;
        if (pass) {
            --this.permits_;
        }
        return pass;
    }

    protected synchronized boolean recheck(WaitQueue.WaitNode w) {
        boolean pass;
        boolean bl = pass = this.permits_ > 0L;
        if (pass) {
            --this.permits_;
        } else {
            this.wq_.insert(w);
        }
        return pass;
    }

    protected synchronized WaitQueue.WaitNode getSignallee() {
        WaitQueue.WaitNode w = this.wq_.extract();
        if (w == null) {
            ++this.permits_;
        }
        return w;
    }

    public void release() {
        WaitQueue.WaitNode w;
        do {
            if ((w = this.getSignallee()) != null) continue;
            return;
        } while (!w.signal());
    }

    public void release(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Negative argument");
        }
        for (long i = 0L; i < n; ++i) {
            this.release();
        }
    }

    protected static abstract class WaitQueue {
        protected WaitQueue() {
        }

        protected abstract void insert(WaitNode var1);

        protected abstract WaitNode extract();

        protected static class WaitNode {
            boolean waiting = true;
            WaitNode next = null;

            protected WaitNode() {
            }

            protected synchronized boolean signal() {
                boolean signalled = this.waiting;
                if (signalled) {
                    this.waiting = false;
                    this.notify();
                }
                return signalled;
            }

            protected synchronized boolean doTimedWait(QueuedSemaphore sem, long msecs) throws InterruptedException {
                if (sem.recheck(this) || !this.waiting) {
                    return true;
                }
                if (msecs <= 0L) {
                    this.waiting = false;
                    return false;
                }
                long waitTime = msecs;
                long start = System.currentTimeMillis();
                try {
                    do {
                        this.wait(waitTime);
                        if (this.waiting) continue;
                        return true;
                    } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                    this.waiting = false;
                    return false;
                }
                catch (InterruptedException ex) {
                    if (this.waiting) {
                        this.waiting = false;
                        throw ex;
                    }
                    Thread.currentThread().interrupt();
                    return true;
                }
            }

            protected synchronized void doWait(QueuedSemaphore sem) throws InterruptedException {
                if (!sem.recheck(this)) {
                    try {
                        while (this.waiting) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException ex) {
                        if (this.waiting) {
                            this.waiting = false;
                            throw ex;
                        }
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        }
    }
}

