/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.TextMeasurer;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public abstract class JRFillTextElement
extends JRFillElement
implements JRTextElement {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$fill$JRFillTextElement == null ? (class$net$sf$jasperreports$engine$fill$JRFillTextElement = JRFillTextElement.class$("net.sf.jasperreports.engine.fill.JRFillTextElement")) : class$net$sf$jasperreports$engine$fill$JRFillTextElement));
    private boolean isLeftToRight = true;
    private TextMeasurer textMeasurer = null;
    private float lineSpacingFactor = 0.0f;
    private float leadingOffset = 0.0f;
    private float textHeight = 0.0f;
    private int textStart = 0;
    private int textEnd = 0;
    private String rawText = null;
    private JRStyledText styledText = null;
    private Map styledTextAttributesMap = new HashMap();
    protected TextChopper textChopper = null;
    protected final JRReportFont reportFont;
    private static TextChopper simpleTextChopper = new TextChopper(){

        public String chop(JRFillTextElement textElement, int startIndex, int endIndex) {
            return textElement.getStyledText().getText().substring(startIndex, endIndex);
        }
    };
    private static TextChopper styledTextChopper = new TextChopper(){

        public String chop(JRFillTextElement textElement, int startIndex, int endIndex) {
            return textElement.filler.getStyledTextParser().write(textElement.getStyledTextAttributes(), new AttributedString(textElement.getStyledText().getAttributedString().getIterator(), startIndex, endIndex).getIterator(), textElement.getText().substring(startIndex, endIndex));
        }
    };
    static /* synthetic */ Class class$net$sf$jasperreports$engine$fill$JRFillTextElement;

    protected JRFillTextElement(JRBaseFiller filler, JRTextElement textElement, JRFillObjectFactory factory) {
        super(filler, textElement, factory);
        this.reportFont = factory.getReportFont(textElement.getReportFont());
        this.createTextMeasurer();
        this.createTextChopper();
    }

    protected JRFillTextElement(JRFillTextElement textElement, JRFillCloneFactory factory) {
        super(textElement, factory);
        this.reportFont = textElement.reportFont;
        this.createTextMeasurer();
        this.createTextChopper();
    }

    private void createTextMeasurer() {
        this.textMeasurer = new TextMeasurer(this);
    }

    private void createTextChopper() {
        this.textChopper = this.isStyledText() ? styledTextChopper : simpleTextChopper;
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public byte getTextAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    public void setTextAlignment(byte horizontalAlignment) {
    }

    public byte getHorizontalAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    public Byte getOwnHorizontalAlignment() {
        return ((JRTextElement)this.parent).getOwnHorizontalAlignment();
    }

    public void setHorizontalAlignment(byte horizontalAlignment) {
    }

    public void setHorizontalAlignment(Byte horizontalAlignment) {
    }

    public byte getVerticalAlignment() {
        return JRStyleResolver.getVerticalAlignment(this);
    }

    public Byte getOwnVerticalAlignment() {
        return ((JRTextElement)this.parent).getOwnVerticalAlignment();
    }

    public void setVerticalAlignment(byte verticalAlignment) {
    }

    public void setVerticalAlignment(Byte verticalAlignment) {
    }

    public byte getRotation() {
        return JRStyleResolver.getRotation(this);
    }

    public Byte getOwnRotation() {
        return ((JRTextElement)this.parent).getOwnRotation();
    }

    public void setRotation(byte rotation) {
    }

    public void setRotation(Byte rotation) {
    }

    public byte getLineSpacing() {
        return JRStyleResolver.getLineSpacing(this);
    }

    public Byte getOwnLineSpacing() {
        return ((JRTextElement)this.parent).getOwnLineSpacing();
    }

    public void setLineSpacing(byte lineSpacing) {
    }

    public void setLineSpacing(Byte lineSpacing) {
    }

    public boolean isStyledText() {
        return JRStyleResolver.isStyledText(this);
    }

    public Boolean isOwnStyledText() {
        return ((JRTextElement)this.parent).isOwnStyledText();
    }

    public void setStyledText(boolean isStyledText) {
    }

    public void setStyledText(Boolean isStyledText) {
    }

    public JRBox getBox() {
        return this;
    }

    public JRFont getFont() {
        return this;
    }

    protected Map getStyledTextAttributes() {
        JRStyle style = this.getStyle();
        HashMap<TextAttribute, Color> styledTextAttributes = (HashMap<TextAttribute, Color>)this.styledTextAttributesMap.get(style);
        if (styledTextAttributes == null) {
            styledTextAttributes = new HashMap<TextAttribute, Color>();
            JRFontUtil.setAttributes(styledTextAttributes, this);
            styledTextAttributes.put(TextAttribute.FOREGROUND, this.getForecolor());
            if (this.getMode() == 1) {
                styledTextAttributes.put(TextAttribute.BACKGROUND, this.getBackcolor());
            }
            this.styledTextAttributesMap.put(style, styledTextAttributes);
        }
        return styledTextAttributes;
    }

    protected float getLineSpacingFactor() {
        return this.lineSpacingFactor;
    }

    protected void setLineSpacingFactor(float lineSpacingFactor) {
        this.lineSpacingFactor = lineSpacingFactor;
    }

    protected float getLeadingOffset() {
        return this.leadingOffset;
    }

    protected void setLeadingOffset(float leadingOffset) {
        this.leadingOffset = leadingOffset;
    }

    protected byte getRunDirection() {
        return this.isLeftToRight ? (byte)0 : 1;
    }

    protected float getTextHeight() {
        return this.textHeight;
    }

    protected void setTextHeight(float textHeight) {
        this.textHeight = textHeight;
    }

    protected int getTextStart() {
        return this.textStart;
    }

    protected void setTextStart(int textStart) {
        this.textStart = textStart;
    }

    protected int getTextEnd() {
        return this.textEnd;
    }

    protected void setTextEnd(int textEnd) {
        this.textEnd = textEnd;
    }

    protected String getRawText() {
        return this.rawText;
    }

    protected void setRawText(String rawText) {
        this.rawText = rawText;
        this.styledText = null;
    }

    protected void reset() {
        super.reset();
        this.isLeftToRight = true;
        this.lineSpacingFactor = 0.0f;
        this.leadingOffset = 0.0f;
        this.textHeight = 0.0f;
    }

    protected void rewind() {
        this.textStart = 0;
        this.textEnd = 0;
    }

    protected JRStyledText getStyledText() {
        String text;
        if (this.styledText == null && (text = this.getRawText()) != null) {
            block5: {
                if (this.isStyledText()) {
                    try {
                        this.styledText = this.filler.getStyledTextParser().parse(this.getStyledTextAttributes(), text);
                    }
                    catch (SAXException e) {
                        if (!log.isWarnEnabled()) break block5;
                        log.warn((Object)"Invalid styled text.", (Throwable)e);
                    }
                }
            }
            if (this.styledText == null) {
                this.styledText = new JRStyledText();
                this.styledText.append(text);
                this.styledText.addRun(new JRStyledText.Run(this.getStyledTextAttributes(), 0, text.length()));
            }
        }
        return this.styledText;
    }

    public String getText() {
        JRStyledText tmpStyledText = this.getStyledText();
        if (tmpStyledText == null) {
            return null;
        }
        return tmpStyledText.getText();
    }

    protected void chopTextElement(int availableStretchHeight) {
        JRStyledText tmpStyledText = this.getStyledText();
        if (tmpStyledText == null) {
            return;
        }
        String remainingText = this.getText().substring(this.getTextEnd());
        if (remainingText.length() == 0) {
            return;
        }
        this.textMeasurer.measure(tmpStyledText, remainingText, this.getTextEnd(), availableStretchHeight);
        this.isLeftToRight = this.textMeasurer.isLeftToRight();
        this.setTextHeight(this.textMeasurer.getTextHeight());
        if (this.getRotation() == 0) {
            this.setStretchHeight((int)this.getTextHeight() + this.getTopPadding() + this.getBottomPadding());
        } else {
            this.setStretchHeight(this.getHeight());
        }
        this.setTextStart(this.getTextEnd());
        this.setTextEnd(this.textMeasurer.getTextOffset());
        this.setLineSpacingFactor(this.textMeasurer.getLineSpacingFactor());
        this.setLeadingOffset(this.textMeasurer.getLeadingOffset());
    }

    public byte getBorder() {
        return JRStyleResolver.getBorder(this);
    }

    public Byte getOwnBorder() {
        return ((JRBox)((Object)this.parent)).getOwnBorder();
    }

    public void setBorder(byte border) {
    }

    public Color getBorderColor() {
        return JRStyleResolver.getBorderColor(this, this.getForecolor());
    }

    public Color getOwnBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnBorderColor();
    }

    public void setBorderColor(Color borderColor) {
    }

    public int getPadding() {
        return JRStyleResolver.getPadding(this);
    }

    public Integer getOwnPadding() {
        return ((JRBox)((Object)this.parent)).getOwnPadding();
    }

    public void setPadding(int padding) {
    }

    public byte getTopBorder() {
        return JRStyleResolver.getTopBorder(this);
    }

    public Byte getOwnTopBorder() {
        return ((JRBox)((Object)this.parent)).getOwnTopBorder();
    }

    public void setTopBorder(byte topBorder) {
    }

    public Color getTopBorderColor() {
        return JRStyleResolver.getTopBorderColor(this, this.getForecolor());
    }

    public Color getOwnTopBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnTopBorderColor();
    }

    public void setTopBorderColor(Color topBorderColor) {
    }

    public int getTopPadding() {
        return JRStyleResolver.getTopPadding(this);
    }

    public Integer getOwnTopPadding() {
        return ((JRBox)((Object)this.parent)).getOwnTopPadding();
    }

    public void setTopPadding(int topPadding) {
    }

    public byte getLeftBorder() {
        return JRStyleResolver.getLeftBorder(this);
    }

    public Byte getOwnLeftBorder() {
        return ((JRBox)((Object)this.parent)).getOwnLeftBorder();
    }

    public void setLeftBorder(byte leftBorder) {
    }

    public Color getLeftBorderColor() {
        return JRStyleResolver.getLeftBorderColor(this, this.getForecolor());
    }

    public Color getOwnLeftBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnLeftBorderColor();
    }

    public void setLeftBorderColor(Color leftBorderColor) {
    }

    public int getLeftPadding() {
        return JRStyleResolver.getLeftPadding(this);
    }

    public Integer getOwnLeftPadding() {
        return ((JRBox)((Object)this.parent)).getOwnLeftPadding();
    }

    public void setLeftPadding(int leftPadding) {
    }

    public byte getBottomBorder() {
        return JRStyleResolver.getBottomBorder(this);
    }

    public Byte getOwnBottomBorder() {
        return ((JRBox)((Object)this.parent)).getOwnBottomBorder();
    }

    public void setBottomBorder(byte bottomBorder) {
    }

    public Color getBottomBorderColor() {
        return JRStyleResolver.getBottomBorderColor(this, this.getForecolor());
    }

    public Color getOwnBottomBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnBottomBorderColor();
    }

    public void setBottomBorderColor(Color bottomBorderColor) {
    }

    public int getBottomPadding() {
        return JRStyleResolver.getBottomPadding(this);
    }

    public Integer getOwnBottomPadding() {
        return ((JRBox)((Object)this.parent)).getOwnBottomPadding();
    }

    public void setBottomPadding(int bottomPadding) {
    }

    public byte getRightBorder() {
        return JRStyleResolver.getRightBorder(this);
    }

    public Byte getOwnRightBorder() {
        return ((JRBox)((Object)this.parent)).getOwnRightBorder();
    }

    public void setRightBorder(byte rightBorder) {
    }

    public Color getRightBorderColor() {
        return JRStyleResolver.getRightBorderColor(this, this.getForecolor());
    }

    public Color getOwnRightBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnRightBorderColor();
    }

    public void setRightBorderColor(Color rightBorderColor) {
    }

    public int getRightPadding() {
        return JRStyleResolver.getRightPadding(this);
    }

    public Integer getOwnRightPadding() {
        return ((JRBox)((Object)this.parent)).getOwnRightPadding();
    }

    public void setRightPadding(int rightPadding) {
    }

    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    public void setReportFont(JRReportFont reportFont) {
    }

    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    public String getOwnFontName() {
        return ((JRFont)((Object)this.parent)).getOwnFontName();
    }

    public void setFontName(String fontName) {
    }

    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    public Boolean isOwnBold() {
        return ((JRFont)((Object)this.parent)).isOwnBold();
    }

    public void setBold(boolean isBold) {
    }

    public void setBold(Boolean isBold) {
    }

    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    public Boolean isOwnItalic() {
        return ((JRFont)((Object)this.parent)).isOwnItalic();
    }

    public void setItalic(boolean isItalic) {
    }

    public void setItalic(Boolean isItalic) {
    }

    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    public Boolean isOwnUnderline() {
        return ((JRFont)((Object)this.parent)).isOwnUnderline();
    }

    public void setUnderline(boolean isUnderline) {
    }

    public void setUnderline(Boolean isUnderline) {
    }

    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    public Boolean isOwnStrikeThrough() {
        return ((JRFont)((Object)this.parent)).isOwnStrikeThrough();
    }

    public void setStrikeThrough(boolean isStrikeThrough) {
    }

    public void setStrikeThrough(Boolean isStrikeThrough) {
    }

    public int getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    public Integer getOwnFontSize() {
        return ((JRFont)((Object)this.parent)).getOwnFontSize();
    }

    public void setFontSize(int size) {
    }

    public void setFontSize(Integer size) {
    }

    public int getSize() {
        return this.getFontSize();
    }

    public Integer getOwnSize() {
        return this.getOwnFontSize();
    }

    public void setSize(int size) {
    }

    public void setSize(Integer size) {
    }

    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    public String getOwnPdfFontName() {
        return ((JRFont)((Object)this.parent)).getOwnPdfFontName();
    }

    public void setPdfFontName(String pdfFontName) {
    }

    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    public String getOwnPdfEncoding() {
        return ((JRFont)((Object)this.parent)).getOwnPdfEncoding();
    }

    public void setPdfEncoding(String pdfEncoding) {
    }

    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    public Boolean isOwnPdfEmbedded() {
        return ((JRFont)((Object)this.parent)).isOwnPdfEmbedded();
    }

    public void setPdfEmbedded(boolean isPdfEmbedded) {
        this.setPdfEmbedded(isPdfEmbedded ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setPdfEmbedded(Boolean isPdfEmbedded) {
    }

    public void setBorder(Byte border) {
    }

    public void setPadding(Integer padding) {
    }

    public void setTopBorder(Byte topBorder) {
    }

    public void setTopPadding(Integer topPadding) {
    }

    public void setLeftBorder(Byte leftBorder) {
    }

    public void setLeftPadding(Integer leftPadding) {
    }

    public void setBottomBorder(Byte bottomBorder) {
    }

    public void setBottomPadding(Integer bottomPadding) {
    }

    public void setRightBorder(Byte rightBorder) {
    }

    public void setRightPadding(Integer rightPadding) {
    }

    public void setHeight(int height) {
        super.setHeight(height);
        this.createTextMeasurer();
    }

    public void setWidth(int width) {
        super.setWidth(width);
        this.createTextMeasurer();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static interface TextChopper {
        public String chop(JRFillTextElement var1, int var2, int var3);
    }
}

