/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.decorators.DecoratorDefinition;
import org.eclipse.ui.internal.decorators.FullDecoratorDefinition;
import org.eclipse.ui.internal.decorators.LightweightDecoratorDefinition;
import org.eclipse.ui.internal.registry.RegistryReader;

public class DecoratorRegistryReader
extends RegistryReader {
    private Collection values = new ArrayList();
    private Collection ids = new HashSet();

    public boolean readElement(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (this.ids.contains(id)) {
            this.logDuplicateId(element);
            return false;
        }
        this.ids.add(id);
        boolean noClass = element.getAttribute("class") == null;
        DecoratorDefinition desc = null;
        if (Boolean.valueOf(element.getAttribute("lightweight")).booleanValue() || noClass) {
            String iconPath = element.getAttribute("icon");
            if (noClass && iconPath == null) {
                DecoratorRegistryReader.logMissingElement(element, "icon");
                return false;
            }
            desc = new LightweightDecoratorDefinition(id, element);
        } else {
            desc = new FullDecoratorDefinition(id, element);
        }
        if (desc.getEnablement() == null) {
            DecoratorRegistryReader.logMissingElement(element, "enablement");
            return false;
        }
        this.values.add(desc);
        return true;
    }

    Collection readRegistry(IExtensionRegistry in) {
        this.values.clear();
        this.ids.clear();
        this.readRegistry(in, "org.eclipse.ui", "decorators");
        return this.values;
    }

    public Collection getValues() {
        return this.values;
    }

    protected void logDuplicateId(IConfigurationElement element) {
        DecoratorRegistryReader.logError(element, "Duplicate id found: " + element.getAttribute("id"));
    }
}

