/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.util.TreeSet;
import javax.security.jacc.URLPatternSpec;
import javax.security.jacc.WebResourcePermission;
import javax.servlet.http.HttpServletRequest;
import org.jboss.util.id.SerialVersion;

public final class WebUserDataPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = SerialVersion.version == 0 ? 141000L : 1L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("actions", class$java$lang$String == null ? (class$java$lang$String = WebUserDataPermission.class$("java.lang.String")) : class$java$lang$String)};
    private transient URLPatternSpec urlSpec;
    private transient String httpMethodsString;
    private transient String transportType;
    private transient TreeSet httpMethods;
    static /* synthetic */ Class class$java$lang$String;

    public WebUserDataPermission(HttpServletRequest request) {
        this(WebResourcePermission.requestURI(request), WebUserDataPermission.requestActions(request));
    }

    public WebUserDataPermission(String name, String actions) {
        super(name == null ? "/" : name);
        if (name == null) {
            name = "/";
        }
        this.urlSpec = new URLPatternSpec(name);
        this.parseActions(actions);
    }

    public WebUserDataPermission(String urlPatternSpec, String[] httpMethods, String transportType) {
        super(urlPatternSpec);
        this.urlSpec = new URLPatternSpec(urlPatternSpec);
        Object[] methodInfo = WebResourcePermission.canonicalMethods(httpMethods);
        this.httpMethods = (TreeSet)methodInfo[0];
        this.httpMethodsString = (String)methodInfo[1];
        if (transportType != null && transportType.equalsIgnoreCase("NONE")) {
            transportType = null;
        }
        this.transportType = transportType;
    }

    public boolean equals(Object p) {
        boolean equals = false;
        if (p == null || !(p instanceof WebUserDataPermission)) {
            return false;
        }
        WebUserDataPermission perm = (WebUserDataPermission)p;
        equals = this.urlSpec.equals(perm.urlSpec);
        if (equals) {
            String a0 = this.getActions();
            String a1 = perm.getActions();
            equals = a0 != null && a0.equals(a1) || a0 == a1;
        }
        return equals;
    }

    public String getActions() {
        String actions = null;
        if (this.httpMethodsString != null) {
            actions = this.transportType != null ? this.httpMethodsString + ":" + this.transportType : this.httpMethodsString;
        } else if (this.transportType != null) {
            actions = ":" + this.transportType;
        }
        return actions;
    }

    public int hashCode() {
        int hashCode = this.urlSpec.hash();
        if (this.httpMethods != null) {
            hashCode += this.httpMethods.hashCode();
        }
        return hashCode;
    }

    public boolean implies(Permission p) {
        if (p == null || !(p instanceof WebUserDataPermission)) {
            return false;
        }
        WebUserDataPermission perm = (WebUserDataPermission)p;
        boolean implies = this.urlSpec.implies(perm.urlSpec);
        if (implies) {
            if (this.httpMethods != null) {
                implies = this.httpMethods.containsAll(perm.httpMethods);
            }
            if (implies && this.transportType != null) {
                implies = this.transportType.equals(perm.transportType);
            }
        }
        return implies;
    }

    private static String requestActions(HttpServletRequest request) {
        String actions = request.getMethod() + (request.isSecure() ? ":CONFIDENTIAL" : "");
        return actions;
    }

    private void parseActions(String actions) {
        int colon;
        if (actions != null && (colon = actions.indexOf(58)) >= 0) {
            this.transportType = actions.substring(colon + 1);
            if (this.transportType.equalsIgnoreCase("NONE")) {
                this.transportType = null;
            }
            actions = actions.substring(0, colon);
        }
        Object[] methodInfo = WebResourcePermission.canonicalMethods(actions);
        this.httpMethods = (TreeSet)methodInfo[0];
        this.httpMethodsString = (String)methodInfo[1];
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = ois.readFields();
        String actions = (String)fields.get("actions", null);
        this.parseActions(actions);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField fields = oos.putFields();
        fields.put("actions", this.getActions());
        oos.writeFields();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

