/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.http.dialog;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.PositiveNumberVerifyListener;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.http.action.AddHttp;
import com.clustercontrol.http.action.GetHttp;
import com.clustercontrol.http.action.GetHttpStringValueListTableDefine;
import com.clustercontrol.http.action.ModifyHttp;
import com.clustercontrol.http.bean.MonitorHttpInfo;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.monitor.run.composite.MonitorBasicScopeComposite;
import com.clustercontrol.monitor.run.composite.MonitorRuleComposite;
import com.clustercontrol.monitor.run.composite.NumericRunJobComposite;
import com.clustercontrol.monitor.run.composite.NumericValueInfoComposite;
import com.clustercontrol.monitor.run.composite.StringValueInfoComposite;
import com.clustercontrol.notify.composite.NotifyInfoComposite;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HttpCreateDialog
extends CommonDialog {
    public static final int WIDTH_TITLE = 5;
    public static final int WIDTH_VALUE = 2;
    private MonitorInfo inputData = null;
    private ValidateResult validateResult = null;
    private String monitorId = null;
    MonitorBasicScopeComposite m_monitorBasic = null;
    private MonitorRuleComposite m_monitorRule = null;
    private Text m_textRequestUrl = null;
    protected Text m_textTimeout = null;
    private NumericValueInfoComposite m_numericValueInfo = null;
    private StringValueInfoComposite m_stringValueInfo = null;
    private NotifyInfoComposite m_notifyInfo = null;
    private Button m_checkJobRun = null;
    private NumericRunJobComposite m_jobRun = null;
    private Button confirmValid = null;
    private int m_monitorType;

    public HttpCreateDialog(Shell parent) {
        super(parent);
    }

    public HttpCreateDialog(Shell parent, int monitorType) {
        super(parent);
        this.m_monitorType = monitorType;
    }

    public HttpCreateDialog(Shell parent, String monitorId, int monitorType) {
        super(parent);
        this.monitorId = monitorId;
        this.m_monitorType = monitorType;
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.http.create.modify"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        this.m_monitorBasic = new MonitorBasicScopeComposite(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_monitorBasic.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"monitor.rule")) + " : ");
        Group groupRule = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupRule.setLayoutData((Object)gridData);
        this.m_monitorRule = new MonitorRuleComposite((Composite)groupRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_monitorRule.setLayoutData((Object)gridData);
        label = new Label((Composite)groupRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"check.rule")) + " : ");
        Group groupCheckRule = new Group((Composite)groupRule, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupCheckRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupCheckRule.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"request.url")) + " : ");
        this.m_textRequestUrl = new Text((Composite)groupCheckRule, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textRequestUrl.addVerifyListener((VerifyListener)new StringVerifyListener(2083));
        this.m_textRequestUrl.setLayoutData((Object)gridData);
        this.m_textRequestUrl.setText("http://");
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"time.out.sec")) + " : ");
        this.m_textTimeout = new Text((Composite)groupCheckRule, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textTimeout.addVerifyListener((VerifyListener)new PositiveNumberVerifyListener(1, Short.MAX_VALUE));
        this.m_textTimeout.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        if (this.m_monitorType == 1) {
            label = new Label(parent, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 15;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
            label.setText(String.valueOf(Messages.getString((String)"def.result.node")) + " : ");
            Group groupDefResultNode = new Group(parent, 0);
            layout = new GridLayout(1, true);
            layout.marginWidth = 5;
            layout.marginHeight = 5;
            layout.numColumns = 1;
            groupDefResultNode.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalSpan = 15;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            groupDefResultNode.setLayoutData((Object)gridData);
            this.m_numericValueInfo = new NumericValueInfoComposite((Composite)groupDefResultNode, 0, true, Messages.getString((String)"time.period.sec"), Messages.getString((String)"time.period.sec"), 2);
            this.m_numericValueInfo.setInputRange1(0, Short.MAX_VALUE);
            this.m_numericValueInfo.setInputRange2(0, Short.MAX_VALUE);
            gridData = new GridData();
            gridData.horizontalSpan = 15;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.m_numericValueInfo.setLayoutData((Object)gridData);
        }
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"notify.attribute")) + " : ");
        Group groupNotifyAttribute = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupNotifyAttribute.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupNotifyAttribute.setLayoutData((Object)gridData);
        if (this.m_monitorType == 1) {
            this.m_notifyInfo = new NotifyInfoComposite((Composite)groupNotifyAttribute, 0);
        } else if (this.m_monitorType == 2) {
            this.m_notifyInfo = new NotifyInfoComposite((Composite)groupNotifyAttribute, 0, Messages.getString((String)"notify.id.default"));
        }
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_notifyInfo.setLayoutData((Object)gridData);
        if (this.m_monitorType == 1) {
            this.m_checkJobRun = new Button((Composite)groupNotifyAttribute, 32);
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.m_checkJobRun.setLayoutData((Object)gridData);
            this.m_checkJobRun.setText(String.valueOf(Messages.getString((String)"run")) + " : ");
            this.m_checkJobRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    HttpCreateDialog.this.m_jobRun.setEnabled(HttpCreateDialog.this.m_checkJobRun.getSelection());
                }
            });
            Group groupRunJob = new Group((Composite)groupNotifyAttribute, 0);
            layout = new GridLayout(1, true);
            layout.marginWidth = 5;
            layout.marginHeight = 5;
            layout.numColumns = 1;
            groupRunJob.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalSpan = 15;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            groupRunJob.setLayoutData((Object)gridData);
            this.m_jobRun = new NumericRunJobComposite((Composite)groupRunJob, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.m_jobRun.setLayoutData((Object)gridData);
        } else if (this.m_monitorType == 2) {
            label = new Label(parent, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 15;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
            label.setText(String.valueOf(Messages.getString((String)"def.result.node")) + " : ");
            Group groupDefResult = new Group(parent, 0);
            layout = new GridLayout(1, true);
            layout.marginWidth = 5;
            layout.marginHeight = 5;
            layout.numColumns = 1;
            groupDefResult.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalSpan = 15;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            groupDefResult.setLayoutData((Object)gridData);
            ArrayList tableDefine = GetHttpStringValueListTableDefine.get();
            this.m_stringValueInfo = new StringValueInfoComposite((Composite)groupDefResult, 0, tableDefine);
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.m_stringValueInfo.setLayoutData((Object)gridData);
        }
        this.confirmValid = new Button(parent, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.confirmValid.setLayoutData((Object)gridData);
        this.confirmValid.setText(Messages.getString((String)"setting.valid.confirmed"));
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 15;
        line.setLayoutData((Object)gridData);
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        MonitorInfo info = null;
        info = this.monitorId == null ? new MonitorInfo() : new GetHttp().getHttp(this.monitorId, this.m_monitorType);
        this.setInputData(info);
    }

    public MonitorInfo getInputData() {
        return this.inputData;
    }

    protected void setInputData(MonitorInfo monitor) {
        this.m_monitorBasic.setInputData(monitor);
        this.m_monitorRule.setInputData(monitor);
        MonitorHttpInfo httpInfo = (MonitorHttpInfo)monitor.getCheckInfo();
        if (httpInfo == null) {
            httpInfo = new MonitorHttpInfo();
        }
        if (httpInfo != null) {
            if (httpInfo.getRequestUrl() != null) {
                this.m_textRequestUrl.setText(httpInfo.getRequestUrl());
            }
            this.m_textTimeout.setText(Integer.toString(httpInfo.getTimeout()));
        }
        if (monitor.getNotifyId() != null) {
            this.m_notifyInfo.setText(monitor.getNotifyId());
        }
        if (monitor.getApplication() != null) {
            this.m_notifyInfo.setApplication(monitor.getApplication());
        }
        if (this.m_monitorType == 1) {
            this.m_numericValueInfo.setInputData(monitor);
            this.m_checkJobRun.setSelection(YesNoConstant.typeToBoolean((int)monitor.getJobRun()));
            this.m_jobRun.setInputData(monitor);
            this.m_jobRun.setEnabled(YesNoConstant.typeToBoolean((int)monitor.getJobRun()));
        } else if (this.m_monitorType == 2) {
            this.m_stringValueInfo.setInputData(monitor);
        }
        if (monitor.getValid() == 1) {
            this.confirmValid.setSelection(true);
        }
    }

    protected MonitorInfo createInputData() {
        MonitorInfo info = new MonitorInfo();
        info.setMonitorTypeId("HTTP");
        info.setMonitorType(this.m_monitorType);
        this.validateResult = this.m_monitorBasic.createInputData(info);
        if (this.validateResult != null) {
            return null;
        }
        this.validateResult = this.m_monitorRule.createInputData(info);
        if (this.validateResult != null) {
            return null;
        }
        info.setMonitorBlock(0);
        MonitorHttpInfo httpInfo = new MonitorHttpInfo();
        httpInfo.setMonitorTypeId("HTTP");
        httpInfo.setMonitorId(info.getMonitorId());
        if (this.m_textRequestUrl.getText() != null && !"".equals(this.m_textRequestUrl.getText().trim())) {
            String url = this.m_textRequestUrl.getText();
            if (url.length() > 0 && !url.startsWith("http://") && !url.startsWith("https://")) {
                this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.http.5"));
                return null;
            }
        } else {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.http.1"));
            return null;
        }
        httpInfo.setRequestUrl(this.m_textRequestUrl.getText());
        if (this.m_textTimeout.getText() != null && !"".equals(this.m_textTimeout.getText().trim())) {
            try {
                httpInfo.setTimeout(Integer.valueOf(this.m_textTimeout.getText().trim()).intValue());
            }
            catch (NumberFormatException numberFormatException) {
                this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.42"));
                return null;
            }
        } else {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.42"));
            return null;
        }
        info.setCheckInfo((MonitorCheckInfo)httpInfo);
        if (this.m_notifyInfo.getText() != null && !"".equals(this.m_notifyInfo.getText().trim())) {
            info.setNotifyId(this.m_notifyInfo.getText());
        }
        if (this.m_notifyInfo.getApplication() != null && !"".equals(this.m_notifyInfo.getApplication().trim())) {
            info.setApplication(this.m_notifyInfo.getApplication());
        } else if (this.m_notifyInfo.getText() != null && !"".equals(this.m_notifyInfo.getText().trim())) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.10"));
            return null;
        }
        if (this.m_monitorType == 1) {
            this.validateResult = this.m_numericValueInfo.createInputData(info);
            if (this.validateResult != null) {
                return null;
            }
            int runInterval = info.getRunInterval();
            int timeout = httpInfo.getTimeout();
            int infoUpper = (int)((MonitorNumericValueInfo)info.getJudgementInfo().get(0)).getThresholdUpperLimit();
            int warnUpper = (int)((MonitorNumericValueInfo)info.getJudgementInfo().get(1)).getThresholdUpperLimit();
            if (runInterval <= timeout) {
                this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.43"));
                return null;
            }
            if (timeout <= infoUpper) {
                this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.50"));
                return null;
            }
            if (timeout <= warnUpper) {
                this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.51"));
                return null;
            }
            info.setJobRun(YesNoConstant.booleanToType((boolean)this.m_checkJobRun.getSelection()));
            this.validateResult = this.m_jobRun.createInputData(info);
            if (this.validateResult != null) {
                return null;
            }
        } else if (this.m_monitorType == 2) {
            this.validateResult = this.m_stringValueInfo.createInputData(info);
            if (this.validateResult != null) {
                return null;
            }
            if (this.m_stringValueInfo.isNotify() && (this.m_notifyInfo.getApplication() == null || "".equals(this.m_notifyInfo.getApplication().trim()))) {
                this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.10"));
                return null;
            }
            info.setJobRun(1);
        }
        if (this.confirmValid.getSelection()) {
            info.setValid(1);
        } else {
            info.setValid(0);
        }
        return info;
    }

    protected ValidateResult validate() {
        this.inputData = this.createInputData();
        if (this.inputData != null) {
            return super.validate();
        }
        return this.validateResult;
    }

    protected boolean action() {
        boolean result = false;
        MonitorInfo info = this.inputData;
        if (info != null) {
            result = this.monitorId == null ? new AddHttp().add(info) : new ModifyHttp().modify(info);
        }
        return result;
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    private void setValidateResult(String id, String message) {
        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }
}

