/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.help.internal.toc.Anchor;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.toc.TocBuilder;
import org.eclipse.help.internal.util.ResourceLocator;

public class TocFile {
    protected Toc toc;
    protected String plugin;
    protected String href;
    protected boolean primary;
    protected String locale;
    protected String extraDir;
    protected Map anchors;

    public TocFile(String plugin, String href, boolean primary, String locale, String extraDir) {
        this.plugin = plugin;
        this.href = href;
        this.primary = primary;
        this.locale = locale;
        this.extraDir = extraDir;
    }

    protected String getHref() {
        return this.href;
    }

    public final String getPluginID() {
        return this.plugin;
    }

    protected InputStream getInputStream() {
        InputStream stream = null;
        try {
            stream = this.plugin != null ? ResourceLocator.openFromPlugin(this.plugin, this.href, this.locale) : new FileInputStream(this.href);
        }
        catch (IOException iOException) {}
        return stream;
    }

    public Toc getToc() {
        return this.toc;
    }

    public void setToc(Toc toc) {
        this.toc = toc;
    }

    public void addAnchor(Anchor a) {
        if (this.anchors == null) {
            this.anchors = new HashMap();
        }
        this.anchors.put(a.getID(), a);
    }

    public Anchor getAnchor(String id) {
        if (this.anchors == null || this.anchors.get(id) == null) {
            return null;
        }
        return (Anchor)this.anchors.get(id);
    }

    public void build(TocBuilder builder) {
        builder.buildTocFile(this);
    }

    public String toString() {
        return String.valueOf(this.plugin) + "/" + this.href;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public String getExtraDir() {
        return this.extraDir;
    }

    public String getLocale() {
        return this.locale;
    }
}

