/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.maintenance.dialog;

import com.clustercontrol.bean.Schedule;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.maintenance.action.DeleteMaintenance;
import com.clustercontrol.maintenance.action.GetMaintenance;
import com.clustercontrol.maintenance.action.GetSchedule;
import com.clustercontrol.maintenance.action.ModifyMaintenance;
import com.clustercontrol.maintenance.bean.ScheduleInfo;
import com.clustercontrol.maintenance.composite.MaintenanceListComposite;
import com.clustercontrol.maintenance.dialog.MaintenanceDialog;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoData;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class MaintenanceListDialog
extends CommonDialog {
    private MaintenanceListComposite maintenanceList = null;
    private Button buttonAdd = null;
    private Button buttonModify = null;
    private Button buttonDelete = null;
    private Button buttonValid = null;
    private Button buttonInvalid = null;

    public MaintenanceListDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected Point getInitialSize() {
        return new Point(800, 350);
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.maintenance.list"));
        GridLayout layout = new GridLayout(8, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 8;
        parent.setLayout((Layout)layout);
        this.maintenanceList = new MaintenanceListComposite(parent, 2048);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 7;
        this.maintenanceList.setLayoutData(gridData);
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite.setLayoutData((Object)gridData);
        this.buttonAdd = this.createButton(composite, Messages.getString((String)"add"));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MaintenanceDialog dialog = new MaintenanceDialog(MaintenanceListDialog.this.getParentShell());
                if (dialog.open() == 0) {
                    MaintenanceListDialog.this.maintenanceList.update();
                }
            }
        });
        new Label(composite, 0);
        this.buttonModify = this.createButton(composite, Messages.getString((String)"modify"));
        this.buttonModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String maintenanceId = null;
                Table table = MaintenanceListDialog.this.maintenanceList.getTableViewer().getTable();
                TableItem[] item = table.getSelection();
                if (item != null && item.length > 0) {
                    try {
                        maintenanceId = (String)((ArrayList)item[0].getData()).get(0);
                    }
                    catch (Exception exception) {}
                }
                if (maintenanceId != null) {
                    MaintenanceDialog dialog = new MaintenanceDialog(MaintenanceListDialog.this.getParentShell(), maintenanceId, false);
                    ArrayList scheduleList = new GetSchedule().getSchedule(maintenanceId);
                    dialog.setSchedule(scheduleList);
                    if (dialog.open() == 0) {
                        int selectIndex = table.getSelectionIndex();
                        MaintenanceListDialog.this.maintenanceList.update();
                        table.setSelection(selectIndex);
                    }
                } else {
                    MessageBox box = new MessageBox(MaintenanceListDialog.this.getShell(), 40);
                    box.setText(Messages.getString((String)"warning"));
                    box.setMessage(Messages.getString((String)"message.maintenance.8"));
                    box.open();
                }
            }
        });
        new Label(composite, 0);
        this.buttonDelete = this.createButton(composite, Messages.getString((String)"delete"));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String maintenanceId = null;
                Table table = MaintenanceListDialog.this.maintenanceList.getTableViewer().getTable();
                TableItem[] item = table.getSelection();
                if (item != null && item.length > 0) {
                    try {
                        maintenanceId = (String)((ArrayList)item[0].getData()).get(0);
                    }
                    catch (Exception exception) {}
                }
                if (maintenanceId != null) {
                    MessageBox confirmBox = new MessageBox(MaintenanceListDialog.this.getShell(), 296);
                    confirmBox.setText(Messages.getString((String)"confirmed"));
                    Object[] args = new String[]{maintenanceId};
                    String message = Messages.getString((String)"message.maintenance.7", (Object[])args);
                    confirmBox.setMessage(message);
                    if (confirmBox.open() == 32) {
                        boolean result = new DeleteMaintenance().delete(maintenanceId);
                        if (result) {
                            MessageBox box = new MessageBox(MaintenanceListDialog.this.getShell(), 34);
                            box.setText(Messages.getString((String)"successful"));
                            box.setMessage(Messages.getString((String)"message.maintenance.5", (Object[])args));
                            box.open();
                            MaintenanceListDialog.this.maintenanceList.update();
                        } else {
                            MessageBox box = new MessageBox(MaintenanceListDialog.this.getShell(), 33);
                            box.setText(Messages.getString((String)"failed"));
                            box.setMessage(Messages.getString((String)"message.maintenance.6", (Object[])args));
                            box.open();
                        }
                    }
                } else {
                    MessageBox box = new MessageBox(MaintenanceListDialog.this.getShell(), 40);
                    box.setText(Messages.getString((String)"warning"));
                    box.setMessage(Messages.getString((String)"message.maintenance.8"));
                    box.open();
                }
            }
        });
        new Label(composite, 0);
        new Label(composite, 0);
        this.buttonValid = this.createButton(composite, Messages.getString((String)"valid"));
        this.buttonValid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MaintenanceListDialog.this.setValid(1);
            }
        });
        this.buttonInvalid = this.createButton(composite, Messages.getString((String)"invalid"));
        this.buttonInvalid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MaintenanceListDialog.this.setValid(0);
            }
        });
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
    }

    protected ValidateResult validate() {
        return super.validate();
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(label);
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }

    public void setValid(int valid) {
        ArrayList<String> list = this.maintenanceList.getSelectionData();
        if (list != null && list.size() > 0) {
            StringBuilder maintenanceIds = new StringBuilder();
            int i = 0;
            while (i < list.size()) {
                if (i > 0) {
                    maintenanceIds.append(", ");
                }
                maintenanceIds.append(list.get(i));
                ++i;
            }
            Object[] confirmArgs = new String[]{maintenanceIds.toString()};
            String message = valid == 1 ? Messages.getString((String)"message.maintenance.14", (Object[])confirmArgs) : Messages.getString((String)"message.maintenance.15", (Object[])confirmArgs);
            if (!MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)message)) {
                return;
            }
            int i2 = 0;
            while (i2 < list.size()) {
                String maintenanceId = list.get(i2);
                if (maintenanceId != null && !maintenanceId.equals("")) {
                    MaintenanceInfoData info = new GetMaintenance().getMaintenanceInfo(maintenanceId);
                    ArrayList schedule = new GetSchedule().getSchedule(maintenanceId);
                    ScheduleInfo scheduleInfo = new ScheduleInfo();
                    scheduleInfo.setId(maintenanceId);
                    scheduleInfo.setName((String)schedule.get(1));
                    scheduleInfo.setJobId((String)schedule.get(2));
                    scheduleInfo.setJobName((String)schedule.get(3));
                    scheduleInfo.setCalendarId((String)schedule.get(4));
                    scheduleInfo.setSchedule((Schedule)schedule.get(5));
                    scheduleInfo.setValid(valid);
                    scheduleInfo.setCreateUser((String)schedule.get(7));
                    scheduleInfo.setCreateTime((Date)schedule.get(8));
                    scheduleInfo.setUpdateUser((String)schedule.get(9));
                    scheduleInfo.setUpdateTime((Date)schedule.get(10));
                    info.setValid_flg(Integer.valueOf(valid));
                    boolean result = new ModifyMaintenance().modify(info, scheduleInfo);
                    if (!result) {
                        Object[] args = new String[]{maintenanceId};
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.maintenance.4", (Object[])args));
                    }
                }
                ++i2;
            }
            int selectIndex = this.maintenanceList.getTableViewer().getTable().getSelectionIndex();
            this.maintenanceList.update();
            this.maintenanceList.getTableViewer().getTable().setSelection(selectIndex);
        } else {
            MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)Messages.getString((String)"message.maintenance.9"));
        }
    }
}

