/*
 * Decompiled with CFR 0.152.
 */
package javax.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;

public class QueueRequestor {
    private QueueSession queueSession = null;
    private Queue queue = null;
    private QueueSender requestSender = null;
    private QueueReceiver replyReceiver = null;
    private TemporaryQueue replyQueue = null;

    public QueueRequestor(QueueSession session, Queue queue) throws JMSException {
        this.queueSession = session;
        this.queue = queue;
        this.requestSender = this.queueSession.createSender(queue);
        this.replyQueue = this.queueSession.createTemporaryQueue();
        this.replyReceiver = this.queueSession.createReceiver(this.replyQueue);
    }

    public Message request(Message message) throws JMSException {
        message.setJMSReplyTo(this.replyQueue);
        message.setJMSDeliveryMode(1);
        this.requestSender.send(message);
        return this.replyReceiver.receive();
    }

    public void close() throws JMSException {
        this.replyReceiver.close();
        this.replyQueue.delete();
        this.queueSession.close();
    }
}

